/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.x509.revocation;

import com.entrust.toolkit.asn1.structures.DistributionPointName;
import com.entrust.toolkit.asn1.structures.OldDistributionPoint;
import com.entrust.toolkit.exceptions.CertificationException;
import com.entrust.toolkit.exceptions.CertificationSignatureException;
import com.entrust.toolkit.exceptions.ExtensionException;
import com.entrust.toolkit.exceptions.RevocationException;
import com.entrust.toolkit.x509.ValidationInfo;
import com.entrust.toolkit.x509.extensions.OldCRLDistributionPoints;
import com.entrust.toolkit.x509.revocation.RevocationStore;
import iaik.asn1.ASN1Type;
import iaik.asn1.structures.DistributionPoint;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.Name;
import iaik.x509.RevokedCertificate;
import iaik.x509.V3Extension;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.AuthorityKeyIdentifier;
import iaik.x509.extensions.BasicConstraints;
import iaik.x509.extensions.CRLDistributionPoints;
import iaik.x509.extensions.IssuingDistributionPoint;
import iaik.x509.extensions.SubjectKeyIdentifier;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public abstract class X509CRLRS
extends RevocationStore {
    private boolean b = false;
    private long a = 1209600000L;
    protected ValidationInfo m_validationInfo = null;
    static final boolean c = false;

    void a(X509CRL x509CRL, X509Certificate x509Certificate) throws ExtensionException {
        this.m_validationInfo.getExtensionTester().validate(x509CRL, x509Certificate);
    }

    protected void validateCRL(X509CRL x509CRL, X509Certificate x509Certificate, X509Certificate[] x509CertificateArray) throws CertificationException {
        GeneralName generalName;
        Enumeration enumeration;
        V3Extension v3Extension;
        Enumeration enumeration2;
        Date date = null;
        try {
            date = x509CRL.getNextUpdate();
        }
        catch (Exception exception) {
            date = null;
        }
        if (date != null) {
            long l = 2L;
            if (this.m_validationInfo.getClientSettings() != null) {
                l = this.m_validationInfo.getClientSettings().getCRLGracePeriod();
            }
            long l2 = l * 60L * 60L * 1000L;
            if (date.getTime() + l2 < new Date().getTime()) {
                throw new CertificationException("CRL has expired.");
            }
        } else {
            Date date2 = x509CRL.getThisUpdate();
            if (date2 != null && this.a > 0L) {
                long l = date2.getTime();
                long l3 = new Date().getTime();
                if (l3 - l > this.a) {
                    throw new CertificationException("CRL is older than the maximum allowed CRL lifetime.");
                }
            }
        }
        Principal principal = null;
        CRLDistributionPoints cRLDistributionPoints = null;
        try {
            cRLDistributionPoints = (CRLDistributionPoints)x509Certificate.getExtension(CRLDistributionPoints.oid);
        }
        catch (X509ExtensionInitException x509ExtensionInitException) {
            cRLDistributionPoints = null;
        }
        if (cRLDistributionPoints != null && (enumeration2 = cRLDistributionPoints.getDistributionPoints()) != null) {
            while (enumeration2.hasMoreElements() && principal == null) {
                DistributionPoint distributionPoint = (DistributionPoint)enumeration2.nextElement();
                v3Extension = distributionPoint.getCrlIssuer();
                if (v3Extension == null || (enumeration = v3Extension.getNames()) == null) continue;
                while (enumeration.hasMoreElements() && principal == null) {
                    Principal principal2;
                    generalName = (GeneralName)enumeration.nextElement();
                    if (generalName.getType() != GeneralName.directoryName || !(principal2 = (Principal)generalName.getName()).equals(x509CRL.getIssuerDN())) continue;
                    principal = principal2;
                }
            }
        }
        if (principal == null) {
            if (x509Certificate.getIssuerDN().equals(x509CRL.getIssuerDN())) {
                principal = x509Certificate.getIssuerDN();
            } else {
                throw new CertificationException("The CRL was not issued by a valid CRL distribution point.");
            }
        }
        Object object = null;
        AuthorityKeyIdentifier authorityKeyIdentifier = null;
        try {
            v3Extension = x509CRL.getExtension(AuthorityKeyIdentifier.oid);
            if (v3Extension != null && v3Extension instanceof AuthorityKeyIdentifier) {
                authorityKeyIdentifier = (AuthorityKeyIdentifier)v3Extension;
            }
        }
        catch (Exception exception) {
            throw new CertificationException("CRL Issuer Certificate could not be found." + exception.toString());
        }
        int n2 = 0;
        while (n2 < x509CertificateArray.length && object == null) {
            if (x509CertificateArray[n2].getSubjectDN().equals(principal)) {
                try {
                    if (this.a(x509CertificateArray[n2], authorityKeyIdentifier)) {
                        object = x509CertificateArray[n2];
                        break;
                    }
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
        if (object == null) {
            try {
                if (this.m_validationInfo != null && this.m_validationInfo.getClientSettings() != null) {
                    enumeration = this.m_validationInfo.getClientSettings().getCaCertificate();
                    if (this.a((X509Certificate)enumeration, authorityKeyIdentifier)) {
                        object = enumeration;
                    } else {
                        generalName = this.m_validationInfo.getClientSettings().getRootCaCertificate();
                        if (generalName != null && this.a((X509Certificate)generalName, authorityKeyIdentifier)) {
                            object = generalName;
                        }
                    }
                }
            }
            catch (CertificateException certificateException) {}
        }
        if (object == null) {
            throw new CertificationException("CRL Issuer Certificate could not be found.");
        }
        try {
            x509CRL.verify(object.getPublicKey());
            this.a(x509CRL, (X509Certificate)object);
            this.b = true;
            return;
        }
        catch (Exception exception) {
            throw new CertificationSignatureException("CRL signature cannot be validated");
        }
    }

    public void setMaximumCRLLifetime(long l) {
        this.a = l;
    }

    protected abstract void loadCRLs(ASN1Type var1, Vector var2, boolean var3, X509Certificate var4, X509Certificate[] var5);

    private boolean a(X509Certificate x509Certificate, AuthorityKeyIdentifier authorityKeyIdentifier) {
        block10: {
            if (authorityKeyIdentifier == null) {
                return false;
            }
            try {
                SubjectKeyIdentifier subjectKeyIdentifier = null;
                subjectKeyIdentifier = (SubjectKeyIdentifier)x509Certificate.getExtension(SubjectKeyIdentifier.oid);
                byte[] byArray = authorityKeyIdentifier.getKeyIdentifier();
                if (byArray == null) break block10;
                try {
                    String string = new String(byArray, "iso_8859-1");
                    String string2 = new String(subjectKeyIdentifier.get(), "iso_8859-1");
                    if (string.equals(string2)) {
                        return true;
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    try {
                        String string = new String(byArray, "iso8859-1");
                        String string3 = new String(subjectKeyIdentifier.get(), "iso8859-1");
                        if (string.equals(string3)) {
                            return true;
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException2) {
                        String string = new String(byArray);
                        String string4 = new String(subjectKeyIdentifier.get());
                        if (string.equals(string4)) {
                            return true;
                        }
                    }
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }

    protected synchronized Vector findCRL(X509Certificate x509Certificate, X509Certificate[] x509CertificateArray) {
        Vector vector = new Vector();
        boolean bl = false;
        if (this.m_validationInfo.getClientSettings() != null) {
            bl = this.m_validationInfo.getClientSettings().getSkipRLcheck();
        }
        CRLDistributionPoints cRLDistributionPoints = null;
        try {
            cRLDistributionPoints = (CRLDistributionPoints)x509Certificate.getExtension(CRLDistributionPoints.oid);
        }
        catch (X509ExtensionInitException x509ExtensionInitException) {
            throw new NullPointerException();
        }
        if (cRLDistributionPoints != null) {
            Enumeration enumeration = cRLDistributionPoints.getDistributionPoints();
            while (enumeration.hasMoreElements()) {
                ASN1Type aSN1Type;
                Object object;
                DistributionPoint distributionPoint = (DistributionPoint)enumeration.nextElement();
                Name name = (Name)x509Certificate.getIssuerDN();
                GeneralNames generalNames = distributionPoint.getCrlIssuer();
                if (generalNames != null) {
                    object = generalNames.getNames();
                    while (object.hasMoreElements()) {
                        aSN1Type = (GeneralName)object.nextElement();
                        if (aSN1Type.getType() != GeneralName.directoryName) continue;
                        name = (Name)aSN1Type.getName();
                    }
                }
                object = name;
                aSN1Type = distributionPoint.getDistributionPointName();
                if (aSN1Type != null) {
                    GeneralName generalName;
                    boolean bl2 = false;
                    Enumeration enumeration2 = ((GeneralNames)aSN1Type).getNames();
                    while (enumeration2.hasMoreElements()) {
                        generalName = (GeneralName)enumeration2.nextElement();
                        if (generalName.getType() != GeneralName.directoryName) continue;
                        bl2 = true;
                    }
                    if (bl2) {
                        generalName = new DistributionPointName(aSN1Type);
                        object = generalName.getDirectoryName((Name)object);
                        this.loadCRLs((ASN1Type)object, vector, false, x509Certificate, x509CertificateArray);
                        if (!bl) {
                            this.loadCRLs((ASN1Type)object, vector, true, x509Certificate, x509CertificateArray);
                        }
                    } else {
                        this.loadCRLs(aSN1Type, vector, false, x509Certificate, x509CertificateArray);
                        if (!bl) {
                            this.loadCRLs(aSN1Type, vector, true, x509Certificate, x509CertificateArray);
                        }
                    }
                }
                if (!this.b) {
                    continue;
                }
                break;
            }
        } else {
            try {
                cRLDistributionPoints = (CRLDistributionPoints)x509Certificate.getExtension(OldCRLDistributionPoints.oid);
            }
            catch (X509ExtensionInitException x509ExtensionInitException) {
                throw new NullPointerException();
            }
            if (cRLDistributionPoints != null) {
                Enumeration enumeration = cRLDistributionPoints.getDistributionPoints();
                while (enumeration.hasMoreElements()) {
                    OldDistributionPoint oldDistributionPoint = (OldDistributionPoint)enumeration.nextElement();
                    Name name = oldDistributionPoint.getOldDistributionPointName();
                    this.loadCRLs((ASN1Type)name, vector, false, x509Certificate, x509CertificateArray);
                    if (bl) continue;
                    this.loadCRLs((ASN1Type)name, vector, true, x509Certificate, x509CertificateArray);
                }
            } else {
                this.loadCRLs((ASN1Type)x509Certificate.getIssuerDN(), vector, false, x509Certificate, x509CertificateArray);
                if (!bl) {
                    this.loadCRLs((ASN1Type)x509Certificate.getIssuerDN(), vector, true, x509Certificate, x509CertificateArray);
                }
            }
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    protected boolean check(X509Certificate x509Certificate, X509Certificate[] x509CertificateArray) throws CertificationException {
        Vector vector = this.findCRL(x509Certificate, x509CertificateArray);
        if (vector == null) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        BasicConstraints basicConstraints = new BasicConstraints();
        try {
            basicConstraints = (BasicConstraints)x509Certificate.getExtension(basicConstraints.getObjectID());
            bl2 = true;
            bl3 = basicConstraints.ca();
        }
        catch (Exception exception) {
            bl2 = false;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            RevokedCertificate revokedCertificate;
            Principal principal;
            Principal principal2;
            X509CRL x509CRL = (X509CRL)enumeration.nextElement();
            boolean bl4 = false;
            if (bl2) {
                if (bl3) {
                    principal2 = new IssuingDistributionPoint();
                    try {
                        principal2 = (IssuingDistributionPoint)x509CRL.getExtension(principal2.getObjectID());
                        bl4 = principal2.getOnlyContainsUserCerts() ^ true;
                    }
                    catch (Exception exception) {
                        bl4 = true;
                    }
                } else {
                    principal2 = new IssuingDistributionPoint();
                    try {
                        principal2 = (IssuingDistributionPoint)x509CRL.getExtension(principal2.getObjectID());
                        bl4 = principal2.getOnlyContainsCaCerts() ^ true;
                    }
                    catch (Exception exception) {
                        bl4 = true;
                    }
                }
            } else {
                bl4 = true;
            }
            if (!(principal2 = x509CRL.getIssuerDN()).equals(principal = x509Certificate.getIssuerDN())) {
                bl4 = false;
            }
            bl |= bl4;
            if (!bl4 || (revokedCertificate = x509CRL.containsCertificate(x509Certificate)) == null) continue;
            throw new RevocationException(x509Certificate, revokedCertificate);
        }
        return bl;
    }

    X509CRLRS(ValidationInfo validationInfo) {
        this.m_validationInfo = validationInfo;
    }
}

