/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.x509.testlets;

import com.entrust.toolkit.exceptions.ExtensionException;
import com.entrust.toolkit.x509.testlets.CRLTestlet;
import com.entrust.toolkit.x509.testlets.TestletDataSet;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.Name;
import iaik.utils.CryptoUtils;
import iaik.x509.V3Extension;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.AuthorityKeyIdentifier;
import iaik.x509.extensions.SubjectKeyIdentifier;
import java.math.BigInteger;
import java.util.Enumeration;

public class AuthorityKeyIdentifierCRLTestlet
implements CRLTestlet {
    private byte[] b = null;
    private GeneralNames c = null;
    private BigInteger a = null;
    private X509Certificate d = null;

    public void validate(X509CRL x509CRL, TestletDataSet testletDataSet) throws ExtensionException {
        Object object;
        Enumeration enumeration;
        if (this.a != null && this.c != null) {
            enumeration = this.c.getNames();
            if (enumeration == null) {
                throw new ExtensionException("Invalid issuer name.");
            }
            object = (GeneralName)enumeration.nextElement();
            if (object == null) {
                throw new ExtensionException("Invalid issuer name.");
            }
            Name name = (Name)object.getName();
            if (name == null) {
                throw new ExtensionException("Invalid issuer name.");
            }
            if (!name.equals((Object)this.d.getIssuerDN())) {
                throw new ExtensionException("Invalid issuer name.");
            }
            if (!this.a.equals(this.d.getSerialNumber())) {
                throw new ExtensionException("Invalid issuer serial number.");
            }
        }
        if (this.b != null && this.b.length > 0) {
            enumeration = null;
            try {
                enumeration = (SubjectKeyIdentifier)this.d.getExtension(new SubjectKeyIdentifier().getObjectID());
            }
            catch (X509ExtensionInitException x509ExtensionInitException) {
                throw new ExtensionException(x509ExtensionInitException.getMessage());
            }
            if (enumeration == null) {
                throw new ExtensionException("Invalid issuer's SubjectKeyIdentifier.");
            }
            object = enumeration.get();
            if (!CryptoUtils.equalsBlock((byte[])object, (byte[])this.b)) {
                throw new ExtensionException("Invalid KeyIdentifier");
            }
        }
    }

    public void reset(TestletDataSet testletDataSet) {
        this.a = null;
        this.c = null;
        this.b = null;
    }

    public void notify(V3Extension v3Extension, TestletDataSet testletDataSet) {
        AuthorityKeyIdentifier authorityKeyIdentifier = (AuthorityKeyIdentifier)v3Extension;
        if (v3Extension != null) {
            this.a = authorityKeyIdentifier.getAuthorityCertSerialNumber();
            this.c = authorityKeyIdentifier.getAuthorityCertIssuer();
            this.b = authorityKeyIdentifier.getKeyIdentifier();
        }
    }

    public void init(X509Certificate x509Certificate, TestletDataSet testletDataSet) {
        this.d = x509Certificate;
    }
}

