/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.x509.testlets;

import com.entrust.toolkit.exceptions.ExtensionException;
import com.entrust.toolkit.x509.ValidationInfo;
import com.entrust.toolkit.x509.extensions.EntrustVersInfo;
import com.entrust.toolkit.x509.extensions.KeyAttributes;
import com.entrust.toolkit.x509.extensions.OldAuthorityKeyIdentifier;
import com.entrust.toolkit.x509.extensions.OldBasicConstraints;
import com.entrust.toolkit.x509.extensions.OldCRLDistributionPoints;
import com.entrust.toolkit.x509.testlets.AuthorityKeyIdentifierCRLTestlet;
import com.entrust.toolkit.x509.testlets.BasicConstraintsCertTestlet;
import com.entrust.toolkit.x509.testlets.CRLEntryTestlet;
import com.entrust.toolkit.x509.testlets.CRLTestlet;
import com.entrust.toolkit.x509.testlets.CertTestlet;
import com.entrust.toolkit.x509.testlets.CertificateIssuerCRLEntryTestlet;
import com.entrust.toolkit.x509.testlets.CertificatePoliciesCertTestlet;
import com.entrust.toolkit.x509.testlets.IssuingDistributionPointCRLTestlet;
import com.entrust.toolkit.x509.testlets.KeyUsageCertTestlet;
import com.entrust.toolkit.x509.testlets.NameConstraintsCertTestlet;
import com.entrust.toolkit.x509.testlets.NullCRLEntryTestlet;
import com.entrust.toolkit.x509.testlets.NullCRLTestlet;
import com.entrust.toolkit.x509.testlets.NullCertTestlet;
import com.entrust.toolkit.x509.testlets.OldBasicConstraintsCertTestlet;
import com.entrust.toolkit.x509.testlets.PolicyConstraintsCertTestlet;
import com.entrust.toolkit.x509.testlets.TestletDataSet;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.Name;
import iaik.x509.RevokedCertificate;
import iaik.x509.V3Extension;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.AuthorityKeyIdentifier;
import iaik.x509.extensions.BasicConstraints;
import iaik.x509.extensions.CRLDistributionPoints;
import iaik.x509.extensions.CRLNumber;
import iaik.x509.extensions.CertificateIssuer;
import iaik.x509.extensions.CertificatePolicies;
import iaik.x509.extensions.DeltaCRLIndicator;
import iaik.x509.extensions.HoldInstructionCode;
import iaik.x509.extensions.InvalidityDate;
import iaik.x509.extensions.IssuerAltName;
import iaik.x509.extensions.IssuingDistributionPoint;
import iaik.x509.extensions.KeyUsage;
import iaik.x509.extensions.NameConstraints;
import iaik.x509.extensions.PolicyConstraints;
import iaik.x509.extensions.PolicyMappings;
import iaik.x509.extensions.PrivateKeyUsagePeriod;
import iaik.x509.extensions.ReasonCode;
import iaik.x509.extensions.SubjectAltName;
import iaik.x509.extensions.SubjectKeyIdentifier;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ExtensionTester {
    private Hashtable c = null;
    private Hashtable b = null;
    private Hashtable d = null;
    private ValidationInfo a = null;

    public synchronized void validate(X509Certificate[] x509CertificateArray) throws ExtensionException {
        TestletDataSet testletDataSet = null;
        try {
            testletDataSet = new TestletDataSet();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExtensionException("Could not initialize TestletDataSet.");
        }
        Enumeration enumeration = this.d.keys();
        while (enumeration.hasMoreElements()) {
            CertTestlet certTestlet = (CertTestlet)this.d.get(enumeration.nextElement());
            certTestlet.init(x509CertificateArray, testletDataSet);
        }
        int n2 = 0;
        while (n2 < x509CertificateArray.length) {
            CertTestlet certTestlet;
            V3Extension v3Extension;
            Enumeration enumeration2 = x509CertificateArray[n2].listExtensions();
            boolean bl = false;
            boolean bl2 = false;
            while (enumeration2 != null && enumeration2.hasMoreElements()) {
                v3Extension = (V3Extension)enumeration2.nextElement();
                certTestlet = (CertTestlet)this.d.get(v3Extension.getObjectID().getID());
                if (certTestlet != null) {
                    certTestlet.notify(v3Extension, testletDataSet);
                    continue;
                }
                if (!v3Extension.isCritical()) continue;
                throw new ExtensionException("Unable to find testlet for critical extension " + v3Extension.getObjectID().getName());
            }
            enumeration2 = x509CertificateArray[n2].listExtensions();
            while (enumeration2 != null && enumeration2.hasMoreElements()) {
                v3Extension = (V3Extension)enumeration2.nextElement();
                certTestlet = (CertTestlet)this.d.get(v3Extension.getObjectID().getID());
                if (certTestlet != null) {
                    if (certTestlet instanceof BasicConstraintsCertTestlet || certTestlet instanceof OldBasicConstraints) {
                        bl2 = true;
                    }
                    if (!(certTestlet instanceof CertificatePoliciesCertTestlet)) {
                        certTestlet.validate(x509CertificateArray[n2], testletDataSet);
                        continue;
                    }
                    if (!this.a.getClientSettings().getRequirePolicyOIDs()) continue;
                    certTestlet.validate(x509CertificateArray[n2], testletDataSet);
                    bl = true;
                    continue;
                }
                if (!v3Extension.isCritical()) continue;
                throw new ExtensionException("Unable to find testlet for critical extension " + v3Extension.getObjectID().getName());
            }
            enumeration2 = x509CertificateArray[n2].listExtensions();
            while (enumeration2 != null && enumeration2.hasMoreElements()) {
                v3Extension = (V3Extension)enumeration2.nextElement();
                certTestlet = (CertTestlet)this.d.get(v3Extension.getObjectID().getID());
                if (certTestlet != null) {
                    certTestlet.reset(testletDataSet);
                    continue;
                }
                if (!v3Extension.isCritical()) continue;
                throw new ExtensionException("Unable to find testlet for critical extension " + v3Extension.getObjectID().getName());
            }
            if (this.a.getClientSettings() != null && this.a.getClientSettings().getRequirePolicyOIDs() && !this.a(x509CertificateArray[n2]) && !bl) {
                throw new ExtensionException("Required policy extension is missing from certificate.");
            }
            if (!bl2 && n2 != x509CertificateArray.length - 1 && x509CertificateArray[n2].getVersion() >= 3) {
                throw new ExtensionException("The chain is not valid, because one of the certificates does not have the required basic constraints extension.");
            }
            ++n2;
        }
    }

    public void validate(X509CRL x509CRL, X509Certificate x509Certificate) throws ExtensionException {
        Object object;
        Object object2;
        TestletDataSet testletDataSet;
        TestletDataSet testletDataSet2 = null;
        try {
            testletDataSet2 = new TestletDataSet();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExtensionException("Could not initialize the Testlet Data Set.");
        }
        Enumeration enumeration = x509CRL.listExtensions();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                testletDataSet = (V3Extension)enumeration.nextElement();
                object2 = (CRLTestlet)this.b.get(testletDataSet.getObjectID().getID());
                if (object2 != null) {
                    object2.init(x509Certificate, testletDataSet2);
                    continue;
                }
                if (!testletDataSet.isCritical()) continue;
                throw new ExtensionException("Unable to find testlet for critical extension " + testletDataSet.getObjectID().getID());
            }
            enumeration = x509CRL.listExtensions();
            while (enumeration.hasMoreElements()) {
                testletDataSet = (V3Extension)enumeration.nextElement();
                object2 = (CRLTestlet)this.b.get(testletDataSet.getObjectID().getID());
                if (object2 == null) continue;
                object2.notify((V3Extension)testletDataSet, testletDataSet2);
            }
            enumeration = x509CRL.listExtensions();
            while (enumeration.hasMoreElements()) {
                testletDataSet = (V3Extension)enumeration.nextElement();
                object2 = (CRLTestlet)this.b.get(testletDataSet.getObjectID().getID());
                if (object2 == null) continue;
                object2.validate(x509CRL, testletDataSet2);
            }
            enumeration = x509CRL.listExtensions();
            while (enumeration.hasMoreElements()) {
                testletDataSet = (V3Extension)enumeration.nextElement();
                object2 = (CRLTestlet)this.b.get(testletDataSet.getObjectID().getID());
                if (object2 == null) continue;
                object2.reset(testletDataSet2);
            }
        }
        testletDataSet = null;
        try {
            testletDataSet = new TestletDataSet();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExtensionException("Could not create testlet data set.");
        }
        object2 = this.c.keys();
        while (object2.hasMoreElements()) {
            object = (CRLEntryTestlet)this.c.get(object2.nextElement());
            object.init(x509CRL, testletDataSet);
        }
        object = x509CRL.listCertificates();
        while (object.hasMoreElements()) {
            CRLEntryTestlet cRLEntryTestlet;
            V3Extension v3Extension;
            RevokedCertificate revokedCertificate = (RevokedCertificate)object.nextElement();
            enumeration = revokedCertificate.listExtensions();
            if (enumeration == null) continue;
            while (enumeration.hasMoreElements()) {
                v3Extension = (V3Extension)enumeration.nextElement();
                cRLEntryTestlet = (CRLEntryTestlet)this.c.get(v3Extension.getObjectID().getID());
                cRLEntryTestlet.notify(v3Extension, testletDataSet);
            }
            enumeration = revokedCertificate.listExtensions();
            while (enumeration.hasMoreElements()) {
                v3Extension = (V3Extension)enumeration.nextElement();
                cRLEntryTestlet = (CRLEntryTestlet)this.c.get(v3Extension.getObjectID().getID());
                cRLEntryTestlet.validate(revokedCertificate, testletDataSet);
            }
            enumeration = revokedCertificate.listExtensions();
            while (enumeration.hasMoreElements()) {
                v3Extension = (V3Extension)enumeration.nextElement();
                cRLEntryTestlet = (CRLEntryTestlet)this.c.get(v3Extension.getObjectID().getID());
                cRLEntryTestlet.reset(testletDataSet);
            }
        }
    }

    private boolean a(X509Certificate x509Certificate) {
        block10: {
            Name name;
            if (x509Certificate == null) {
                return false;
            }
            Name name2 = (Name)x509Certificate.getIssuerDN();
            if (!name2.equals((Object)(name = (Name)x509Certificate.getSubjectDN()))) {
                return false;
            }
            SubjectKeyIdentifier subjectKeyIdentifier = null;
            AuthorityKeyIdentifier authorityKeyIdentifier = null;
            try {
                subjectKeyIdentifier = (SubjectKeyIdentifier)x509Certificate.getExtension(SubjectKeyIdentifier.oid);
                authorityKeyIdentifier = (AuthorityKeyIdentifier)x509Certificate.getExtension(AuthorityKeyIdentifier.oid);
            }
            catch (X509ExtensionInitException x509ExtensionInitException) {
                return false;
            }
            try {
                String string = new String(authorityKeyIdentifier.getKeyIdentifier(), "iso_8859-1");
                String string2 = new String(subjectKeyIdentifier.get(), "iso_8859-1");
                if (!string.equals(string2)) {
                    return false;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    String string = new String(authorityKeyIdentifier.getKeyIdentifier(), "iso8859-1");
                    String string3 = new String(subjectKeyIdentifier.get(), "iso8859-1");
                    if (!string.equals(string3)) {
                        return false;
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    String string = new String(authorityKeyIdentifier.getKeyIdentifier());
                    String string4 = new String(subjectKeyIdentifier.get());
                    if (string.equals(string4)) break block10;
                    return false;
                }
            }
        }
        return true;
    }

    private void a(ValidationInfo validationInfo) {
        Object object;
        NullCertTestlet nullCertTestlet = new NullCertTestlet();
        this.addTestlet(nullCertTestlet, AuthorityKeyIdentifier.oid);
        this.addTestlet(new BasicConstraintsCertTestlet(), BasicConstraints.oid);
        this.addTestlet(nullCertTestlet, CRLDistributionPoints.oid);
        this.addTestlet(nullCertTestlet, EntrustVersInfo.oid);
        this.addTestlet(nullCertTestlet, IssuerAltName.oid);
        this.addTestlet(nullCertTestlet, KeyAttributes.oid);
        this.addTestlet(new KeyUsageCertTestlet(), KeyUsage.oid);
        this.addTestlet(new NameConstraintsCertTestlet(), NameConstraints.oid);
        this.addTestlet(nullCertTestlet, OldAuthorityKeyIdentifier.oid);
        this.addTestlet(new OldBasicConstraintsCertTestlet(), OldBasicConstraints.oid);
        this.addTestlet(nullCertTestlet, OldCRLDistributionPoints.oid);
        this.addTestlet(new PolicyConstraintsCertTestlet(), PolicyConstraints.oid);
        this.addTestlet(nullCertTestlet, PolicyMappings.oid);
        this.addTestlet(nullCertTestlet, PrivateKeyUsagePeriod.oid);
        this.addTestlet(nullCertTestlet, SubjectAltName.oid);
        this.addTestlet(nullCertTestlet, SubjectKeyIdentifier.oid);
        if (validationInfo.getClientSettings() != null) {
            object = validationInfo.getClientSettings().getAcceptablePolicyOids();
            boolean bl = validationInfo.getClientSettings().getInhibitPolicyMapping();
            ObjectID[] objectIDArray = null;
            if (object == null || ((Vector)object).size() == 0) {
                objectIDArray = new ObjectID[]{};
            } else {
                objectIDArray = new ObjectID[((Vector)object).size()];
                int n2 = 0;
                while (n2 < objectIDArray.length) {
                    objectIDArray[n2] = (ObjectID)((Vector)object).elementAt(n2);
                    ++n2;
                }
            }
            this.addTestlet(new CertificatePoliciesCertTestlet(objectIDArray, bl), CertificatePolicies.oid);
        }
        object = new NullCRLTestlet();
        this.addTestlet(new AuthorityKeyIdentifierCRLTestlet(), AuthorityKeyIdentifier.oid);
        this.addTestlet(new IssuingDistributionPointCRLTestlet(), IssuingDistributionPoint.oid);
        this.addTestlet((CRLTestlet)object, CRLNumber.oid);
        this.addTestlet((CRLTestlet)object, IssuerAltName.oid);
        this.addTestlet((CRLTestlet)object, DeltaCRLIndicator.oid);
        NullCRLEntryTestlet nullCRLEntryTestlet = new NullCRLEntryTestlet();
        this.addTestlet(new CertificateIssuerCRLEntryTestlet(), CertificateIssuer.oid);
        this.addTestlet(nullCRLEntryTestlet, HoldInstructionCode.oid);
        this.addTestlet(nullCRLEntryTestlet, ReasonCode.oid);
        this.addTestlet(nullCRLEntryTestlet, InvalidityDate.oid);
    }

    public void addTestlet(CertTestlet certTestlet, ObjectID objectID) {
        this.d.put(objectID.getID(), certTestlet);
    }

    public void addTestlet(CRLTestlet cRLTestlet, ObjectID objectID) {
        this.b.put(objectID.getID(), cRLTestlet);
    }

    public void addTestlet(CRLEntryTestlet cRLEntryTestlet, ObjectID objectID) {
        this.c.put(objectID.getID(), cRLEntryTestlet);
    }

    public ExtensionTester(ValidationInfo validationInfo) {
        if (validationInfo == null) {
            throw new NullPointerException();
        }
        this.a = validationInfo;
        this.d = new Hashtable();
        this.b = new Hashtable();
        this.c = new Hashtable();
        this.a(validationInfo);
    }
}

