/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.x509.testlets;

import com.entrust.toolkit.exceptions.ExtensionException;
import com.entrust.toolkit.x509.testlets.CertTestlet;
import com.entrust.toolkit.x509.testlets.TestletDataSet;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralSubtree;
import iaik.asn1.structures.Name;
import iaik.x509.V3Extension;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.NameConstraints;
import iaik.x509.extensions.SubjectAltName;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;

public class NameConstraintsCertTestlet
implements CertTestlet {
    private GeneralSubtree[] b = null;
    private GeneralSubtree[] a = null;
    private X509Certificate[] c = null;

    public void validate(X509Certificate x509Certificate, TestletDataSet testletDataSet) throws ExtensionException {
        X509Certificate x509Certificate2;
        int n2;
        GeneralSubtree generalSubtree;
        int n3;
        int n4 = 0;
        while (!this.c[n4].equals(x509Certificate) && n4 < this.c.length) {
            ++n4;
        }
        if (n4 >= this.c.length - 1) {
            return;
        }
        if (this.a != null && this.a.length > 0) {
            n3 = 0;
            while (n3 < this.a.length) {
                generalSubtree = this.a[n3];
                n2 = n4 + 1;
                while (n2 < this.c.length) {
                    x509Certificate2 = this.c[n2];
                    boolean bl = false;
                    if (!(bl |= this.a(generalSubtree, x509Certificate2))) {
                        throw new ExtensionException("Certificate in chain is not in permitted subtrees.");
                    }
                    ++n2;
                }
                ++n3;
            }
        }
        if (this.b != null && this.b.length > 0) {
            n3 = 0;
            while (n3 < this.b.length) {
                generalSubtree = this.b[n3];
                n2 = n4 + 1;
                while (n2 < this.c.length) {
                    x509Certificate2 = this.c[n2];
                    if (this.a(generalSubtree, x509Certificate2)) {
                        throw new ExtensionException("Certificate is in excluded subtree.");
                    }
                    ++n2;
                }
                ++n3;
            }
        }
    }

    public void reset(TestletDataSet testletDataSet) {
        this.a = null;
        this.b = null;
    }

    public void notify(V3Extension v3Extension, TestletDataSet testletDataSet) {
        NameConstraints nameConstraints = (NameConstraints)v3Extension;
        this.a = nameConstraints.getPermittedSubtrees();
        this.b = nameConstraints.getExcludedSubtrees();
    }

    private boolean a(GeneralSubtree generalSubtree, X509Certificate x509Certificate) throws ExtensionException {
        GeneralName generalName = generalSubtree.getBase();
        if (generalName.getType() == GeneralName.directoryName) {
            String string = generalName.getName().toString();
            String string2 = x509Certificate.getSubjectDN().toString();
            int n2 = string2.indexOf(string);
            if (n2 >= 0) {
                return true;
            }
            SubjectAltName subjectAltName = new SubjectAltName();
            try {
                subjectAltName = (SubjectAltName)x509Certificate.getExtension(subjectAltName.getObjectID());
            }
            catch (X509ExtensionInitException x509ExtensionInitException) {
                return false;
            }
            if (subjectAltName == null) {
                return false;
            }
            Enumeration enumeration = subjectAltName.getGeneralNames().getNames();
            while (enumeration.hasMoreElements()) {
                String string3;
                GeneralName generalName2 = (GeneralName)enumeration.nextElement();
                if (generalName2.getType() != GeneralName.directoryName || (n2 = (string3 = generalName2.getName().toString()).indexOf(string)) < 0) continue;
                return true;
            }
            return false;
        }
        if (generalName.getType() == GeneralName.dNSName) {
            String string = (String)generalSubtree.getBase().getName();
            SubjectAltName subjectAltName = new SubjectAltName();
            try {
                subjectAltName = (SubjectAltName)x509Certificate.getExtension(subjectAltName.getObjectID());
            }
            catch (X509ExtensionInitException x509ExtensionInitException) {
                return false;
            }
            if (subjectAltName == null) {
                return false;
            }
            Enumeration enumeration = subjectAltName.getGeneralNames().getNames();
            while (enumeration.hasMoreElements()) {
                String string4;
                int n3;
                GeneralName generalName3 = (GeneralName)enumeration.nextElement();
                if (generalName3.getType() != GeneralName.dNSName || (n3 = (string4 = (String)generalName3.getName()).indexOf(string)) != string4.length() - string.length()) continue;
                if (n3 == 0) {
                    return true;
                }
                if (string4.charAt(n3 - 1) != '.') continue;
                return true;
            }
            return false;
        }
        if (generalName.getType() == GeneralName.iPAddress) {
            byte[] byArray = null;
            try {
                byArray = ((String)generalName.getName()).getBytes("iso_8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    byArray = ((String)generalName.getName()).getBytes("iso8859-1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    byArray = ((String)generalName.getName()).getBytes();
                }
            }
            SubjectAltName subjectAltName = new SubjectAltName();
            try {
                subjectAltName = (SubjectAltName)x509Certificate.getExtension(subjectAltName.getObjectID());
            }
            catch (X509ExtensionInitException x509ExtensionInitException) {
                return false;
            }
            if (subjectAltName == null) {
                return false;
            }
            Enumeration enumeration = subjectAltName.getGeneralNames().getNames();
            while (enumeration.hasMoreElements()) {
                GeneralName generalName4 = (GeneralName)enumeration.nextElement();
                if (generalName4.getType() != GeneralName.iPAddress) continue;
                byte[] byArray2 = null;
                try {
                    byArray2 = ((String)generalName4.getName()).getBytes("iso_8859-1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    try {
                        byArray2 = ((String)generalName4.getName()).getBytes("iso8859-1");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException3) {
                        byArray2 = ((String)generalName4.getName()).getBytes();
                    }
                }
                if (byArray2.length * 2 != byArray.length) {
                    throw new ExtensionException("Invalid IP address format.");
                }
                boolean bl = true;
                int n4 = 0;
                while (n4 < byArray2.length) {
                    if ((byArray2[n4] & byArray[n4 + byArray2.length]) != byArray[n4]) {
                        bl = false;
                    }
                    ++n4;
                }
                if (!bl) continue;
                return true;
            }
            return false;
        }
        if (generalName.getType() == GeneralName.rfc822Name) {
            String string = (String)generalSubtree.getBase().getName();
            SubjectAltName subjectAltName = new SubjectAltName();
            try {
                subjectAltName = (SubjectAltName)x509Certificate.getExtension(subjectAltName.getObjectID());
            }
            catch (X509ExtensionInitException x509ExtensionInitException) {
                subjectAltName = null;
            }
            if (subjectAltName != null) {
                Enumeration enumeration = subjectAltName.getGeneralNames().getNames();
                while (enumeration.hasMoreElements()) {
                    String string5;
                    GeneralName generalName5 = (GeneralName)enumeration.nextElement();
                    if (generalName5.getType() != GeneralName.rfc822Name || !this.a(string, string5 = (String)generalName5.getName())) continue;
                    return true;
                }
            } else {
                Name name = (Name)x509Certificate.getSubjectDN();
                String string6 = (String)name.getRDNValue(ObjectID.emailAddress);
                if (this.a(string, string6)) {
                    return true;
                }
            }
            return false;
        }
        if (generalName.getType() == GeneralName.uniformResourceIdentifier) {
            SubjectAltName subjectAltName = new SubjectAltName();
            try {
                subjectAltName = (SubjectAltName)x509Certificate.getExtension(subjectAltName.getObjectID());
            }
            catch (X509ExtensionInitException x509ExtensionInitException) {
                subjectAltName = null;
            }
            if (subjectAltName == null) {
                return false;
            }
            Enumeration enumeration = subjectAltName.getGeneralNames().getNames();
            String string = (String)generalName.getName();
            while (enumeration.hasMoreElements()) {
                int n5;
                GeneralName generalName6 = (GeneralName)enumeration.nextElement();
                if (generalName6.getType() != GeneralName.uniformResourceIdentifier) continue;
                String string7 = (String)generalName6.getName();
                String string8 = this.a(string7);
                if (!(string.charAt(0) == '.' ? (n5 = string8.indexOf(string)) > 0 && n5 == string8.length() - string.length() : string8.equals(string))) continue;
                return true;
            }
            return false;
        }
        throw new ExtensionException("Unrecognized GeneralName type in NameConstraints.");
    }

    public void init(X509Certificate[] x509CertificateArray, TestletDataSet testletDataSet) {
        this.c = x509CertificateArray;
    }

    private String a(String string) throws ExtensionException {
        int n2 = string.indexOf("//");
        if (n2 < 0) {
            throw new ExtensionException("Invalid URI format.");
        }
        if (n2 >= string.length() - 2) {
            throw new ExtensionException("Invalid URI format.");
        }
        String string2 = string.substring(n2 + 2);
        int n3 = string2.indexOf("/");
        if (n3 < 0) {
            return string2;
        }
        return string2.substring(0, n3);
    }

    private boolean a(String string, String string2) throws ExtensionException {
        int n2 = string.indexOf(64);
        if (n2 >= 0) {
            return string.equals(string2);
        }
        n2 = string2.indexOf(64);
        if (n2 < 0) {
            throw new ExtensionException("Invalid format for RFC822Name");
        }
        String string3 = string2.substring(n2 + 1);
        if (string.charAt(0) != '.') {
            return string.equals(string3);
        }
        int n3 = string3.indexOf(string);
        if (n3 < 0) {
            return false;
        }
        return n3 == string3.length() - string.length();
    }
}

