/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.x509.testlets;

import com.entrust.toolkit.exceptions.ExtensionException;
import com.entrust.toolkit.x509.testlets.CertTestlet;
import com.entrust.toolkit.x509.testlets.TestletDataSet;
import iaik.asn1.structures.PolicyInformation;
import iaik.x509.V3Extension;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.CertificatePolicies;
import iaik.x509.extensions.PolicyConstraints;

public class PolicyConstraintsCertTestlet
implements CertTestlet {
    private int a = -1;
    private X509Certificate[] b = null;

    public void validate(X509Certificate x509Certificate, TestletDataSet testletDataSet) throws ExtensionException {
        if (this.a >= 0) {
            int n2 = 0;
            while (n2 < this.b.length && !this.b[n2].equals(x509Certificate)) {
                ++n2;
            }
            if (n2 == this.b.length) {
                throw new ExtensionException("Could not find current certificate in chain.");
            }
            int n3 = n2 + this.a + 1;
            while (n3 < this.b.length) {
                X509Certificate x509Certificate2 = this.b[n3];
                CertificatePolicies certificatePolicies = new CertificatePolicies();
                try {
                    certificatePolicies = (CertificatePolicies)x509Certificate2.getExtension(certificatePolicies.getObjectID());
                }
                catch (X509ExtensionInitException x509ExtensionInitException) {
                    certificatePolicies = null;
                }
                if (certificatePolicies == null) {
                    throw new ExtensionException("Required certificate policy is missing.");
                }
                PolicyInformation[] policyInformationArray = certificatePolicies.getPolicyInformation();
                if (policyInformationArray == null || policyInformationArray.length == 0) {
                    throw new ExtensionException("Required certificate policy is missing.");
                }
                ++n3;
            }
        }
    }

    public void reset(TestletDataSet testletDataSet) {
        this.a = -1;
    }

    public void notify(V3Extension v3Extension, TestletDataSet testletDataSet) {
        PolicyConstraints policyConstraints = (PolicyConstraints)v3Extension;
        this.a = policyConstraints.getRequireExplicitPolicy();
    }

    public void init(X509Certificate[] x509CertificateArray, TestletDataSet testletDataSet) {
        this.b = x509CertificateArray;
    }
}

