/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PRectangle;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.graphics.WatermarkCallback;
import org.icepdf.core.util.Library;

public class PageTree
extends Dictionary {
    public static final Name TYPE = new Name("Pages");
    public static final Name PARENT_KEY = new Name("Parent");
    public static final Name COUNT_KEY = new Name("Count");
    public static final Name MEDIABOX_KEY = new Name("MediaBox");
    public static final Name CROPBOX_KEY = new Name("CropBox");
    public static final Name KIDS_KEY = new Name("Kids");
    public static final Name ROTATE_KEY = new Name("Rotate");
    public static final Name RESOURCES_KEY = new Name("Resources");
    private int kidsCount = 0;
    private List kidsReferences;
    private HashMap<Integer, WeakReference<Object>> kidsPageAndPages;
    private PageTree parent;
    private boolean inited;
    private PRectangle mediaBox;
    private PRectangle cropBox;
    private Resources resources;
    private boolean loadedResources;
    private WatermarkCallback watermarkCallback;
    protected float rotationFactor = 0.0f;
    protected boolean isRotationFactor = false;

    public PageTree(Library l, HashMap h) {
        super(l, h);
    }

    public void resetInitializedState() {
        this.inited = false;
    }

    public synchronized void init() {
        if (this.inited) {
            return;
        }
        Object parentTree = this.library.getObject(this.entries, PARENT_KEY);
        if (parentTree instanceof PageTree) {
            this.parent = (PageTree)parentTree;
        }
        this.kidsCount = this.library.getNumber(this.entries, COUNT_KEY).intValue();
        this.kidsReferences = (List)this.library.getObject(this.entries, KIDS_KEY);
        this.kidsPageAndPages = new HashMap(this.kidsReferences.size());
        Object tmpRotation = this.library.getObject(this.entries, ROTATE_KEY);
        if (tmpRotation != null) {
            this.rotationFactor = ((Number)tmpRotation).floatValue();
            this.isRotationFactor = true;
        }
        this.inited = true;
    }

    public PRectangle getMediaBox() {
        if (!this.inited) {
            this.init();
        }
        if (this.mediaBox != null) {
            return this.mediaBox;
        }
        List boxDimensions = (List)this.library.getObject(this.entries, MEDIABOX_KEY);
        if (boxDimensions != null) {
            this.mediaBox = new PRectangle(boxDimensions);
        }
        if (this.mediaBox == null) {
            PageTree pageTree = this.getParent();
            while (pageTree != null && this.mediaBox == null) {
                this.mediaBox = pageTree.getMediaBox();
                if (this.mediaBox != null) continue;
                pageTree = pageTree.getParent();
            }
        }
        return this.mediaBox;
    }

    public PRectangle getCropBox() {
        if (!this.inited) {
            this.init();
        }
        if (this.cropBox != null) {
            return this.cropBox;
        }
        List boxDimensions = (List)this.library.getObject(this.entries, CROPBOX_KEY);
        if (boxDimensions != null) {
            this.cropBox = new PRectangle(boxDimensions);
        }
        PRectangle mediaBox = this.getMediaBox();
        if (this.cropBox == null && mediaBox != null) {
            this.cropBox = (PRectangle)mediaBox.clone();
        } else if (mediaBox != null) {
            this.cropBox = mediaBox.createCartesianIntersection(this.cropBox);
        }
        return this.cropBox;
    }

    public synchronized Resources getResources() {
        if (!this.loadedResources) {
            this.loadedResources = true;
            this.resources = this.library.getResources(this.entries, RESOURCES_KEY);
        }
        return this.resources;
    }

    public PageTree getParent() {
        return this.parent;
    }

    public int getPageNumber(Reference r) {
        Page pg = (Page)this.library.getObject(r);
        if (pg == null) {
            return -1;
        }
        int globalIndex = 0;
        Reference currChildRef = r;
        Reference currParentRef = pg.getParentReference();
        PageTree currParent = pg.getParent();
        while (currParentRef != null && currParent != null) {
            currParent.init();
            int refIndex = currParent.indexOfKidReference(currChildRef);
            if (refIndex < 0) {
                return -1;
            }
            int localIndex = 0;
            for (int i = 0; i < refIndex; ++i) {
                Object pageOrPages = currParent.getPageOrPagesPotentiallyNotInitedFromReferenceAt(i);
                if (pageOrPages instanceof Page) {
                    ++localIndex;
                    continue;
                }
                if (!(pageOrPages instanceof PageTree)) continue;
                PageTree peerPageTree = (PageTree)pageOrPages;
                peerPageTree.init();
                localIndex += peerPageTree.getNumberOfPages();
            }
            globalIndex += localIndex;
            currChildRef = currParentRef;
            currParentRef = (Reference)currParent.entries.get(PARENT_KEY);
            currParent = currParent.parent;
        }
        return globalIndex;
    }

    private int indexOfKidReference(Reference r) {
        for (int i = 0; i < this.kidsReferences.size(); ++i) {
            Reference ref = (Reference)this.kidsReferences.get(i);
            if (!ref.equals(r)) continue;
            return i;
        }
        return -1;
    }

    private Object getPageOrPagesPotentiallyNotInitedFromReferenceAt(int index) {
        WeakReference<Object> pageOrPages = this.kidsPageAndPages.get(index);
        if (pageOrPages == null || pageOrPages.get() == null) {
            Reference ref = (Reference)this.kidsReferences.get(index);
            Object tmp = this.library.getObject(ref);
            pageOrPages = new WeakReference<Object>(tmp);
            this.kidsPageAndPages.put(index, pageOrPages);
            return tmp;
        }
        return pageOrPages.get();
    }

    private Page getPagePotentiallyNotInitedByRecursiveIndex(int globalIndex) {
        int globalIndexSoFar = 0;
        int numLocalKids = this.kidsReferences.size();
        for (int i = 0; i < numLocalKids; ++i) {
            HashMap dictionary;
            Object pageOrPages = this.getPageOrPagesPotentiallyNotInitedFromReferenceAt(i);
            if (pageOrPages instanceof Page) {
                if (globalIndex == globalIndexSoFar) {
                    return (Page)pageOrPages;
                }
                ++globalIndexSoFar;
                continue;
            }
            if (pageOrPages instanceof PageTree) {
                PageTree childPageTree = (PageTree)pageOrPages;
                childPageTree.init();
                int numChildPages = childPageTree.getNumberOfPages();
                if (globalIndex >= globalIndexSoFar && globalIndex < globalIndexSoFar + numChildPages) {
                    return childPageTree.getPagePotentiallyNotInitedByRecursiveIndex(globalIndex - globalIndexSoFar);
                }
                globalIndexSoFar += numChildPages;
                continue;
            }
            if (!(pageOrPages instanceof HashMap) || !(dictionary = (HashMap)pageOrPages).containsKey(new Name("Kids"))) continue;
            PageTree childPageTree = new PageTree(this.library, dictionary);
            childPageTree.init();
            int numChildPages = childPageTree.getNumberOfPages();
            if (globalIndex >= globalIndexSoFar && globalIndex < globalIndexSoFar + numChildPages) {
                return childPageTree.getPagePotentiallyNotInitedByRecursiveIndex(globalIndex - globalIndexSoFar);
            }
            globalIndexSoFar += numChildPages;
        }
        return null;
    }

    protected void setWatermarkCallback(WatermarkCallback watermarkCallback) {
        this.watermarkCallback = watermarkCallback;
    }

    public int getNumberOfPages() {
        return this.kidsCount;
    }

    public Page getPage(int pageNumber) {
        if (pageNumber < 0) {
            return null;
        }
        Page page = this.getPagePotentiallyNotInitedByRecursiveIndex(pageNumber);
        if (page != null) {
            page.setWatermarkCallback(this.watermarkCallback);
            page.setPageIndex(pageNumber);
        }
        return this.getPagePotentiallyNotInitedByRecursiveIndex(pageNumber);
    }

    public Reference getPageReference(int pageNumber) {
        if (pageNumber < 0) {
            return null;
        }
        Page p = this.getPagePotentiallyNotInitedByRecursiveIndex(pageNumber);
        if (p != null) {
            return p.getPObjectReference();
        }
        return null;
    }

    public String toString() {
        return "PAGES= " + this.entries.toString();
    }
}

