/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.acroform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.acroform.AdditionalActionsDictionary;
import org.icepdf.core.pobjects.acroform.FieldDictionaryFactory;
import org.icepdf.core.pobjects.annotations.AbstractWidgetAnnotation;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldDictionary
extends Dictionary {
    private static final Logger logger = Logger.getLogger(FieldDictionary.class.toString());
    public static final Name FT_KEY = new Name("FT");
    public static final Name KIDS_KEY = new Name("Kids");
    public static final Name PARENT_KEY = new Name("Parent");
    public static final Name T_KEY = new Name("T");
    public static final Name TU_KEY = new Name("TU");
    public static final Name TM_KEY = new Name("TM");
    public static final Name Ff_KEY = new Name("Ff");
    public static final Name V_KEY = new Name("V");
    public static final Name DV_KEY = new Name("DV");
    public static final Name AA_KEY = new Name("AA");
    public static final int READ_ONLY_BIT_FLAG = 1;
    public static final int REQUIRED_BIT_FLAG = 2;
    public static final int NO_EXPORT_BIT_FLAG = 4;
    protected Name fieldType;
    protected FieldDictionary parentField;
    protected ArrayList<Object> kids;
    protected String partialFieldName;
    protected String alternativeFieldName;
    protected String exportMappingName;
    private int flags;
    protected Object fieldValue;
    protected Object defaultFieldValue;
    protected AdditionalActionsDictionary additionalActionsDictionary;

    public FieldDictionary(Library library, HashMap entries) {
        super(library, entries);
        StringObject text;
        Object value = library.getObject(entries, T_KEY);
        if (value != null && value instanceof StringObject) {
            text = (StringObject)value;
            this.partialFieldName = Utils.convertStringObject(library, text);
        } else if (value instanceof String) {
            this.partialFieldName = (String)value;
        }
        value = library.getObject(entries, TU_KEY);
        if (value != null && value instanceof StringObject) {
            text = (StringObject)value;
            this.alternativeFieldName = Utils.convertStringObject(library, text);
        } else if (value instanceof String) {
            this.alternativeFieldName = (String)value;
        }
        value = library.getObject(entries, TM_KEY);
        if (value != null && value instanceof StringObject) {
            text = (StringObject)value;
            this.exportMappingName = Utils.convertStringObject(library, text);
        } else if (value instanceof String) {
            this.exportMappingName = (String)value;
        }
        value = library.getObject(entries, DV_KEY);
        if (value != null) {
            this.defaultFieldValue = value;
        }
        if ((value = library.getObject(entries, AA_KEY)) != null && value instanceof HashMap) {
            this.additionalActionsDictionary = new AdditionalActionsDictionary(library, (HashMap)value);
        }
    }

    public ArrayList<Object> getKids() {
        Object value;
        if (this.kids == null && (value = this.library.getObject(this.entries, KIDS_KEY)) != null && value instanceof List) {
            List children = (List)value;
            this.kids = new ArrayList(children.size());
            for (Reference aChildren : children) {
                Object tmp = this.library.getObject(aChildren);
                if (tmp instanceof PObject) {
                    tmp = ((PObject)tmp).getObject();
                }
                if (tmp instanceof HashMap) {
                    this.kids.add(FieldDictionaryFactory.buildField(this.library, (HashMap)tmp));
                    continue;
                }
                if (!(tmp instanceof AbstractWidgetAnnotation)) continue;
                this.kids.add(tmp);
            }
        }
        return this.kids;
    }

    public FieldDictionary getParent() {
        Object value;
        if (this.parentField == null && (value = this.library.getObject(this.entries, PARENT_KEY)) instanceof HashMap) {
            this.parentField = FieldDictionaryFactory.buildField(this.library, (HashMap)value);
            if (this.parentField != null) {
                this.parentField.setPObjectReference((Reference)this.entries.get(PARENT_KEY));
            }
        }
        return this.parentField;
    }

    public Name getFieldType() {
        if (this.fieldType == null) {
            Name value = this.library.getName(this.entries, FT_KEY);
            if (value != null) {
                this.fieldType = value;
            } else if (this.getParent() != null) {
                this.fieldType = this.parentField.getFieldType();
            }
        }
        return this.fieldType;
    }

    public int getFlags() {
        FieldDictionary parent;
        this.flags = this.library.getInt(this.entries, Ff_KEY);
        if (this.flags == 0 && (parent = this.getParent()) != null) {
            this.flags = parent.getFlags();
        }
        return this.flags;
    }

    public String getPartialFieldName() {
        return this.partialFieldName;
    }

    public String getAlternativeFieldName() {
        return this.alternativeFieldName;
    }

    public String getExportMappingName() {
        return this.exportMappingName;
    }

    public boolean isReadOnly() {
        return (this.flags & 1) == 1;
    }

    public boolean isRequired() {
        return (this.flags & 2) == 2;
    }

    public boolean isNoExport() {
        return (this.flags & 4) == 4;
    }

    public String getFullyQualifiedFieldName() {
        String qualifiedFieldName = this.partialFieldName;
        if (this.parentField != null) {
            return this.parentField.getFullyQualifiedFieldName().concat(".").concat(this.partialFieldName);
        }
        return qualifiedFieldName;
    }

    public Object getFieldValue() {
        Object value = this.library.getObject(this.entries, V_KEY);
        if (value instanceof Name) {
            this.fieldValue = value;
        } else if (value instanceof StringObject) {
            StringObject text = (StringObject)value;
            this.fieldValue = Utils.convertStringObject(this.library, text);
        } else {
            this.fieldValue = value instanceof String ? value : "";
        }
        return this.fieldValue;
    }

    public boolean hasFieldValue() {
        return this.entries.containsKey(V_KEY);
    }

    public boolean hasDefaultValue() {
        return this.entries.containsKey(DV_KEY);
    }

    public void setFieldValue(Object fieldValue, Reference parentReference) {
        this.fieldValue = fieldValue;
        if (fieldValue instanceof String) {
            this.setString(V_KEY, (String)fieldValue);
        } else {
            this.entries.put(V_KEY, fieldValue);
        }
    }

    public Object getDefaultFieldValue() {
        return this.defaultFieldValue;
    }

    public AdditionalActionsDictionary getAdditionalActionsDictionary() {
        return this.additionalActionsDictionary;
    }
}

