/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.color.ColorSpace;

public class ColorSpaceCMYK
extends ColorSpace {
    private static final String[] NAMES = new String[]{"Cyan", "Magenta", "Yellow", "Black"};
    private static final ColorSpace COLOR_SPACE_sRGB = ColorSpace.getInstance(1000);
    private float[] _rgbValues = new float[4];

    public ColorSpaceCMYK() {
        super(9, 4);
    }

    public int getNumComponents() {
        return 4;
    }

    public String getName(int index) {
        return NAMES[index];
    }

    public int getType() {
        return 9;
    }

    public boolean isCS_sRGB() {
        return false;
    }

    public float[] fromRGB(float[] rgbValues) {
        float c = 1.0f - rgbValues[0];
        float m = 1.0f - rgbValues[1];
        float y = 1.0f - rgbValues[2];
        float k = Math.min(c, Math.min(m, y));
        float km = Math.max(c, Math.max(m, y));
        if (km > k) {
            k = k * k * k / (km * km);
        }
        float[] cmykValues = new float[]{c -= k, m -= k, y -= k, k};
        return cmykValues;
    }

    public float[] toRGB(float[] cmykValues) {
        float c = cmykValues[0];
        float m = cmykValues[1];
        float y = cmykValues[2];
        float k = cmykValues[3];
        c += k;
        m += k;
        y += k;
        if (c < 0.0f) {
            c = 0.0f;
        } else if (c > 1.0f) {
            c = 1.0f;
        }
        if (m < 0.0f) {
            m = 0.0f;
        } else if (m > 1.0f) {
            m = 1.0f;
        }
        if (y < 0.0f) {
            y = 0.0f;
        } else if (y > 1.0f) {
            y = 1.0f;
        }
        c = 1.0f - c;
        m = 1.0f - m;
        y = 1.0f - y;
        float[] rgbValues = new float[4];
        rgbValues[0] = c;
        rgbValues[1] = m;
        rgbValues[2] = y;
        return rgbValues;
    }

    public float[] fromCIEXYZ(float[] colorvalue) {
        return this.fromRGB(COLOR_SPACE_sRGB.fromCIEXYZ(colorvalue));
    }

    public float[] toCIEXYZ(float[] colorvalue) {
        return COLOR_SPACE_sRGB.toCIEXYZ(this.toRGB(colorvalue));
    }
}

