/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics.text;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.icepdf.core.pobjects.graphics.text.AbstractText;
import org.icepdf.core.pobjects.graphics.text.GlyphText;
import org.icepdf.core.pobjects.graphics.text.TextSelect;
import org.icepdf.core.pobjects.graphics.text.WordText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineText
extends AbstractText
implements TextSelect {
    private WordText currentWord;
    private List<WordText> words = new ArrayList<WordText>(16);

    @Override
    public Rectangle2D.Float getBounds() {
        if (this.bounds == null) {
            for (WordText word : this.words) {
                if (this.bounds == null) {
                    this.bounds = new Rectangle2D.Float();
                    this.bounds.setRect(word.getBounds());
                    continue;
                }
                this.bounds.add(word.getBounds());
            }
            if (this.bounds == null) {
                this.bounds = new Rectangle2D.Float();
            }
        }
        return this.bounds;
    }

    protected void addText(GlyphText sprite) {
        if (WordText.detectWhiteSpace(sprite) || WordText.detectPunctuation(sprite, this.currentWord)) {
            WordText newWord = new WordText();
            newWord.setWhiteSpace(true);
            newWord.addText(sprite);
            this.addWord(newWord);
            this.currentWord = null;
        } else if (this.getCurrentWord().detectSpace(sprite)) {
            WordText spaceWord = this.currentWord.buildSpaceWord(sprite);
            spaceWord.setWhiteSpace(true);
            this.addWord(spaceWord);
            this.currentWord = null;
            this.addText(sprite);
        } else {
            this.getCurrentWord().addText(sprite);
        }
    }

    public void clearCurrentWord() {
        if (this.currentWord != null && this.currentWord.size() == 0) {
            return;
        }
        this.currentWord = null;
    }

    private void addWord(WordText wordText) {
        this.words.add(wordText);
        this.currentWord = wordText;
    }

    public void addAll(List<WordText> words) {
        this.words.addAll(words);
    }

    protected void setWords(List<WordText> words) {
        this.words = words;
    }

    private WordText getCurrentWord() {
        if (this.currentWord == null) {
            this.currentWord = new WordText();
            this.words.add(this.currentWord);
        }
        return this.currentWord;
    }

    public List<WordText> getWords() {
        return this.words;
    }

    @Override
    public void selectAll() {
        this.setSelected(true);
        this.setHasSelected(true);
        for (WordText word : this.words) {
            word.selectAll();
        }
    }

    @Override
    public void clearSelected() {
        this.setSelected(false);
        this.setHasSelected(false);
        for (WordText word : this.words) {
            word.clearSelected();
        }
    }

    @Override
    public void clearHighlighted() {
        this.setHighlighted(false);
        this.setHasHighlight(false);
        for (WordText word : this.words) {
            word.setHighlighted(false);
        }
    }

    @Override
    public StringBuilder getSelected() {
        StringBuilder selectedText = new StringBuilder();
        for (WordText word : this.words) {
            selectedText.append((CharSequence)word.getSelected());
        }
        return selectedText;
    }

    public String toString() {
        return this.words.toString();
    }
}

