/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoftLRUCache<K, V> {
    private LinkedHashMap<K, SoftReference<V>> lruCache;
    private ReferenceQueue<? super V> reqQueue;

    public SoftLRUCache(int aInitialSize) {
        this.lruCache = new LinkedHashMap(aInitialSize, 0.75f, true);
        this.reqQueue = new ReferenceQueue();
    }

    public V get(K aKey) {
        this.diposeStaleEntries();
        SoftReference<V> ref = this.lruCache.get(aKey);
        if (ref != null) {
            return ref.get();
        }
        return null;
    }

    public V put(K aKey, V aValue) {
        this.diposeStaleEntries();
        SoftReference oldValue = this.lruCache.put(aKey, new KeyReference<K, V>(aKey, aValue, this.reqQueue));
        if (oldValue != null) {
            return (V)oldValue.get();
        }
        return null;
    }

    private void diposeStaleEntries() {
        KeyReference ref;
        while ((ref = (KeyReference)this.reqQueue.poll()) != null) {
            this.lruCache.remove(ref.getKey());
        }
    }

    public void clear() {
        this.lruCache.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeyReference<K, V>
    extends SoftReference<V> {
        private K key;

        public KeyReference(K key, V value, ReferenceQueue<? super V> refQueue) {
            super(value, refQueue);
            this.key = key;
        }

        public K getKey() {
            return this.key;
        }
    }
}

