/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.rabbitmq.connection;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import kd.isc.rabbitmq.connection.RabbitConnectionFactory;
import kd.isc.rabbitmq.consumer.QueueManager;
import kd.isc.rabbitmq.entity.ConnectionEntity;
import org.apache.log4j.Logger;

public class ChannelFactory {
    private static Logger logger = Logger.getLogger((String)ChannelFactory.class.getName());

    private ChannelFactory() {
    }

    public static Channel getChannel(String region, ConnectionEntity xmlConInfo) {
        if (xmlConInfo == null) {
            logger.error((Object)"get MQ connection information failed.");
            throw new RuntimeException("create MQ channel ,get MQ connection information failed.");
        }
        String serverKey = QueueManager.getRegionServerKey(xmlConInfo.getUserName(), region);
        Connection con = null;
        Channel channel = null;
        try {
            con = RabbitConnectionFactory.getConnection(serverKey, xmlConInfo);
            channel = con.createChannel();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage());
            throw new RuntimeException("can't create channel", e);
        }
        return channel;
    }
}

