/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.rabbitmq.connection;

import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import kd.isc.rabbitmq.constant.MQConstantEnum;
import kd.isc.rabbitmq.entity.ConnectionEntity;
import kd.isc.rabbitmq.thread.ThreadLifeCycleManager;
import kd.isc.rabbitmq.util.PropertiesUtils;
import kd.isc.rabbitmq.util.StringUtils;
import org.apache.log4j.Logger;

public class RabbitConnectionFactory {
    private static Logger logger = Logger.getLogger((String)RabbitConnectionFactory.class.getName());
    private static ConcurrentHashMap<String, Connection> poolMap = new ConcurrentHashMap();
    private static final int DEFAULT_THREAD_NUM = 10;

    private RabbitConnectionFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection(String serverKey, ConnectionEntity xmlConInfo) {
        if (poolMap.containsKey(serverKey)) {
            return poolMap.get(serverKey);
        }
        Connection client = null;
        Class<RabbitConnectionFactory> clazz = RabbitConnectionFactory.class;
        synchronized (RabbitConnectionFactory.class) {
            if (poolMap.containsKey(serverKey)) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return poolMap.get(serverKey);
            }
            try {
                client = RabbitConnectionFactory.createConnection(xmlConInfo);
                poolMap.put(serverKey, client);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
                throw new RuntimeException(e.getMessage());
            }
            return client;
        }
    }

    private static Connection createConnection(ConnectionEntity xmlConInfo) {
        Connection connection = null;
        if (StringUtils.isNullObj(xmlConInfo)) {
            return connection;
        }
        try {
            ConnectionFactory factory = new ConnectionFactory();
            factory.setUsername(xmlConInfo.getUserName());
            factory.setPassword(xmlConInfo.getPassword());
            factory.setHost(xmlConInfo.getHost());
            factory.setPort(StringUtils.isEmpty(xmlConInfo.getPort()) ? 5672 : Integer.parseInt(xmlConInfo.getPort()));
            ExecutorService es = RabbitConnectionFactory.getExecutorService();
            factory.setAutomaticRecoveryEnabled(true);
            factory.setNetworkRecoveryInterval(180000);
            factory.setTopologyRecoveryEnabled(true);
            connection = factory.newConnection(es);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
        return RabbitConnectionFactory.wrap(connection);
    }

    private static ExecutorService getExecutorService() {
        ExecutorService es = Executors.newFixedThreadPool(10, new ThreadFactory(){
            private AtomicInteger atomicInteger = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "MQ-rabbit-pool-" + this.atomicInteger.incrementAndGet());
            }
        });
        Properties prop = PropertiesUtils.loadProperties();
        String sysType = prop.getProperty(MQConstantEnum.MQ_SERVER_TYPE.getDesc());
        if (MQConstantEnum.IERP_SYSTME.getDesc().equals(sysType)) {
            try {
                Class<?> clazz = Class.forName("kd.bos.thread.ThreadLifeCycleManager");
                Method method = clazz.getMethod("wrapExecutorService", ExecutorService.class);
                return (ExecutorService)method.invoke(clazz.newInstance(), es);
            }
            catch (Exception e) {
                logger.warn((Object)("ierp system don't exist class:" + e.getMessage()));
            }
        }
        return ThreadLifeCycleManager.wrapExecutorService(es);
    }

    private static Connection wrap(Connection connection) {
        return connection;
    }
}

