/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.rabbitmq.consumer;

import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kd.isc.rabbitmq.entity.ConnectionEntity;
import kd.isc.rabbitmq.entity.ConsumerDef;
import kd.isc.rabbitmq.entity.IERPConsumerQueue;
import kd.isc.rabbitmq.entity.ProductorEntity;
import kd.isc.rabbitmq.entity.QueueDef;
import kd.isc.rabbitmq.initialize.InitQueue;
import kd.isc.rabbitmq.util.CollectionUtils;
import kd.isc.rabbitmq.util.MD5EncryptUtils;
import kd.isc.rabbitmq.util.StringUtils;
import org.apache.log4j.Logger;

public class QueueManager {
    private static final Logger logger = Logger.getLogger((String)QueueManager.class.getName());
    private static ConcurrentHashMap<String, QueueDef> queueDefs = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Boolean> queueDeclared = new ConcurrentHashMap();
    private static String queueTag = System.getProperty("mq.debug.queue.tag");
    private static final String CALLBACK = "callback";

    private QueueManager() {
    }

    public static String getRealQueueName(String userName, String pwd, String region, String queueName, boolean needCallBack) {
        StringBuilder queneBuffer = new StringBuilder();
        String encryptUserAndPwd = MD5EncryptUtils.encryptBy16BitMD5(String.valueOf(userName) + "_" + pwd);
        queneBuffer.append(userName).append(".").append(encryptUserAndPwd).append(".").append(region).append(".").append(queueName);
        queueTag = System.getProperty("mq.debug.queue.tag");
        if (StringUtils.isNotEmpty(queueTag)) {
            queneBuffer.append(".").append(queueTag);
        }
        if (needCallBack) {
            queneBuffer.append(".").append(CALLBACK);
        }
        return queneBuffer.toString();
    }

    public static String getRegionServerKey(String userName, String region) {
        return String.valueOf(userName) + "." + "mq.server." + region;
    }

    public static QueueDef get(String userName, String region, String queue) {
        return queueDefs.get(QueueManager.makeKey(userName, region, queue));
    }

    public static void declareIfNeed(Channel channel, String region, String queue) {
        String key = QueueManager.makeKey(region, queue);
        if (Boolean.TRUE.equals(queueDeclared.get(key))) {
            return;
        }
        try {
            channel.queueDeclare(queue, false, false, false, null);
            queueDeclared.putIfAbsent(key, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void add(String region, QueueDef queueDef, ConnectionEntity conn) {
        String key = QueueManager.makeKey(conn.getUserName(), region, queueDef.getName());
        if (queueDefs != null && !queueDefs.containsKey(key)) {
            queueDefs.put(key, queueDef);
        }
        QueueManager.initQueue(region, queueDef, conn);
    }

    public static void initIerpPerConsumerQueue(IERPConsumerQueue consumerQueue, ConnectionEntity conn, ProductorEntity autoCallBackProductor, boolean isSubscribe) {
        if (conn == null) {
            logger.error((Object)"init ierp queue,the MQ connection information is null.");
            throw new RuntimeException("init ierp queue,the MQ connection information is null.");
        }
        String queueName = QueueManager.getRealQueueName(conn.getUserName(), conn.getPassword(), consumerQueue.getRegion(), consumerQueue.getQueueName(), isSubscribe);
        int i = 0;
        while (i < consumerQueue.getThreadCount()) {
            InitQueue.initIerpConsumer(consumerQueue, queueName, conn, autoCallBackProductor);
            ++i;
        }
    }

    private static void initQueue(String region, QueueDef queueDef, ConnectionEntity conn) {
        if (queueDef == null) {
            return;
        }
        List<ConsumerDef> consumers = queueDef.getConsumers();
        if (CollectionUtils.isEmpty(consumers)) {
            logger.error((Object)("MQ config consumers is empty for " + region + "/" + queueDef.getName()));
            return;
        }
        String productorName = queueDef.getProductor();
        boolean needCallBack = StringUtils.isNotEmpty(productorName);
        String queueName = QueueManager.getRealQueueName(conn.getUserName(), conn.getPassword(), region, queueDef.getName(), false);
        int threadCount = queueDef.getThreadCount() == 0 ? 1 : queueDef.getThreadCount();
        for (ConsumerDef consumer : consumers) {
            int i = 0;
            while (i < threadCount) {
                InitQueue.initConsumer(region, queueName, consumer.getClassName(), consumer.isAutoAck(), conn, needCallBack, productorName);
                ++i;
            }
        }
        int i = 1;
        while (i < consumers.size()) {
            logger.warn((Object)("mq.usage consumer " + consumers.get(i).getClassName() + " ignored. only one cunsumer allowed."));
            ++i;
        }
    }

    public static String makeKey(String userName, String region, String queueName) {
        if (StringUtils.isEmpty(region)) {
            return String.valueOf(userName) + "." + "mq.server." + queueName;
        }
        return String.valueOf(userName) + "_" + region + "_" + queueName;
    }

    private static String makeKey(String region, String queue) {
        return String.valueOf(region) + "." + queue;
    }
}

