/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.rabbitmq.consumer.ack;

import com.alibaba.fastjson.JSONObject;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import kd.isc.rabbitmq.connection.ChannelFactory;
import kd.isc.rabbitmq.consumer.QueueManager;
import kd.isc.rabbitmq.consumer.ack.MessageAcker;
import kd.isc.rabbitmq.entity.ConnectionEntity;
import kd.isc.rabbitmq.entity.ExtendEntity;
import kd.isc.rabbitmq.entity.ProductorEntity;
import kd.isc.rabbitmq.initialize.ConfigManager;
import kd.isc.rabbitmq.productor.publish.RabbitMQPublisher;
import kd.isc.rabbitmq.util.StringUtils;
import org.apache.log4j.Logger;

public class RabbitAcker
implements MessageAcker {
    private static final Logger logger = Logger.getLogger((String)RabbitAcker.class.getName());
    private Channel channel;
    private boolean autoAck;
    private boolean needCallBack;
    private String queueName;
    private String region;
    private String productorName;
    private ProductorEntity autoCallBackProductor;
    private ConnectionEntity connectionInfo;
    private boolean isFinsh;

    public RabbitAcker(Channel channel, boolean autoAck, boolean needCallBack, String queueName, String region, String productorName) {
        this.channel = channel;
        this.autoAck = autoAck;
        this.needCallBack = needCallBack;
        this.queueName = queueName;
        this.region = region;
        this.productorName = productorName;
    }

    public RabbitAcker(Channel channel, boolean autoAck, boolean needCallBack, String queueName, String region, ProductorEntity autoCallBackProductor, ConnectionEntity connectionInfo) {
        this.channel = channel;
        this.autoAck = autoAck;
        this.needCallBack = needCallBack;
        this.queueName = queueName;
        this.region = region;
        this.autoCallBackProductor = autoCallBackProductor;
        this.connectionInfo = connectionInfo;
    }

    @Override
    public void ack(String messageId, String data) {
        this.setFinsh(true);
        if (!this.autoAck) {
            long deliveryTag = this.toTag(messageId);
            try {
                this.dealCallBackMsg(data);
                this.channel.basicAck(deliveryTag, false);
            }
            catch (IOException e) {
                throw new RuntimeException("can't ack the message " + deliveryTag, e);
            }
        }
    }

    private void dealCallBackMsg(String data) {
        if (StringUtils.isEmpty(data)) {
            logger.warn((Object)"the deal callback message ,message body is null.");
            return;
        }
        if (this.needCallBack) {
            ExtendEntity extendEntity = null;
            JSONObject entendData = null;
            Channel backChannel = null;
            if (StringUtils.isNotEmpty(this.productorName)) {
                ProductorEntity productor = ConfigManager.getProductor(this.productorName);
                if (!StringUtils.isNullObj(productor)) {
                    ConnectionEntity prodConn = ConfigManager.getConnection(productor.getConnection());
                    backChannel = ChannelFactory.getChannel(this.region, prodConn);
                    extendEntity = productor.getExtend();
                }
            } else if (this.autoCallBackProductor != null) {
                backChannel = ChannelFactory.getChannel(this.region, this.connectionInfo);
                extendEntity = this.autoCallBackProductor.getExtend();
            }
            if (!StringUtils.isNullObj(extendEntity)) {
                entendData = extendEntity.getExtendData();
            }
            String realQueueName = String.valueOf(this.queueName) + ".callback";
            QueueManager.declareIfNeed(backChannel, this.region, realQueueName);
            new RabbitMQPublisher(realQueueName, backChannel, entendData).publish(data);
        }
    }

    private long toTag(String messageId) {
        return Long.parseLong(messageId);
    }

    @Override
    public void deny(String messageId) {
        this.setFinsh(true);
        if (!this.autoAck) {
            long deliveryTag = this.toTag(messageId);
            try {
                this.channel.basicReject(deliveryTag, true);
            }
            catch (IOException e) {
                throw new RuntimeException("can't ack the message " + deliveryTag, e);
            }
        }
    }

    @Override
    public boolean isFinsh() {
        return this.isFinsh;
    }

    @Override
    public void setFinsh(Boolean finish) {
        this.isFinsh = finish;
    }
}

