/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.rabbitmq.consumer.subscribe;

import com.alibaba.fastjson.JSONObject;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import kd.isc.rabbitmq.connection.ChannelFactory;
import kd.isc.rabbitmq.consumer.QueueManager;
import kd.isc.rabbitmq.consumer.ack.RabbitAcker;
import kd.isc.rabbitmq.consumer.subscribe.MessageConsumer;
import kd.isc.rabbitmq.entity.ConnectionEntity;
import kd.isc.rabbitmq.entity.ProductorEntity;
import kd.isc.rabbitmq.support.MessageSerde;
import kd.isc.rabbitmq.util.CollectionUtils;
import kd.isc.rabbitmq.util.RabbitMQCacheUtils;
import kd.isc.rabbitmq.util.RabbitMQReflectInvokeUtils;
import kd.isc.rabbitmq.util.StringUtils;
import org.apache.log4j.Logger;

public class RabbitConsumer
extends DefaultConsumer {
    private static Logger logger = Logger.getLogger((String)RabbitConsumer.class.getName());
    private String queue;
    private boolean autoAck;
    private MessageConsumer mc;
    private String region;
    private RabbitAcker acker;
    private boolean needCallBack;
    private String productorName;
    private ProductorEntity autoCallBackProductor;
    private ConnectionEntity connectionInfo;

    public RabbitConsumer(String region, String queue, boolean autoAck, ConnectionEntity connectionInfo, MessageConsumer mc, boolean needCallBack, String productorName) {
        super(ChannelFactory.getChannel(region, connectionInfo));
        this.region = region;
        this.queue = queue;
        this.autoAck = autoAck;
        this.mc = mc;
        this.needCallBack = needCallBack;
        this.productorName = productorName;
    }

    public RabbitConsumer(String region, String queue, boolean autoAck, ConnectionEntity connectionInfo, MessageConsumer mc, boolean needCallBack, ProductorEntity autoCallBackProductor) {
        super(ChannelFactory.getChannel(region, connectionInfo));
        this.region = region;
        this.queue = queue;
        this.autoAck = autoAck;
        this.mc = mc;
        this.needCallBack = needCallBack;
        this.autoCallBackProductor = autoCallBackProductor;
        this.connectionInfo = connectionInfo;
    }

    public void start() {
        Channel channel = this.getChannel();
        this.acker = new RabbitAcker(channel, this.autoAck, this.needCallBack, this.queue, this.region, this.productorName);
        QueueManager.declareIfNeed(this.getChannel(), this.region, this.queue);
        try {
            channel.basicQos(1);
            channel.basicConsume(this.queue, this.autoAck, (Consumer)this);
        }
        catch (IOException e) {
            throw new RuntimeException("Can't init consumer for queue " + this.queue, e);
        }
    }

    public void ierpStart() {
        Channel channel = this.getChannel();
        this.acker = new RabbitAcker(channel, this.autoAck, this.needCallBack, this.queue, this.region, this.autoCallBackProductor, this.connectionInfo);
        QueueManager.declareIfNeed(channel, this.region, this.queue);
        try {
            channel.basicQos(1);
            channel.basicConsume(this.queue, this.autoAck, (Consumer)this);
            RabbitMQCacheUtils.clear(this.queue);
            RabbitMQCacheUtils.putChannel(this.queue, channel);
        }
        catch (IOException e) {
            logger.error((Object)("start channel failed,Can't init consumer for queue " + this.queue), (Throwable)e);
            throw new RuntimeException("start channel failed,Can't init consumer for queue " + this.queue, e);
        }
    }

    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        RabbitMQReflectInvokeUtils.consumerMsgHandcapacity(body);
        this.ierpDisableQueue();
        String messageId = String.valueOf(envelope.getDeliveryTag());
        JSONObject havaContextJson = this.toMessage(body);
        String message = this.toMessage(havaContextJson);
        try {
            JSONObject extendObj = JSONObject.parseObject((String)havaContextJson.getString("extend"));
            this.mc.initContext(extendObj, messageId, envelope.isRedeliver(), this.acker);
        }
        catch (Exception e) {
            JSONObject expJson = new JSONObject();
            expJson.put("data", (Object)havaContextJson);
            expJson.put("errorMsg", (Object)e.getMessage());
            this.acker.ack(messageId, expJson.toJSONString());
        }
        if (!this.acker.isFinsh()) {
            try {
                try {
                    this.mc.onMessage(message, messageId, envelope.isRedeliver(), this.acker);
                }
                catch (Exception e) {
                    logger.error((Object)("rabbit consumer handleDelivery message failed.exception info:" + e));
                    this.acker.setFinsh(false);
                }
            }
            finally {
                this.acker.setFinsh(false);
            }
        }
    }

    private JSONObject toMessage(byte[] body) {
        return MessageSerde.get().decode(body);
    }

    private String toMessage(JSONObject mqData) {
        String data = null;
        if (!StringUtils.isNullObj(mqData) && mqData.containsKey((Object)"data")) {
            data = mqData.getString("data");
        }
        return data;
    }

    private void ierpDisableQueue() {
        if (RabbitMQCacheUtils.containKey(this.queue) && !CollectionUtils.isEmpty(RabbitMQCacheUtils.takeChanel(this.queue))) {
            for (Channel ch : RabbitMQCacheUtils.takeChanel(this.queue)) {
                try {
                    ch.close();
                }
                catch (Exception e) {
                    logger.error((Object)("the channel close failed.exception info :" + e));
                }
            }
            RabbitMQCacheUtils.removeChannel(this.queue);
        }
    }
}

