/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.rabbitmq.productor.mqfactory;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.isc.rabbitmq.entity.ProductorParamEntity;
import kd.isc.rabbitmq.productor.mqfactory.MQFactory;
import kd.isc.rabbitmq.productor.publish.MessagePublisher;
import kd.isc.rabbitmq.util.RabbitMQReflectInvokeUtils;
import kd.isc.rabbitmq.util.StringUtils;
import org.apache.log4j.Logger;

public class MQProductor {
    private static Logger logger = Logger.getLogger((String)MQProductor.class.getName());

    public static void publish(String name, String message) throws Exception {
        logger.info((Object)"no ierp system the productor publish message to MQ server begin...");
        if (StringUtils.isEmpty(name) || StringUtils.isEmpty(message)) {
            logger.error((Object)"The productor send message param is null.");
            throw new RuntimeException("the productor publish MQ message,the parameter is null.");
        }
        MQFactory factory = MQFactory.getPublisher(name);
        if (factory == null) {
            logger.error((Object)"the productor publish MQ message,get proudctor information is null.");
            throw new RuntimeException("the productor publish MQ message,get proudctor information is null.");
        }
        List<MessagePublisher> pubList = factory.createSimplePublisher();
        for (MessagePublisher pub : pubList) {
            pub.publish(message);
            pub.close();
        }
    }

    public static void publish(ProductorParamEntity paramEntity) throws Exception {
        logger.info((Object)"Other system the productor publish message to MQ begin...");
        if (paramEntity == null) {
            logger.error((Object)"The productor send message param is null.");
            throw new RuntimeException("the productor publish MQ message,the parameter is null.");
        }
        MessagePublisher publish = null;
        try {
            try {
                MQFactory factory = MQFactory.get(paramEntity.getName());
                if (factory == null) {
                    logger.error((Object)"other system create MQ factory failed......");
                    throw new RuntimeException("other system create MQ factory failed.");
                }
                publish = factory.createSimplePublisher(paramEntity.getRegion(), paramEntity.getQueueName(), paramEntity.getAutoSubscribeClass());
                publish.publish(paramEntity.getMessage());
            }
            catch (Exception e) {
                logger.error((Object)("Other system MQ productor send message failed. exception info:" + e.getMessage()));
                throw new RuntimeException("Other system MQ productor send message failed.", e);
            }
        }
        finally {
            if (publish != null) {
                publish.close();
            }
        }
    }

    public static void publish(ProductorParamEntity paramEntity, String message, JSONObject productorExt) throws Exception {
        logger.info((Object)"The ierp system productor publish message begin...");
        if (paramEntity == null || productorExt == null) {
            logger.error((Object)"the ierp system productor publish message,method parameter is null.");
            throw new RuntimeException("the ierp system productor publish message,method parameter is null.");
        }
        if (paramEntity.getMqConnnection() == null) {
            logger.error((Object)"the ierp system productor publish message,MQ connection parameter is null.");
            throw new RuntimeException("the ierp system productor publish message,MQ connection parameter is null.");
        }
        MessagePublisher publish = null;
        try {
            try {
                MQFactory factory = MQFactory.get();
                if (factory == null) {
                    logger.error((Object)"IERP sytem create MQ factory failed......");
                    throw new RuntimeException("IERP sytem create MQ factory failed.");
                }
                publish = factory.createSimplePublisher(paramEntity.getRegion(), paramEntity.getQueueName(), paramEntity.getAutoSubscribeClass(), paramEntity.getMqConnnection(), productorExt);
                publish.publish(message);
                if (!StringUtils.isEmpty(message)) {
                    RabbitMQReflectInvokeUtils.publishMsgHandcapacity(message.getBytes());
                }
            }
            catch (Exception e) {
                logger.error((Object)("IERP sytem MQ productor send message failed. exception info:" + e.getMessage()));
                throw new RuntimeException("IERP sytem MQ productor send message failed.", e);
            }
        }
        finally {
            if (publish != null) {
                publish.close();
            }
        }
    }
}

