/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.rabbitmq.productor.publish;

import com.alibaba.fastjson.JSONObject;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import kd.isc.rabbitmq.constant.MQConstantEnum;
import kd.isc.rabbitmq.entity.ProductorEntity;
import kd.isc.rabbitmq.initialize.ConfigManager;
import kd.isc.rabbitmq.productor.mqfactory.MQFactory;
import kd.isc.rabbitmq.productor.mqfactory.RabbitMQFactory;
import kd.isc.rabbitmq.productor.publish.MessagePublisher;
import kd.isc.rabbitmq.support.MessageSerde;
import kd.isc.rabbitmq.util.StringUtils;
import org.apache.log4j.Logger;

public class RabbitMQPublisher
implements MessagePublisher {
    private static Logger logger = Logger.getLogger((String)RabbitMQPublisher.class.getName());
    private String queueName;
    private Channel channel;
    private JSONObject contextInfo;

    public RabbitMQPublisher(String queueName, Channel channel, JSONObject contextInfo) {
        this.queueName = queueName;
        this.channel = channel;
        if (contextInfo == null) {
            contextInfo = new JSONObject();
        }
        this.contextInfo = contextInfo;
    }

    @Override
    public MQFactory getConnection(String name) {
        if (StringUtils.isEmpty(name)) {
            return new RabbitMQFactory();
        }
        ProductorEntity productor = ConfigManager.getProductor(name);
        if (StringUtils.isNullObj(productor)) {
            return null;
        }
        if (MQConstantEnum.RABBITMQ_TYPE.getDesc().equalsIgnoreCase(productor.getType())) {
            return new RabbitMQFactory();
        }
        return null;
    }

    @Override
    public void publish(byte[] message) {
        this.publish0(message);
    }

    @Override
    public void publish(String message) {
        this.publish0(message);
    }

    @Override
    public void publish(Object message) {
        this.publish0(message);
    }

    @Override
    public void close() {
        try {
            if (!StringUtils.isNullObj(this.channel)) {
                this.channel.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)"RabbitMQ channel close failed.");
            throw new RuntimeException(e.getMessage());
        }
    }

    private void publish0(Object body) {
        try {
            byte[] bytes = MessageSerde.get().encode(this.toMessage(body));
            this.channel.basicPublish("", this.queueName, null, bytes);
        }
        catch (IOException e) {
            logger.error((Object)"can't publish message.");
            throw new RuntimeException(e.getMessage());
        }
    }

    private String toMessage(Object body) {
        HashMap<String, String> extendMap = new HashMap<String, String>();
        JSONObject json = new JSONObject();
        if (this.contextInfo != null) {
            for (Map.Entry entry : this.contextInfo.entrySet()) {
                extendMap.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        json.put(MQConstantEnum.ATTR_EXTEND.getDesc(), extendMap);
        json.put(MQConstantEnum.JSONOBJ_DATA_ATTR.getDesc(), body);
        return json.toJSONString();
    }
}

