/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.rabbitmq.support;

import com.alibaba.fastjson.JSONObject;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kd.isc.rabbitmq.support.MessageSerde;
import org.apache.log4j.Logger;

public class HessianMessageSerde
extends MessageSerde {
    private static Logger logger = Logger.getLogger((String)HessianMessageSerde.class.getName());
    public static final HessianMessageSerde instance = new HessianMessageSerde();

    @Override
    public byte[] encode(String message) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Hessian2Output h2o = new Hessian2Output((OutputStream)os);
        byte[] buffer = null;
        try {
            try {
                h2o.startMessage();
                h2o.writeObject((Object)message);
                h2o.completeMessage();
                h2o.close();
                buffer = os.toByteArray();
            }
            catch (Exception e) {
                logger.error((Object)"can't encode message.");
                throw new RuntimeException("can't encode message.", e);
            }
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {
                logger.error((Object)"ByteArrayOutputStream stream close failed.");
            }
        }
        return buffer;
    }

    @Override
    public JSONObject decode(byte[] bytes) {
        Hessian2Input h2i = new Hessian2Input((InputStream)new ByteArrayInputStream(bytes));
        String msg = null;
        try {
            h2i.startMessage();
            msg = (String)h2i.readObject();
        }
        catch (Exception e) {
            logger.error((Object)"can't decode message.");
            throw new RuntimeException("can't decode message.", e);
        }
        return JSONObject.parseObject((String)msg);
    }
}

