/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.rabbitmq.thread;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kd.isc.rabbitmq.constant.MQConstantEnum;
import kd.isc.rabbitmq.entity.MQConfInfoEntity;
import kd.isc.rabbitmq.initialize.InitConfig;
import kd.isc.rabbitmq.util.StringUtils;
import org.apache.log4j.Logger;

public class RefreshReadTask
implements Runnable {
    private static Logger log = Logger.getLogger((String)RefreshReadTask.class.getName());
    private Properties sysProperties;

    public RefreshReadTask(Properties sysProperties) {
        this.sysProperties = sysProperties;
    }

    @Override
    public void run() {
        if (this.sysProperties == null) {
            log.error((Object)"the rabbitmq system properties config file is null.");
            return;
        }
        String path = this.sysProperties.getProperty(MQConstantEnum.MQ_CONFIG_PATH.getDesc());
        String dealClass = this.sysProperties.getProperty(MQConstantEnum.MQ_CONFIG_INITCLASS.getDesc());
        String strRefreshTime = this.sysProperties.getProperty(MQConstantEnum.MQ_CONFIG_REFRESH.getDesc());
        String sysType = this.sysProperties.getProperty(MQConstantEnum.MQ_SERVER_TYPE.getDesc());
        try {
            MQConfInfoEntity mqConfig = null;
            while (true) {
                mqConfig = InitConfig.loadMQConfigInfo(dealClass, path);
                InitConfig.cacheMQConfigInfo(sysType, mqConfig);
                TimeUnit.MINUTES.sleep(StringUtils.isEmpty(strRefreshTime) ? 0 : Integer.parseInt(strRefreshTime));
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            return;
        }
    }
}

