/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.rabbitmq.util;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import kd.isc.rabbitmq.entity.ExtendEntity;
import kd.isc.rabbitmq.entity.MQConfInfoEntity;
import kd.isc.rabbitmq.entity.ProductorEntity;
import kd.isc.rabbitmq.entity.ProductorsEntity;
import kd.isc.rabbitmq.util.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class XmlParseUtil {
    private static Logger log = Logger.getLogger((String)XmlParseUtil.class.getName());
    private static final String ENCODING = "UTF-8";

    public static synchronized MQConfInfoEntity execute(String path) {
        ProductorsEntity productorsEntity;
        String xml;
        MQConfInfoEntity config;
        block24: {
            if (StringUtils.isEmpty(path)) {
                log.error((Object)"the config file path isn't exist.");
                throw new RuntimeException("read the config file,this path isn't exist");
            }
            config = null;
            xml = null;
            if (path.indexOf("/kd/isc") == 0) {
                log.info((Object)"read inner jar xml config file begin...");
                InputStream in = null;
                try {
                    try {
                        in = MQConfInfoEntity.class.getResourceAsStream(path);
                        xml = StringUtils.fromInputStream(in, ENCODING);
                        break block24;
                    }
                    catch (IOException e) {
                        log.error((Object)("Can't load file:" + path), (Throwable)e);
                        throw new RuntimeException("Can't load xml config file", e);
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            log.error((Object)"InputStream close failed.", (Throwable)e);
                        }
                    }
                }
            }
            FileInputStream fileIn = null;
            File file = null;
            try {
                try {
                    file = new File(path);
                    fileIn = new FileInputStream(file);
                    xml = StringUtils.fromInputStream(fileIn, ENCODING);
                }
                catch (Exception e) {
                    log.error((Object)("Can't load file:" + path), (Throwable)e);
                    throw new RuntimeException("Can't load xml config file", e);
                }
            }
            finally {
                if (fileIn != null) {
                    try {
                        fileIn.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"InputStream close failed.", (Throwable)e);
                    }
                }
            }
        }
        if (xml == null) {
            log.error((Object)"read xml config file information faild.");
            return null;
        }
        config = XmlParseUtil.parse(xml);
        if (!StringUtils.isNullObj(config) && (productorsEntity = XmlParseUtil.parseRootSonNode(xml, ProductorsEntity.class)) != null) {
            config.setProductors(productorsEntity);
        }
        return config;
    }

    private static MQConfInfoEntity parse(String xml) {
        return XmlParseUtil.parse(new StringReader(xml));
    }

    private static MQConfInfoEntity parse(Reader reader) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{MQConfInfoEntity.class});
            Unmarshaller un = jaxbContext.createUnmarshaller();
            return (MQConfInfoEntity)un.unmarshal(reader);
        }
        catch (Exception e) {
            throw new RuntimeException("mq config infomation parse error.", e);
        }
    }

    private static <T> T parseRootSonNode(String xml, Class<T> clazz) {
        if (StringUtils.isEmpty(xml) || clazz == null) {
            log.error((Object)"parser config xml file param is not exist.");
            return null;
        }
        SAXReader reader = new SAXReader();
        ProductorsEntity productorsEntity = null;
        try {
            Document doc = reader.read((InputStream)new ByteArrayInputStream(xml.getBytes(ENCODING)));
            Element root = doc.getRootElement();
            Iterator proElementsIt = root.elementIterator();
            Element productorNode = null;
            Iterator sonNode = null;
            while (proElementsIt.hasNext()) {
                productorNode = (Element)proElementsIt.next();
                if (!"productors".equalsIgnoreCase(productorNode.getName())) continue;
                log.info((Object)"parse xml <productors> node begin...");
                productorsEntity = (ProductorsEntity)clazz.newInstance();
                ArrayList<ProductorEntity> productorList = new ArrayList<ProductorEntity>();
                productorsEntity.setProductors(productorList);
                sonNode = productorNode.elementIterator();
                while (sonNode.hasNext()) {
                    Element proEle = (Element)sonNode.next();
                    ProductorEntity productorEntity = new ProductorEntity();
                    List attrs = proEle.attributes();
                    for (Attribute attr : attrs) {
                        if ("type".equalsIgnoreCase(attr.getName())) {
                            productorEntity.setType(attr.getValue());
                            continue;
                        }
                        if ("name".equals(attr.getName())) {
                            productorEntity.setName(attr.getValue());
                            continue;
                        }
                        if (!"connection".equals(attr.getName())) continue;
                        productorEntity.setConnection(attr.getValue());
                    }
                    List list = proEle.elements();
                    Element exntendEle = (Element)list.get(0);
                    ExtendEntity extendEntity = new ExtendEntity();
                    JSONObject extendAttr = new JSONObject();
                    extendEntity.setExtendData(extendAttr);
                    Iterator sonExtendIt = exntendEle.elementIterator();
                    while (sonExtendIt.hasNext()) {
                        Element element = (Element)sonExtendIt.next();
                        extendAttr.put(element.getName(), (Object)element.getText());
                    }
                    productorEntity.setExtend(extendEntity);
                    productorList.add(productorEntity);
                }
                return (T)productorsEntity;
            }
        }
        catch (Exception e) {
            log.error((Object)"Dom4j parse xml config node failed.");
            throw new RuntimeException("Dom4j parse xml config node failed.", e);
        }
        return null;
    }

    public static void main(String[] args) {
        MQConfInfoEntity mq = XmlParseUtil.execute("/kd/isc/rabbitmq/isc-rabbitmq.xml");
        System.out.println(mq);
    }
}

