/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.asn1;

import cn.tca.TopBasicCrypto.asn1.ASN1EncodableVector;
import cn.tca.TopBasicCrypto.asn1.ASN1Object;
import cn.tca.TopBasicCrypto.asn1.DERInteger;
import cn.tca.TopBasicCrypto.asn1.DERObject;
import cn.tca.TopBasicCrypto.asn1.DERObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.DEROutputStream;
import cn.tca.TopBasicCrypto.asn1.DERTaggedObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DERExternal
extends ASN1Object {
    private DERObjectIdentifier directReference;
    private DERInteger indirectReference;
    private ASN1Object dataValueDescriptor;
    private int encoding;
    private DERObject externalContent;

    public DERExternal(ASN1EncodableVector vector) {
        int offset = 0;
        DERObject enc = this.getObjFromVector(vector, offset);
        if (enc instanceof DERObjectIdentifier) {
            this.directReference = (DERObjectIdentifier)enc;
            enc = this.getObjFromVector(vector, ++offset);
        }
        if (enc instanceof DERInteger) {
            this.indirectReference = (DERInteger)enc;
            enc = this.getObjFromVector(vector, ++offset);
        }
        if (!(enc instanceof DERTaggedObject)) {
            this.dataValueDescriptor = (ASN1Object)enc;
            enc = this.getObjFromVector(vector, ++offset);
        }
        if (vector.size() != offset + 1) {
            throw new IllegalArgumentException("input vector too large");
        }
        if (!(enc instanceof DERTaggedObject)) {
            throw new IllegalArgumentException("No tagged object found in vector. Structure doesn't seem to be of type External");
        }
        DERTaggedObject obj = (DERTaggedObject)enc;
        this.setEncoding(obj.getTagNo());
        this.externalContent = obj.getObject();
    }

    private DERObject getObjFromVector(ASN1EncodableVector v, int index) {
        if (v.size() <= index) {
            throw new IllegalArgumentException("too few objects in input vector");
        }
        return v.get(index).getDERObject();
    }

    public DERExternal(DERObjectIdentifier directReference, DERInteger indirectReference, ASN1Object dataValueDescriptor, DERTaggedObject externalData) {
        this(directReference, indirectReference, dataValueDescriptor, externalData.getTagNo(), externalData.getDERObject());
    }

    public DERExternal(DERObjectIdentifier directReference, DERInteger indirectReference, ASN1Object dataValueDescriptor, int encoding, DERObject externalData) {
        this.setDirectReference(directReference);
        this.setIndirectReference(indirectReference);
        this.setDataValueDescriptor(dataValueDescriptor);
        this.setEncoding(encoding);
        this.setExternalContent(externalData.getDERObject());
    }

    public int hashCode() {
        int ret = 0;
        if (this.directReference != null) {
            ret = this.directReference.hashCode();
        }
        if (this.indirectReference != null) {
            ret ^= this.indirectReference.hashCode();
        }
        if (this.dataValueDescriptor != null) {
            ret ^= this.dataValueDescriptor.hashCode();
        }
        return ret ^= this.externalContent.hashCode();
    }

    void encode(DEROutputStream out) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.directReference != null) {
            baos.write(this.directReference.getDEREncoded());
        }
        if (this.indirectReference != null) {
            baos.write(this.indirectReference.getDEREncoded());
        }
        if (this.dataValueDescriptor != null) {
            baos.write(this.dataValueDescriptor.getDEREncoded());
        }
        DERTaggedObject obj = new DERTaggedObject(this.encoding, this.externalContent);
        baos.write(obj.getDEREncoded());
        out.writeEncoded(32, 8, baos.toByteArray());
    }

    boolean asn1Equals(DERObject o) {
        if (!(o instanceof DERExternal)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        DERExternal other = (DERExternal)o;
        if (!(this.directReference == null || other.directReference != null && other.directReference.equals(this.directReference))) {
            return false;
        }
        if (!(this.indirectReference == null || other.indirectReference != null && other.indirectReference.equals(this.indirectReference))) {
            return false;
        }
        if (!(this.dataValueDescriptor == null || other.dataValueDescriptor != null && other.dataValueDescriptor.equals(this.dataValueDescriptor))) {
            return false;
        }
        return this.externalContent.equals(other.externalContent);
    }

    public ASN1Object getDataValueDescriptor() {
        return this.dataValueDescriptor;
    }

    public DERObjectIdentifier getDirectReference() {
        return this.directReference;
    }

    public int getEncoding() {
        return this.encoding;
    }

    public DERObject getExternalContent() {
        return this.externalContent;
    }

    public DERInteger getIndirectReference() {
        return this.indirectReference;
    }

    private void setDataValueDescriptor(ASN1Object dataValueDescriptor) {
        this.dataValueDescriptor = dataValueDescriptor;
    }

    private void setDirectReference(DERObjectIdentifier directReferemce) {
        this.directReference = directReferemce;
    }

    private void setEncoding(int encoding) {
        if (encoding < 0 || encoding > 2) {
            throw new IllegalArgumentException("invalid encoding value: " + encoding);
        }
        this.encoding = encoding;
    }

    private void setExternalContent(DERObject externalContent) {
        this.externalContent = externalContent;
    }

    private void setIndirectReference(DERInteger indirectReference) {
        this.indirectReference = indirectReference;
    }
}

