/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.asn1.crmf;

import cn.tca.TopBasicCrypto.asn1.ASN1Choice;
import cn.tca.TopBasicCrypto.asn1.ASN1Encodable;
import cn.tca.TopBasicCrypto.asn1.ASN1TaggedObject;
import cn.tca.TopBasicCrypto.asn1.DERBitString;
import cn.tca.TopBasicCrypto.asn1.DERInteger;
import cn.tca.TopBasicCrypto.asn1.DERObject;
import cn.tca.TopBasicCrypto.asn1.DERTaggedObject;
import cn.tca.TopBasicCrypto.asn1.cms.EnvelopedData;
import cn.tca.TopBasicCrypto.asn1.crmf.PKMACValue;
import cn.tca.TopBasicCrypto.asn1.crmf.SubsequentMessage;

public class POPOPrivKey
extends ASN1Encodable
implements ASN1Choice {
    public static final int thisMessage = 0;
    public static final int subsequentMessage = 1;
    public static final int dhMAC = 2;
    public static final int agreeMAC = 3;
    public static final int encryptedKey = 4;
    private int tagNo;
    private ASN1Encodable obj;

    private POPOPrivKey(ASN1TaggedObject obj) {
        this.tagNo = obj.getTagNo();
        switch (this.tagNo) {
            case 0: {
                this.obj = DERBitString.getInstance(obj, false);
                break;
            }
            case 1: {
                this.obj = SubsequentMessage.valueOf(DERInteger.getInstance(obj, false).getValue().intValue());
                break;
            }
            case 2: {
                this.obj = DERBitString.getInstance(obj, false);
                break;
            }
            case 3: {
                this.obj = PKMACValue.getInstance(obj, false);
                break;
            }
            case 4: {
                this.obj = EnvelopedData.getInstance(obj, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown tag in POPOPrivKey");
            }
        }
    }

    public static POPOPrivKey getInstance(ASN1TaggedObject tagged, boolean isExplicit) {
        return new POPOPrivKey(ASN1TaggedObject.getInstance(tagged.getObject()));
    }

    public POPOPrivKey(SubsequentMessage msg) {
        this.tagNo = 1;
        this.obj = msg;
    }

    public int getType() {
        return this.tagNo;
    }

    public ASN1Encodable getValue() {
        return this.obj;
    }

    public DERObject toASN1Object() {
        return new DERTaggedObject(false, this.tagNo, this.obj);
    }
}

