/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.cert;

import cn.tca.TopBasicCrypto.asn1.ASN1Encodable;
import cn.tca.TopBasicCrypto.asn1.DERSequence;
import cn.tca.TopBasicCrypto.asn1.x500.X500Name;
import cn.tca.TopBasicCrypto.asn1.x509.AttCertIssuer;
import cn.tca.TopBasicCrypto.asn1.x509.GeneralName;
import cn.tca.TopBasicCrypto.asn1.x509.GeneralNames;
import cn.tca.TopBasicCrypto.asn1.x509.V2Form;
import cn.tca.TopBasicCrypto.cert.X509CertificateHolder;
import cn.tca.TopBasicCrypto.util.Selector;
import java.util.ArrayList;

public class AttributeCertificateIssuer
implements Selector {
    final ASN1Encodable form;

    public AttributeCertificateIssuer(AttCertIssuer issuer) {
        this.form = issuer.getIssuer();
    }

    public AttributeCertificateIssuer(X500Name principal) {
        this.form = new V2Form(new GeneralNames(new DERSequence(new GeneralName(principal))));
    }

    public X500Name[] getNames() {
        GeneralNames name = this.form instanceof V2Form ? ((V2Form)this.form).getIssuerName() : (GeneralNames)this.form;
        GeneralName[] names = name.getNames();
        ArrayList<X500Name> l = new ArrayList<X500Name>(names.length);
        for (int i = 0; i != names.length; ++i) {
            if (names[i].getTagNo() != 4) continue;
            l.add(X500Name.getInstance(names[i].getName()));
        }
        return l.toArray(new X500Name[l.size()]);
    }

    private boolean matchesDN(X500Name subject, GeneralNames targets) {
        GeneralName[] names = targets.getNames();
        for (int i = 0; i != names.length; ++i) {
            GeneralName gn = names[i];
            if (gn.getTagNo() != 4 || !X500Name.getInstance(gn.getName()).equals(subject)) continue;
            return true;
        }
        return false;
    }

    public Object clone() {
        return new AttributeCertificateIssuer(AttCertIssuer.getInstance(this.form));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AttributeCertificateIssuer)) {
            return false;
        }
        AttributeCertificateIssuer other = (AttributeCertificateIssuer)obj;
        return this.form.equals(other.form);
    }

    public int hashCode() {
        return this.form.hashCode();
    }

    public boolean match(Object obj) {
        if (!(obj instanceof X509CertificateHolder)) {
            return false;
        }
        X509CertificateHolder x509Cert = (X509CertificateHolder)obj;
        if (this.form instanceof V2Form) {
            V2Form issuer = (V2Form)this.form;
            if (issuer.getBaseCertificateID() != null) {
                return issuer.getBaseCertificateID().getSerial().getValue().equals(x509Cert.getSerialNumber()) && this.matchesDN(x509Cert.getIssuer(), issuer.getBaseCertificateID().getIssuer());
            }
            GeneralNames name = issuer.getIssuerName();
            if (this.matchesDN(x509Cert.getSubject(), name)) {
                return true;
            }
        } else {
            GeneralNames name = (GeneralNames)this.form;
            if (this.matchesDN(x509Cert.getSubject(), name)) {
                return true;
            }
        }
        return false;
    }
}

