/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.cert.ocsp;

import cn.tca.TopBasicCrypto.asn1.ASN1Sequence;
import cn.tca.TopBasicCrypto.asn1.ocsp.ResponseData;
import cn.tca.TopBasicCrypto.asn1.ocsp.SingleResponse;
import cn.tca.TopBasicCrypto.asn1.x509.X509Extensions;
import cn.tca.TopBasicCrypto.cert.ocsp.OCSPUtils;
import cn.tca.TopBasicCrypto.cert.ocsp.RespID;
import cn.tca.TopBasicCrypto.cert.ocsp.SingleResp;
import java.util.Date;

public class RespData {
    private ResponseData data;

    public RespData(ResponseData data) {
        this.data = data;
    }

    public int getVersion() {
        return this.data.getVersion().getValue().intValue() + 1;
    }

    public RespID getResponderId() {
        return new RespID(this.data.getResponderID());
    }

    public Date getProducedAt() {
        return OCSPUtils.extractDate(this.data.getProducedAt());
    }

    public SingleResp[] getResponses() {
        ASN1Sequence s = this.data.getResponses();
        SingleResp[] rs = new SingleResp[s.size()];
        for (int i = 0; i != rs.length; ++i) {
            rs[i] = new SingleResp(SingleResponse.getInstance(s.getObjectAt(i)));
        }
        return rs;
    }

    public X509Extensions getResponseExtensions() {
        return this.data.getResponseExtensions();
    }
}

