/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.cms;

import cn.tca.TopBasicCrypto.asn1.ASN1OctetString;
import cn.tca.TopBasicCrypto.asn1.ASN1Set;
import cn.tca.TopBasicCrypto.asn1.DEREncodable;
import cn.tca.TopBasicCrypto.asn1.cms.AttributeTable;
import cn.tca.TopBasicCrypto.asn1.cms.AuthenticatedData;
import cn.tca.TopBasicCrypto.asn1.cms.CMSAttributes;
import cn.tca.TopBasicCrypto.asn1.cms.ContentInfo;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.cms.AuthAttributesProvider;
import cn.tca.TopBasicCrypto.cms.CMSEnvelopedHelper;
import cn.tca.TopBasicCrypto.cms.CMSException;
import cn.tca.TopBasicCrypto.cms.CMSProcessableByteArray;
import cn.tca.TopBasicCrypto.cms.CMSUtils;
import cn.tca.TopBasicCrypto.cms.RecipientInformationStore;
import cn.tca.TopBasicCrypto.operator.DigestCalculatorProvider;
import cn.tca.TopBasicCrypto.operator.OperatorCreationException;
import cn.tca.TopBasicCrypto.util.Arrays;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.NoSuchProviderException;
import java.security.Provider;

public class CMSAuthenticatedData {
    RecipientInformationStore recipientInfoStore;
    ContentInfo contentInfo;
    private AlgorithmIdentifier macAlg;
    private ASN1Set authAttrs;
    private ASN1Set unauthAttrs;
    private byte[] mac;

    public CMSAuthenticatedData(byte[] authData) throws CMSException {
        this(CMSUtils.readContentInfo(authData));
    }

    public CMSAuthenticatedData(byte[] authData, DigestCalculatorProvider digestCalculatorProvider) throws CMSException {
        this(CMSUtils.readContentInfo(authData), digestCalculatorProvider);
    }

    public CMSAuthenticatedData(InputStream authData) throws CMSException {
        this(CMSUtils.readContentInfo(authData));
    }

    public CMSAuthenticatedData(InputStream authData, DigestCalculatorProvider digestCalculatorProvider) throws CMSException {
        this(CMSUtils.readContentInfo(authData), digestCalculatorProvider);
    }

    public CMSAuthenticatedData(ContentInfo contentInfo) throws CMSException {
        this(contentInfo, null);
    }

    public CMSAuthenticatedData(ContentInfo contentInfo, DigestCalculatorProvider digestCalculatorProvider) throws CMSException {
        this.contentInfo = contentInfo;
        AuthenticatedData authData = AuthenticatedData.getInstance(contentInfo.getContent());
        ASN1Set recipientInfos = authData.getRecipientInfos();
        this.macAlg = authData.getMacAlgorithm();
        this.authAttrs = authData.getAuthAttrs();
        this.mac = authData.getMac().getOctets();
        this.unauthAttrs = authData.getUnauthAttrs();
        ContentInfo encInfo = authData.getEncapsulatedContentInfo();
        CMSProcessableByteArray readable = new CMSProcessableByteArray(ASN1OctetString.getInstance(encInfo.getContent()).getOctets());
        if (this.authAttrs != null) {
            if (digestCalculatorProvider == null) {
                throw new CMSException("a digest calculator provider is required if authenticated attributes are present");
            }
            try {
                CMSEnvelopedHelper.CMSDigestAuthenticatedSecureReadable secureReadable = new CMSEnvelopedHelper.CMSDigestAuthenticatedSecureReadable(digestCalculatorProvider.get(authData.getDigestAlgorithm()), readable);
                this.recipientInfoStore = CMSEnvelopedHelper.buildRecipientInformationStore(recipientInfos, this.macAlg, secureReadable, new AuthAttributesProvider(){

                    public ASN1Set getAuthAttributes() {
                        return CMSAuthenticatedData.this.authAttrs;
                    }
                });
            }
            catch (OperatorCreationException e) {
                throw new CMSException("unable to create digest calculator: " + e.getMessage(), e);
            }
        } else {
            CMSEnvelopedHelper.CMSAuthenticatedSecureReadable secureReadable = new CMSEnvelopedHelper.CMSAuthenticatedSecureReadable(this.macAlg, readable);
            this.recipientInfoStore = CMSEnvelopedHelper.buildRecipientInformationStore(recipientInfos, this.macAlg, secureReadable);
        }
    }

    public byte[] getMac() {
        return Arrays.clone(this.mac);
    }

    private byte[] encodeObj(DEREncodable obj) throws IOException {
        if (obj != null) {
            return obj.getDERObject().getEncoded();
        }
        return null;
    }

    public String getMacAlgOID() {
        return this.macAlg.getObjectId().getId();
    }

    public byte[] getMacAlgParams() {
        try {
            return this.encodeObj(this.macAlg.getParameters());
        }
        catch (Exception e) {
            throw new RuntimeException("exception getting encryption parameters " + e);
        }
    }

    public AlgorithmParameters getMacAlgorithmParameters(String provider) throws CMSException, NoSuchProviderException {
        return this.getMacAlgorithmParameters(CMSUtils.getProvider(provider));
    }

    public AlgorithmParameters getMacAlgorithmParameters(Provider provider) throws CMSException {
        return CMSEnvelopedHelper.INSTANCE.getEncryptionAlgorithmParameters(this.getMacAlgOID(), this.getMacAlgParams(), provider);
    }

    public RecipientInformationStore getRecipientInfos() {
        return this.recipientInfoStore;
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public AttributeTable getAuthAttrs() {
        if (this.authAttrs == null) {
            return null;
        }
        return new AttributeTable(this.authAttrs);
    }

    public AttributeTable getUnauthAttrs() {
        if (this.unauthAttrs == null) {
            return null;
        }
        return new AttributeTable(this.unauthAttrs);
    }

    public byte[] getEncoded() throws IOException {
        return this.contentInfo.getEncoded();
    }

    public byte[] getContentDigest() {
        if (this.authAttrs != null) {
            return ASN1OctetString.getInstance(this.getAuthAttrs().get(CMSAttributes.messageDigest).getAttrValues().getObjectAt(0)).getOctets();
        }
        return null;
    }
}

