/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.cms;

import cn.tca.TopBasicCrypto.asn1.ASN1EncodableVector;
import cn.tca.TopBasicCrypto.asn1.DERObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.DEROctetString;
import cn.tca.TopBasicCrypto.asn1.DERSequence;
import cn.tca.TopBasicCrypto.asn1.cms.PasswordRecipientInfo;
import cn.tca.TopBasicCrypto.asn1.cms.RecipientInfo;
import cn.tca.TopBasicCrypto.asn1.pkcs.PKCSObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.cms.CMSEnvelopedHelper;
import cn.tca.TopBasicCrypto.cms.IntRecipientInfoGenerator;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

class PasswordIntRecipientInfoGenerator
implements IntRecipientInfoGenerator {
    private AlgorithmIdentifier keyDerivationAlgorithm;
    private SecretKey keyEncryptionKey;

    PasswordIntRecipientInfoGenerator() {
    }

    void setKeyDerivationAlgorithm(AlgorithmIdentifier keyDerivationAlgorithm) {
        this.keyDerivationAlgorithm = keyDerivationAlgorithm;
    }

    void setKeyEncryptionKey(SecretKey keyEncryptionKey) {
        this.keyEncryptionKey = keyEncryptionKey;
    }

    public RecipientInfo generate(SecretKey contentEncryptionKey, SecureRandom random, Provider prov) throws GeneralSecurityException {
        CMSEnvelopedHelper helper = CMSEnvelopedHelper.INSTANCE;
        String wrapAlgName = helper.getRFC3211WrapperName(this.keyEncryptionKey.getAlgorithm());
        Cipher keyCipher = helper.createSymmetricCipher(wrapAlgName, prov);
        keyCipher.init(3, (Key)this.keyEncryptionKey, random);
        byte[] encryptedKeyBytes = keyCipher.wrap(contentEncryptionKey);
        DEROctetString encryptedKey = new DEROctetString(encryptedKeyBytes);
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new DERObjectIdentifier(this.keyEncryptionKey.getAlgorithm()));
        v.add(new DEROctetString(keyCipher.getIV()));
        AlgorithmIdentifier keyEncryptionAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_PWRI_KEK, new DERSequence(v));
        return new RecipientInfo(new PasswordRecipientInfo(this.keyDerivationAlgorithm, keyEncryptionAlgorithm, encryptedKey));
    }
}

