/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.cms;

import cn.tca.TopBasicCrypto.asn1.ASN1OctetString;
import cn.tca.TopBasicCrypto.asn1.DEROctetString;
import cn.tca.TopBasicCrypto.asn1.cms.IssuerAndSerialNumber;
import cn.tca.TopBasicCrypto.asn1.x500.X500Name;
import cn.tca.TopBasicCrypto.asn1.x509.X509Extension;
import cn.tca.TopBasicCrypto.cert.X509CertificateHolder;
import cn.tca.TopBasicCrypto.cms.SignerInformation;
import cn.tca.TopBasicCrypto.crypto.digests.SHA1Digest;
import cn.tca.TopBasicCrypto.util.Arrays;
import cn.tca.TopBasicCrypto.util.Selector;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.X509CertSelector;

public class SignerId
extends X509CertSelector
implements Selector {
    private byte[] subjectKeyId;
    private X500Name issuer;
    private BigInteger serialNumber;

    public SignerId() {
    }

    public SignerId(byte[] subjectKeyId) {
        super.setSubjectKeyIdentifier(new DEROctetString(subjectKeyId).getDEREncoded());
        this.subjectKeyId = subjectKeyId;
    }

    public SignerId(X500Name issuer, BigInteger serialNumber) {
        this.issuer = issuer;
        this.serialNumber = serialNumber;
        try {
            this.setIssuer(issuer.getDEREncoded());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid issuer: " + e.getMessage());
        }
        this.setSerialNumber(serialNumber);
    }

    public int hashCode() {
        int code = Arrays.hashCode(this.subjectKeyId);
        if (this.serialNumber != null) {
            code ^= this.serialNumber.hashCode();
        }
        if (this.issuer != null) {
            code ^= this.issuer.hashCode();
        }
        return code;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SignerId)) {
            return false;
        }
        SignerId id = (SignerId)o;
        return Arrays.areEqual(this.subjectKeyId, id.subjectKeyId) && this.equalsObj(this.serialNumber, id.serialNumber) && this.equalsObj(this.issuer, id.issuer);
    }

    private boolean equalsObj(Object a, Object b) {
        return a != null ? a.equals(b) : b == null;
    }

    public boolean match(Object obj) {
        if (obj instanceof X509CertificateHolder) {
            X509CertificateHolder certHldr = (X509CertificateHolder)obj;
            if (this.getSerialNumber() != null) {
                IssuerAndSerialNumber iAndS = certHldr.getIssuerAndSerialNumber();
                return iAndS.getName().equals(this.issuer) && iAndS.getSerialNumber().getValue().equals(this.serialNumber);
            }
            if (this.getSubjectKeyIdentifier() != null) {
                X509Extension ext = certHldr.getExtension(X509Extension.subjectKeyIdentifier);
                if (ext == null) {
                    SHA1Digest dig = new SHA1Digest();
                    byte[] hash = new byte[dig.getDigestSize()];
                    byte[] spkiEnc = certHldr.getSubjectPublicKeyInfo().getDEREncoded();
                    dig.update(spkiEnc, 0, spkiEnc.length);
                    dig.doFinal(hash, 0);
                    return Arrays.areEqual(this.subjectKeyId, hash);
                }
                byte[] subKeyID = ASN1OctetString.getInstance(ext.getParsedValue()).getOctets();
                return Arrays.areEqual(this.subjectKeyId, subKeyID);
            }
        } else {
            if (obj instanceof byte[]) {
                return Arrays.areEqual(this.subjectKeyId, (byte[])obj);
            }
            if (obj instanceof SignerInformation) {
                return ((SignerInformation)obj).getSID().equals(this);
            }
        }
        return false;
    }
}

