/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.crypto.agreement;

import cn.tca.TopBasicCrypto.crypto.BasicAgreement;
import cn.tca.TopBasicCrypto.crypto.CipherParameters;
import cn.tca.TopBasicCrypto.crypto.params.ECDomainParameters;
import cn.tca.TopBasicCrypto.crypto.params.ECPrivateKeyParameters;
import cn.tca.TopBasicCrypto.crypto.params.ECPublicKeyParameters;
import cn.tca.TopBasicCrypto.crypto.params.MQVPrivateParameters;
import cn.tca.TopBasicCrypto.crypto.params.MQVPublicParameters;
import cn.tca.TopBasicCrypto.math.ec.ECAlgorithms;
import cn.tca.TopBasicCrypto.math.ec.ECConstants;
import cn.tca.TopBasicCrypto.math.ec.ECPoint;
import java.math.BigInteger;

public class ECMQVBasicAgreement
implements BasicAgreement {
    MQVPrivateParameters privParams;

    public void init(CipherParameters key) {
        this.privParams = (MQVPrivateParameters)key;
    }

    public BigInteger calculateAgreement(CipherParameters pubKey) {
        MQVPublicParameters pubParams = (MQVPublicParameters)pubKey;
        ECPrivateKeyParameters staticPrivateKey = this.privParams.getStaticPrivateKey();
        ECPoint agreement = this.calculateMqvAgreement(staticPrivateKey.getParameters(), staticPrivateKey, this.privParams.getEphemeralPrivateKey(), this.privParams.getEphemeralPublicKey(), pubParams.getStaticPublicKey(), pubParams.getEphemeralPublicKey());
        return agreement.getX().toBigInteger();
    }

    private ECPoint calculateMqvAgreement(ECDomainParameters parameters, ECPrivateKeyParameters d1U, ECPrivateKeyParameters d2U, ECPublicKeyParameters Q2U, ECPublicKeyParameters Q1V, ECPublicKeyParameters Q2V) {
        BigInteger n = parameters.getN();
        int e = (n.bitLength() + 1) / 2;
        BigInteger powE = ECConstants.ONE.shiftLeft(e);
        ECPoint q = Q2U == null ? parameters.getG().multiply(d2U.getD()) : Q2U.getQ();
        BigInteger x = q.getX().toBigInteger();
        BigInteger xBar = x.mod(powE);
        BigInteger Q2UBar = xBar.setBit(e);
        BigInteger s = d1U.getD().multiply(Q2UBar).mod(n).add(d2U.getD()).mod(n);
        BigInteger xPrime = Q2V.getQ().getX().toBigInteger();
        BigInteger xPrimeBar = xPrime.mod(powE);
        BigInteger Q2VBar = xPrimeBar.setBit(e);
        BigInteger hs = parameters.getH().multiply(s).mod(n);
        ECPoint p = ECAlgorithms.sumOfTwoMultiplies(Q1V.getQ(), Q2VBar.multiply(hs).mod(n), Q2V.getQ(), hs);
        if (p.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for MQV");
        }
        return p;
    }
}

