/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.crypto.generators;

import cn.tca.TopBasicCrypto.crypto.AsymmetricCipherKeyPair;
import cn.tca.TopBasicCrypto.crypto.AsymmetricCipherKeyPairGenerator;
import cn.tca.TopBasicCrypto.crypto.KeyGenerationParameters;
import cn.tca.TopBasicCrypto.crypto.generators.DHKeyGeneratorHelper;
import cn.tca.TopBasicCrypto.crypto.params.DHKeyGenerationParameters;
import cn.tca.TopBasicCrypto.crypto.params.DHParameters;
import cn.tca.TopBasicCrypto.crypto.params.DHPrivateKeyParameters;
import cn.tca.TopBasicCrypto.crypto.params.DHPublicKeyParameters;
import java.math.BigInteger;

public class DHBasicKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    public void init(KeyGenerationParameters param) {
        this.param = (DHKeyGenerationParameters)param;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
        DHParameters dhp = this.param.getParameters();
        BigInteger x = helper.calculatePrivate(dhp, this.param.getRandom());
        BigInteger y = helper.calculatePublic(dhp, x);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(y, dhp), new DHPrivateKeyParameters(x, dhp));
    }
}

