/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.crypto.generators;

import cn.tca.TopBasicCrypto.crypto.AsymmetricCipherKeyPair;
import cn.tca.TopBasicCrypto.crypto.AsymmetricCipherKeyPairGenerator;
import cn.tca.TopBasicCrypto.crypto.KeyGenerationParameters;
import cn.tca.TopBasicCrypto.crypto.generators.DHKeyGeneratorHelper;
import cn.tca.TopBasicCrypto.crypto.params.DHParameters;
import cn.tca.TopBasicCrypto.crypto.params.ElGamalKeyGenerationParameters;
import cn.tca.TopBasicCrypto.crypto.params.ElGamalParameters;
import cn.tca.TopBasicCrypto.crypto.params.ElGamalPrivateKeyParameters;
import cn.tca.TopBasicCrypto.crypto.params.ElGamalPublicKeyParameters;
import java.math.BigInteger;

public class ElGamalKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private ElGamalKeyGenerationParameters param;

    public void init(KeyGenerationParameters param) {
        this.param = (ElGamalKeyGenerationParameters)param;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
        ElGamalParameters egp = this.param.getParameters();
        DHParameters dhp = new DHParameters(egp.getP(), egp.getG(), null, egp.getL());
        BigInteger x = helper.calculatePrivate(dhp, this.param.getRandom());
        BigInteger y = helper.calculatePublic(dhp, x);
        return new AsymmetricCipherKeyPair(new ElGamalPublicKeyParameters(y, egp), new ElGamalPrivateKeyParameters(x, egp));
    }
}

