/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.jce;

import cn.tca.TopBasicCrypto.asn1.DERObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.nist.NISTNamedCurves;
import cn.tca.TopBasicCrypto.asn1.sec.SECNamedCurves;
import cn.tca.TopBasicCrypto.asn1.teletrust.TeleTrusTNamedCurves;
import cn.tca.TopBasicCrypto.asn1.x9.X962NamedCurves;
import cn.tca.TopBasicCrypto.asn1.x9.X9ECParameters;
import cn.tca.TopBasicCrypto.jce.spec.ECNamedCurveParameterSpec;
import java.util.Enumeration;
import java.util.Vector;

public class ECNamedCurveTable {
    public static ECNamedCurveParameterSpec getParameterSpec(String name) {
        X9ECParameters ecP = X962NamedCurves.getByName(name);
        if (ecP == null) {
            try {
                ecP = X962NamedCurves.getByOID(new DERObjectIdentifier(name));
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if (ecP == null && (ecP = SECNamedCurves.getByName(name)) == null) {
            try {
                ecP = SECNamedCurves.getByOID(new DERObjectIdentifier(name));
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if (ecP == null && (ecP = TeleTrusTNamedCurves.getByName(name)) == null) {
            try {
                ecP = TeleTrusTNamedCurves.getByOID(new DERObjectIdentifier(name));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (ecP == null) {
            ecP = NISTNamedCurves.getByName(name);
        }
        if (ecP == null) {
            return null;
        }
        return new ECNamedCurveParameterSpec(name, ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
    }

    public static Enumeration getNames() {
        Vector v = new Vector();
        ECNamedCurveTable.addEnumeration(v, X962NamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(v, SECNamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(v, NISTNamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(v, TeleTrusTNamedCurves.getNames());
        return v.elements();
    }

    private static void addEnumeration(Vector v, Enumeration e) {
        while (e.hasMoreElements()) {
            v.addElement(e.nextElement());
        }
    }
}

