/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.jce.provider;

import cn.tca.TopBasicCrypto.jce.exception.ExtCertPathValidatorException;
import cn.tca.TopBasicCrypto.jce.provider.AnnotatedException;
import cn.tca.TopBasicCrypto.jce.provider.CertPathValidatorUtilities;
import cn.tca.TopBasicCrypto.jce.provider.RFC3281CertPathUtilities;
import cn.tca.TopBasicCrypto.util.Selector;
import cn.tca.TopBasicCrypto.x509.ExtendedPKIXParameters;
import cn.tca.TopBasicCrypto.x509.X509AttributeCertStoreSelector;
import cn.tca.TopBasicCrypto.x509.X509AttributeCertificate;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.X509Certificate;
import java.util.Date;

public class PKIXAttrCertPathValidatorSpi
extends CertPathValidatorSpi {
    public CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters params) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        if (!(params instanceof ExtendedPKIXParameters)) {
            throw new InvalidAlgorithmParameterException("Parameters must be a " + ExtendedPKIXParameters.class.getName() + " instance.");
        }
        ExtendedPKIXParameters pkixParams = (ExtendedPKIXParameters)params;
        Selector certSelect = pkixParams.getTargetConstraints();
        if (!(certSelect instanceof X509AttributeCertStoreSelector)) {
            throw new InvalidAlgorithmParameterException("TargetConstraints must be an instance of " + X509AttributeCertStoreSelector.class.getName() + " for " + this.getClass().getName() + " class.");
        }
        X509AttributeCertificate attrCert = ((X509AttributeCertStoreSelector)certSelect).getAttributeCert();
        CertPath holderCertPath = RFC3281CertPathUtilities.processAttrCert1(attrCert, pkixParams);
        CertPathValidatorResult result = RFC3281CertPathUtilities.processAttrCert2(certPath, pkixParams);
        X509Certificate issuerCert = (X509Certificate)certPath.getCertificates().get(0);
        RFC3281CertPathUtilities.processAttrCert3(issuerCert, pkixParams);
        RFC3281CertPathUtilities.processAttrCert4(issuerCert, pkixParams);
        RFC3281CertPathUtilities.processAttrCert5(attrCert, pkixParams);
        RFC3281CertPathUtilities.processAttrCert7(attrCert, certPath, holderCertPath, pkixParams);
        RFC3281CertPathUtilities.additionalChecks(attrCert, pkixParams);
        Date date = null;
        try {
            date = CertPathValidatorUtilities.getValidCertDateFromValidityModel(pkixParams, null, -1);
        }
        catch (AnnotatedException e) {
            throw new ExtCertPathValidatorException("Could not get validity date from attribute certificate.", e);
        }
        RFC3281CertPathUtilities.checkCRLs(attrCert, pkixParams, issuerCert, date, certPath.getCertificates());
        return result;
    }
}

