/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.jce.provider.asymmetric.ec;

import cn.tca.TopBasicCrypto.jce.provider.JCEECPrivateKey;
import cn.tca.TopBasicCrypto.jce.provider.JCEECPublicKey;
import cn.tca.TopBasicCrypto.jce.provider.JDKKeyFactory;
import cn.tca.TopBasicCrypto.jce.provider.ProviderUtil;
import cn.tca.TopBasicCrypto.jce.provider.asymmetric.ec.EC5Util;
import cn.tca.TopBasicCrypto.jce.spec.ECParameterSpec;
import cn.tca.TopBasicCrypto.jce.spec.ECPrivateKeySpec;
import cn.tca.TopBasicCrypto.jce.spec.ECPublicKeySpec;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class KeyFactory
extends JDKKeyFactory {
    String algorithm;

    KeyFactory(String algorithm) {
        this.algorithm = algorithm;
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof ECPublicKey) {
            return new JCEECPublicKey((ECPublicKey)key);
        }
        if (key instanceof ECPrivateKey) {
            return new JCEECPrivateKey((ECPrivateKey)key);
        }
        throw new InvalidKeyException("key type unknown");
    }

    protected KeySpec engineGetKeySpec(Key key, Class spec) throws InvalidKeySpecException {
        if (spec.isAssignableFrom(PKCS8EncodedKeySpec.class) && key.getFormat().equals("PKCS#8")) {
            return new PKCS8EncodedKeySpec(key.getEncoded());
        }
        if (spec.isAssignableFrom(X509EncodedKeySpec.class) && key.getFormat().equals("X.509")) {
            return new X509EncodedKeySpec(key.getEncoded());
        }
        if (spec.isAssignableFrom(java.security.spec.ECPublicKeySpec.class) && key instanceof ECPublicKey) {
            ECPublicKey k = (ECPublicKey)key;
            if (k.getParams() != null) {
                return new java.security.spec.ECPublicKeySpec(k.getW(), k.getParams());
            }
            ECParameterSpec implicitSpec = ProviderUtil.getEcImplicitlyCa();
            return new java.security.spec.ECPublicKeySpec(k.getW(), EC5Util.convertSpec(EC5Util.convertCurve(implicitSpec.getCurve(), implicitSpec.getSeed()), implicitSpec));
        }
        if (spec.isAssignableFrom(java.security.spec.ECPrivateKeySpec.class) && key instanceof ECPrivateKey) {
            ECPrivateKey k = (ECPrivateKey)key;
            if (k.getParams() != null) {
                return new java.security.spec.ECPrivateKeySpec(k.getS(), k.getParams());
            }
            ECParameterSpec implicitSpec = ProviderUtil.getEcImplicitlyCa();
            return new java.security.spec.ECPrivateKeySpec(k.getS(), EC5Util.convertSpec(EC5Util.convertCurve(implicitSpec.getCurve(), implicitSpec.getSeed()), implicitSpec));
        }
        throw new RuntimeException("not implemented yet " + key + " " + spec);
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                JCEECPrivateKey key = (JCEECPrivateKey)JDKKeyFactory.createPrivateKeyFromDERStream(((PKCS8EncodedKeySpec)keySpec).getEncoded());
                return new JCEECPrivateKey(this.algorithm, key);
            }
            catch (Exception e) {
                throw new InvalidKeySpecException(e.toString());
            }
        }
        if (keySpec instanceof ECPrivateKeySpec) {
            return new JCEECPrivateKey(this.algorithm, (ECPrivateKeySpec)keySpec);
        }
        if (keySpec instanceof java.security.spec.ECPrivateKeySpec) {
            return new JCEECPrivateKey(this.algorithm, (java.security.spec.ECPrivateKeySpec)keySpec);
        }
        throw new InvalidKeySpecException("Unknown KeySpec type: " + keySpec.getClass().getName());
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof X509EncodedKeySpec) {
            try {
                JCEECPublicKey key = (JCEECPublicKey)JDKKeyFactory.createPublicKeyFromDERStream(((X509EncodedKeySpec)keySpec).getEncoded());
                return new JCEECPublicKey(this.algorithm, key);
            }
            catch (Exception e) {
                throw new InvalidKeySpecException(e.toString());
            }
        }
        if (keySpec instanceof ECPublicKeySpec) {
            return new JCEECPublicKey(this.algorithm, (ECPublicKeySpec)keySpec);
        }
        if (keySpec instanceof java.security.spec.ECPublicKeySpec) {
            return new JCEECPublicKey(this.algorithm, (java.security.spec.ECPublicKeySpec)keySpec);
        }
        throw new InvalidKeySpecException("Unknown KeySpec type: " + keySpec.getClass().getName());
    }

    public static class ECMQV
    extends KeyFactory {
        public ECMQV() {
            super("ECMQV");
        }
    }

    public static class ECDHC
    extends KeyFactory {
        public ECDHC() {
            super("ECDHC");
        }
    }

    public static class ECDH
    extends KeyFactory {
        public ECDH() {
            super("ECDH");
        }
    }

    public static class ECGOST3410
    extends KeyFactory {
        public ECGOST3410() {
            super("ECGOST3410");
        }
    }

    public static class ECDSA
    extends KeyFactory {
        public ECDSA() {
            super("ECDSA");
        }
    }

    public static class EC
    extends KeyFactory {
        public EC() {
            super("EC");
        }
    }
}

