/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.openpgp;

import cn.tca.TopBasicCrypto.bcpg.BCPGOutputStream;
import cn.tca.TopBasicCrypto.bcpg.ContainedPacket;
import cn.tca.TopBasicCrypto.bcpg.PublicKeyEncSessionPacket;
import cn.tca.TopBasicCrypto.bcpg.S2K;
import cn.tca.TopBasicCrypto.bcpg.SymmetricKeyAlgorithmTags;
import cn.tca.TopBasicCrypto.bcpg.SymmetricKeyEncSessionPacket;
import cn.tca.TopBasicCrypto.openpgp.PGPException;
import cn.tca.TopBasicCrypto.openpgp.PGPPublicKey;
import cn.tca.TopBasicCrypto.openpgp.PGPUtil;
import cn.tca.TopBasicCrypto.openpgp.StreamGenerator;
import cn.tca.TopBasicCrypto.openpgp.WrappedGeneratorStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.DigestOutputStream;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;

public class PGPEncryptedDataGenerator
implements SymmetricKeyAlgorithmTags,
StreamGenerator {
    public static final int S2K_SHA1 = 2;
    public static final int S2K_SHA224 = 11;
    public static final int S2K_SHA256 = 8;
    public static final int S2K_SHA384 = 9;
    public static final int S2K_SHA512 = 10;
    private BCPGOutputStream pOut;
    private CipherOutputStream cOut;
    private Cipher c;
    private boolean withIntegrityPacket = false;
    private boolean oldFormat = false;
    private DigestOutputStream digestOut;
    private List methods = new ArrayList();
    private int defAlgorithm;
    private SecureRandom rand;
    private Provider defProvider;

    public PGPEncryptedDataGenerator(int encAlgorithm, SecureRandom rand, String provider) {
        this(encAlgorithm, rand, Security.getProvider(provider));
    }

    public PGPEncryptedDataGenerator(int encAlgorithm, SecureRandom rand, Provider provider) {
        this.defAlgorithm = encAlgorithm;
        this.rand = rand;
        this.defProvider = provider;
    }

    public PGPEncryptedDataGenerator(int encAlgorithm, boolean withIntegrityPacket, SecureRandom rand, String provider) {
        this(encAlgorithm, withIntegrityPacket, rand, Security.getProvider(provider));
    }

    public PGPEncryptedDataGenerator(int encAlgorithm, boolean withIntegrityPacket, SecureRandom rand, Provider provider) {
        this.defAlgorithm = encAlgorithm;
        this.rand = rand;
        this.defProvider = provider;
        this.withIntegrityPacket = withIntegrityPacket;
    }

    public PGPEncryptedDataGenerator(int encAlgorithm, SecureRandom rand, boolean oldFormat, String provider) {
        this.defAlgorithm = encAlgorithm;
        this.rand = rand;
        this.defProvider = Security.getProvider(provider);
        this.oldFormat = oldFormat;
    }

    public PGPEncryptedDataGenerator(int encAlgorithm, SecureRandom rand, boolean oldFormat, Provider provider) {
        this.defAlgorithm = encAlgorithm;
        this.rand = rand;
        this.defProvider = provider;
        this.oldFormat = oldFormat;
    }

    public void addMethod(char[] passPhrase) throws NoSuchProviderException, PGPException {
        this.addMethod(passPhrase, 2);
    }

    public void addMethod(char[] passPhrase, int s2kDigest) throws NoSuchProviderException, PGPException {
        if (this.defProvider == null) {
            throw new NoSuchProviderException("unable to find provider.");
        }
        byte[] iv = new byte[8];
        this.rand.nextBytes(iv);
        S2K s2k = new S2K(s2kDigest, iv, 96);
        this.methods.add(new PBEMethod(this.defAlgorithm, s2k, PGPUtil.makeKeyFromPassPhrase(this.defAlgorithm, s2k, passPhrase, this.defProvider)));
    }

    public void addMethod(PGPPublicKey key) throws NoSuchProviderException, PGPException {
        if (!key.isEncryptionKey()) {
            throw new IllegalArgumentException("passed in key not an encryption key!");
        }
        if (this.defProvider == null) {
            throw new NoSuchProviderException("unable to find provider.");
        }
        this.methods.add(new PubMethod(key));
    }

    private void addCheckSum(byte[] sessionInfo) {
        int check = 0;
        for (int i = 1; i != sessionInfo.length - 2; ++i) {
            check += sessionInfo[i] & 0xFF;
        }
        sessionInfo[sessionInfo.length - 2] = (byte)(check >> 8);
        sessionInfo[sessionInfo.length - 1] = (byte)check;
    }

    private byte[] createSessionInfo(int algorithm, Key key) {
        byte[] keyBytes = key.getEncoded();
        byte[] sessionInfo = new byte[keyBytes.length + 3];
        sessionInfo[0] = (byte)algorithm;
        System.arraycopy(keyBytes, 0, sessionInfo, 1, keyBytes.length);
        this.addCheckSum(sessionInfo);
        return sessionInfo;
    }

    private OutputStream open(OutputStream out, long length, byte[] buffer) throws IOException, PGPException, IllegalStateException {
        byte[] sessionInfo;
        if (this.cOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        if (this.methods.size() == 0) {
            throw new IllegalStateException("no encryption methods specified");
        }
        if (this.defProvider == null) {
            throw new IllegalStateException("provider resolves to null");
        }
        Key key = null;
        this.pOut = new BCPGOutputStream(out);
        if (this.methods.size() == 1) {
            if (this.methods.get(0) instanceof PBEMethod) {
                PBEMethod m = (PBEMethod)this.methods.get(0);
                key = m.getKey();
            } else {
                key = PGPUtil.makeRandomKey(this.defAlgorithm, this.rand);
                sessionInfo = this.createSessionInfo(this.defAlgorithm, key);
                PubMethod m = (PubMethod)this.methods.get(0);
                try {
                    m.addSessionInfo(sessionInfo);
                }
                catch (Exception e) {
                    throw new PGPException("exception encrypting session key", e);
                }
            }
            this.pOut.writePacket((ContainedPacket)this.methods.get(0));
        } else {
            key = PGPUtil.makeRandomKey(this.defAlgorithm, this.rand);
            sessionInfo = this.createSessionInfo(this.defAlgorithm, key);
            for (int i = 0; i != this.methods.size(); ++i) {
                EncMethod m = (EncMethod)this.methods.get(i);
                try {
                    m.addSessionInfo(sessionInfo);
                }
                catch (Exception e) {
                    throw new PGPException("exception encrypting session key", e);
                }
                this.pOut.writePacket(m);
            }
        }
        String cName = PGPUtil.getSymmetricCipherName(this.defAlgorithm);
        if (cName == null) {
            throw new PGPException("null cipher specified");
        }
        try {
            this.c = this.withIntegrityPacket ? Cipher.getInstance(cName + "/CFB/NoPadding", this.defProvider) : Cipher.getInstance(cName + "/OpenPGPCFB/NoPadding", this.defProvider);
            byte[] iv = new byte[this.c.getBlockSize()];
            this.c.init(1, key, new IvParameterSpec(iv), this.rand);
            if (buffer == null) {
                if (this.withIntegrityPacket) {
                    this.pOut = new BCPGOutputStream(out, 18, length + (long)this.c.getBlockSize() + 2L + 1L + 22L);
                    this.pOut.write(1);
                } else {
                    this.pOut = new BCPGOutputStream(out, 9, length + (long)this.c.getBlockSize() + 2L, this.oldFormat);
                }
            } else if (this.withIntegrityPacket) {
                this.pOut = new BCPGOutputStream(out, 18, buffer);
                this.pOut.write(1);
            } else {
                this.pOut = new BCPGOutputStream(out, 9, buffer);
            }
            this.cOut = new CipherOutputStream(this.pOut, this.c);
            FilterOutputStream genOut = this.cOut;
            if (this.withIntegrityPacket) {
                String digestName = PGPUtil.getDigestName(2);
                MessageDigest digest = MessageDigest.getInstance(digestName, this.defProvider);
                this.digestOut = new DigestOutputStream(this.cOut, digest);
                genOut = this.digestOut;
            }
            byte[] inLineIv = new byte[this.c.getBlockSize() + 2];
            this.rand.nextBytes(inLineIv);
            inLineIv[inLineIv.length - 1] = inLineIv[inLineIv.length - 3];
            inLineIv[inLineIv.length - 2] = inLineIv[inLineIv.length - 4];
            ((OutputStream)genOut).write(inLineIv);
            return new WrappedGeneratorStream(genOut, this);
        }
        catch (Exception e) {
            throw new PGPException("Exception creating cipher", e);
        }
    }

    public OutputStream open(OutputStream out, long length) throws IOException, PGPException {
        return this.open(out, length, null);
    }

    public OutputStream open(OutputStream out, byte[] buffer) throws IOException, PGPException {
        return this.open(out, 0L, buffer);
    }

    public void close() throws IOException {
        if (this.cOut != null) {
            if (this.digestOut != null) {
                BCPGOutputStream bOut = new BCPGOutputStream((OutputStream)this.digestOut, 19, 20L);
                bOut.flush();
                this.digestOut.flush();
                byte[] dig = this.digestOut.getMessageDigest().digest();
                this.cOut.write(dig);
            }
            this.cOut.flush();
            try {
                this.pOut.write(this.c.doFinal());
                this.pOut.finish();
            }
            catch (Exception e) {
                throw new IOException(e.toString());
            }
            this.cOut = null;
            this.pOut = null;
        }
    }

    private class PubMethod
    extends EncMethod {
        PGPPublicKey pubKey;
        BigInteger[] data;

        PubMethod(PGPPublicKey pubKey) {
            this.pubKey = pubKey;
        }

        public void addSessionInfo(byte[] sessionInfo) throws Exception {
            Cipher c;
            switch (this.pubKey.getAlgorithm()) {
                case 1: 
                case 2: {
                    c = Cipher.getInstance("RSA/ECB/PKCS1Padding", PGPEncryptedDataGenerator.this.defProvider);
                    break;
                }
                case 16: 
                case 20: {
                    c = Cipher.getInstance("ElGamal/ECB/PKCS1Padding", PGPEncryptedDataGenerator.this.defProvider);
                    break;
                }
                case 17: {
                    throw new PGPException("Can't use DSA for encryption.");
                }
                case 19: {
                    throw new PGPException("Can't use ECDSA for encryption.");
                }
                default: {
                    throw new PGPException("unknown asymmetric algorithm: " + this.pubKey.getAlgorithm());
                }
            }
            PublicKey key = this.pubKey.getKey(PGPEncryptedDataGenerator.this.defProvider);
            c.init(1, (Key)key, PGPEncryptedDataGenerator.this.rand);
            byte[] encKey = c.doFinal(sessionInfo);
            switch (this.pubKey.getAlgorithm()) {
                case 1: 
                case 2: {
                    this.data = new BigInteger[1];
                    this.data[0] = new BigInteger(1, encKey);
                    break;
                }
                case 16: 
                case 20: {
                    byte[] b1 = new byte[encKey.length / 2];
                    byte[] b2 = new byte[encKey.length / 2];
                    System.arraycopy(encKey, 0, b1, 0, b1.length);
                    System.arraycopy(encKey, b1.length, b2, 0, b2.length);
                    this.data = new BigInteger[2];
                    this.data[0] = new BigInteger(1, b1);
                    this.data[1] = new BigInteger(1, b2);
                    break;
                }
                default: {
                    throw new PGPException("unknown asymmetric algorithm: " + this.encAlgorithm);
                }
            }
        }

        public void encode(BCPGOutputStream pOut) throws IOException {
            PublicKeyEncSessionPacket pk = new PublicKeyEncSessionPacket(this.pubKey.getKeyID(), this.pubKey.getAlgorithm(), this.data);
            pOut.writePacket(pk);
        }
    }

    private class PBEMethod
    extends EncMethod {
        S2K s2k;

        PBEMethod(int encAlgorithm, S2K s2k, Key key) {
            this.encAlgorithm = encAlgorithm;
            this.s2k = s2k;
            this.key = key;
        }

        public Key getKey() {
            return this.key;
        }

        public void addSessionInfo(byte[] sessionInfo) throws Exception {
            String cName = PGPUtil.getSymmetricCipherName(this.encAlgorithm);
            Cipher c = Cipher.getInstance(cName + "/CFB/NoPadding", PGPEncryptedDataGenerator.this.defProvider);
            c.init(1, this.key, new IvParameterSpec(new byte[c.getBlockSize()]), PGPEncryptedDataGenerator.this.rand);
            this.sessionInfo = c.doFinal(sessionInfo, 0, sessionInfo.length - 2);
        }

        public void encode(BCPGOutputStream pOut) throws IOException {
            SymmetricKeyEncSessionPacket pk = new SymmetricKeyEncSessionPacket(this.encAlgorithm, this.s2k, this.sessionInfo);
            pOut.writePacket(pk);
        }
    }

    private abstract class EncMethod
    extends ContainedPacket {
        protected byte[] sessionInfo;
        protected int encAlgorithm;
        protected Key key;

        private EncMethod() {
        }

        public abstract void addSessionInfo(byte[] var1) throws Exception;
    }
}

