/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.openpgp;

import cn.tca.TopBasicCrypto.openpgp.PGPException;
import cn.tca.TopBasicCrypto.openpgp.PGPPrivateKey;
import cn.tca.TopBasicCrypto.openpgp.PGPPublicKey;
import java.security.KeyPair;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Date;

public class PGPKeyPair {
    PGPPublicKey pub;
    PGPPrivateKey priv;

    public PGPKeyPair(int algorithm, KeyPair keyPair, Date time, String provider) throws PGPException, NoSuchProviderException {
        this(algorithm, keyPair.getPublic(), keyPair.getPrivate(), time, provider);
    }

    public PGPKeyPair(int algorithm, KeyPair keyPair, Date time) throws PGPException {
        this(algorithm, keyPair.getPublic(), keyPair.getPrivate(), time);
    }

    public PGPKeyPair(int algorithm, PublicKey pubKey, PrivateKey privKey, Date time, String provider) throws PGPException, NoSuchProviderException {
        this(algorithm, pubKey, privKey, time);
    }

    public PGPKeyPair(int algorithm, PublicKey pubKey, PrivateKey privKey, Date time) throws PGPException {
        this.pub = new PGPPublicKey(algorithm, pubKey, time);
        this.priv = new PGPPrivateKey(privKey, this.pub.getKeyID());
    }

    public PGPKeyPair(PGPPublicKey pub, PGPPrivateKey priv) {
        this.pub = pub;
        this.priv = priv;
    }

    public long getKeyID() {
        return this.pub.getKeyID();
    }

    public PGPPublicKey getPublicKey() {
        return this.pub;
    }

    public PGPPrivateKey getPrivateKey() {
        return this.priv;
    }
}

