/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.openpgp;

import cn.tca.TopBasicCrypto.bcpg.PublicSubkeyPacket;
import cn.tca.TopBasicCrypto.openpgp.PGPException;
import cn.tca.TopBasicCrypto.openpgp.PGPKeyPair;
import cn.tca.TopBasicCrypto.openpgp.PGPPublicKey;
import cn.tca.TopBasicCrypto.openpgp.PGPPublicKeyRing;
import cn.tca.TopBasicCrypto.openpgp.PGPSecretKey;
import cn.tca.TopBasicCrypto.openpgp.PGPSecretKeyRing;
import cn.tca.TopBasicCrypto.openpgp.PGPSignature;
import cn.tca.TopBasicCrypto.openpgp.PGPSignatureGenerator;
import cn.tca.TopBasicCrypto.openpgp.PGPSignatureSubpacketVector;
import cn.tca.TopBasicCrypto.openpgp.PGPUtil;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PGPKeyRingGenerator {
    List keys = new ArrayList();
    private String id;
    private int encAlgorithm;
    private int certificationLevel;
    private char[] passPhrase;
    private boolean useSHA1;
    private PGPKeyPair masterKey;
    private PGPSignatureSubpacketVector hashedPcks;
    private PGPSignatureSubpacketVector unhashedPcks;
    private SecureRandom rand;
    private Provider provider;

    public PGPKeyRingGenerator(int certificationLevel, PGPKeyPair masterKey, String id, int encAlgorithm, char[] passPhrase, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, SecureRandom rand, String provider) throws PGPException, NoSuchProviderException {
        this(certificationLevel, masterKey, id, encAlgorithm, passPhrase, false, hashedPcks, unhashedPcks, rand, provider);
    }

    public PGPKeyRingGenerator(int certificationLevel, PGPKeyPair masterKey, String id, int encAlgorithm, char[] passPhrase, boolean useSHA1, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, SecureRandom rand, String provider) throws PGPException, NoSuchProviderException {
        this(certificationLevel, masterKey, id, encAlgorithm, passPhrase, useSHA1, hashedPcks, unhashedPcks, rand, PGPUtil.getProvider(provider));
    }

    public PGPKeyRingGenerator(int certificationLevel, PGPKeyPair masterKey, String id, int encAlgorithm, char[] passPhrase, boolean useSHA1, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, SecureRandom rand, Provider provider) throws PGPException, NoSuchProviderException {
        this.certificationLevel = certificationLevel;
        this.masterKey = masterKey;
        this.id = id;
        this.encAlgorithm = encAlgorithm;
        this.passPhrase = passPhrase;
        this.useSHA1 = useSHA1;
        this.hashedPcks = hashedPcks;
        this.unhashedPcks = unhashedPcks;
        this.rand = rand;
        this.provider = provider;
        this.keys.add(new PGPSecretKey(certificationLevel, masterKey, id, encAlgorithm, passPhrase, useSHA1, hashedPcks, unhashedPcks, rand, provider));
    }

    public void addSubKey(PGPKeyPair keyPair) throws PGPException {
        this.addSubKey(keyPair, this.hashedPcks, this.unhashedPcks);
    }

    public void addSubKey(PGPKeyPair keyPair, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks) throws PGPException {
        try {
            PGPSignatureGenerator sGen = new PGPSignatureGenerator(this.masterKey.getPublicKey().getAlgorithm(), 2, this.provider);
            sGen.initSign(24, this.masterKey.getPrivateKey());
            sGen.setHashedSubpackets(hashedPcks);
            sGen.setUnhashedSubpackets(unhashedPcks);
            ArrayList<PGPSignature> subSigs = new ArrayList<PGPSignature>();
            subSigs.add(sGen.generateCertification(this.masterKey.getPublicKey(), keyPair.getPublicKey()));
            this.keys.add(new PGPSecretKey(keyPair.getPrivateKey(), new PGPPublicKey(keyPair.getPublicKey(), null, subSigs), this.encAlgorithm, this.passPhrase, this.useSHA1, this.rand, this.provider));
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("exception adding subkey: ", e);
        }
    }

    public PGPSecretKeyRing generateSecretKeyRing() {
        return new PGPSecretKeyRing(this.keys);
    }

    public PGPPublicKeyRing generatePublicKeyRing() {
        Iterator it = this.keys.iterator();
        ArrayList<PGPPublicKey> pubKeys = new ArrayList<PGPPublicKey>();
        pubKeys.add(((PGPSecretKey)it.next()).getPublicKey());
        while (it.hasNext()) {
            PGPPublicKey k = new PGPPublicKey(((PGPSecretKey)it.next()).getPublicKey());
            k.publicPk = new PublicSubkeyPacket(k.getAlgorithm(), k.getCreationTime(), k.publicPk.getKey());
            pubKeys.add(k);
        }
        return new PGPPublicKeyRing(pubKeys);
    }
}

