/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.openpgp;

import cn.tca.TopBasicCrypto.bcpg.BCPGInputStream;
import cn.tca.TopBasicCrypto.bcpg.PublicKeyPacket;
import cn.tca.TopBasicCrypto.bcpg.TrustPacket;
import cn.tca.TopBasicCrypto.openpgp.PGPKeyRing;
import cn.tca.TopBasicCrypto.openpgp.PGPPublicKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PGPPublicKeyRing
extends PGPKeyRing {
    List keys;

    public PGPPublicKeyRing(byte[] encoding) throws IOException {
        this(new ByteArrayInputStream(encoding));
    }

    PGPPublicKeyRing(List pubKeys) {
        this.keys = pubKeys;
    }

    public PGPPublicKeyRing(InputStream in) throws IOException {
        this.keys = new ArrayList();
        BCPGInputStream pIn = PGPPublicKeyRing.wrap(in);
        int initialTag = pIn.nextPacketTag();
        if (initialTag != 6 && initialTag != 14) {
            throw new IOException("public key ring doesn't start with public key tag: tag 0x" + Integer.toHexString(initialTag));
        }
        PublicKeyPacket pubPk = (PublicKeyPacket)pIn.readPacket();
        TrustPacket trustPk = PGPPublicKeyRing.readOptionalTrustPacket(pIn);
        List keySigs = PGPPublicKeyRing.readSignaturesAndTrust(pIn);
        ArrayList ids = new ArrayList();
        ArrayList idTrusts = new ArrayList();
        ArrayList idSigs = new ArrayList();
        PGPPublicKeyRing.readUserIDs(pIn, ids, idTrusts, idSigs);
        this.keys.add(new PGPPublicKey(pubPk, trustPk, keySigs, ids, idTrusts, idSigs));
        while (pIn.nextPacketTag() == 14) {
            this.keys.add(PGPPublicKeyRing.readSubkey(pIn));
        }
    }

    public PGPPublicKey getPublicKey() {
        return (PGPPublicKey)this.keys.get(0);
    }

    public PGPPublicKey getPublicKey(long keyID) {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPPublicKey k = (PGPPublicKey)this.keys.get(i);
            if (keyID != k.getKeyID()) continue;
            return k;
        }
        return null;
    }

    public Iterator getPublicKeys() {
        return Collections.unmodifiableList(this.keys).iterator();
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut);
        return bOut.toByteArray();
    }

    public void encode(OutputStream outStream) throws IOException {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPPublicKey k = (PGPPublicKey)this.keys.get(i);
            k.encode(outStream);
        }
    }

    public static PGPPublicKeyRing insertPublicKey(PGPPublicKeyRing pubRing, PGPPublicKey pubKey) {
        ArrayList<PGPPublicKey> keys = new ArrayList<PGPPublicKey>(pubRing.keys);
        boolean found = false;
        boolean masterFound = false;
        for (int i = 0; i != keys.size(); ++i) {
            PGPPublicKey key = (PGPPublicKey)keys.get(i);
            if (key.getKeyID() == pubKey.getKeyID()) {
                found = true;
                keys.set(i, pubKey);
            }
            if (!key.isMasterKey()) continue;
            masterFound = true;
        }
        if (!found) {
            if (pubKey.isMasterKey()) {
                if (masterFound) {
                    throw new IllegalArgumentException("cannot add a master key to a ring that already has one");
                }
                keys.add(0, pubKey);
            } else {
                keys.add(pubKey);
            }
        }
        return new PGPPublicKeyRing(keys);
    }

    public static PGPPublicKeyRing removePublicKey(PGPPublicKeyRing pubRing, PGPPublicKey pubKey) {
        ArrayList keys = new ArrayList(pubRing.keys);
        boolean found = false;
        for (int i = 0; i < keys.size(); ++i) {
            PGPPublicKey key = (PGPPublicKey)keys.get(i);
            if (key.getKeyID() != pubKey.getKeyID()) continue;
            found = true;
            keys.remove(i);
        }
        if (!found) {
            return null;
        }
        return new PGPPublicKeyRing(keys);
    }

    static PGPPublicKey readSubkey(BCPGInputStream in) throws IOException {
        PublicKeyPacket pk = (PublicKeyPacket)in.readPacket();
        TrustPacket kTrust = PGPPublicKeyRing.readOptionalTrustPacket(in);
        List sigList = PGPPublicKeyRing.readSignaturesAndTrust(in);
        return new PGPPublicKey(pk, kTrust, sigList);
    }
}

