/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.openpgp;

import cn.tca.TopBasicCrypto.bcpg.SignatureSubpacket;
import cn.tca.TopBasicCrypto.bcpg.sig.EmbeddedSignature;
import cn.tca.TopBasicCrypto.bcpg.sig.Exportable;
import cn.tca.TopBasicCrypto.bcpg.sig.KeyExpirationTime;
import cn.tca.TopBasicCrypto.bcpg.sig.KeyFlags;
import cn.tca.TopBasicCrypto.bcpg.sig.NotationData;
import cn.tca.TopBasicCrypto.bcpg.sig.PreferredAlgorithms;
import cn.tca.TopBasicCrypto.bcpg.sig.PrimaryUserID;
import cn.tca.TopBasicCrypto.bcpg.sig.Revocable;
import cn.tca.TopBasicCrypto.bcpg.sig.SignatureCreationTime;
import cn.tca.TopBasicCrypto.bcpg.sig.SignatureExpirationTime;
import cn.tca.TopBasicCrypto.bcpg.sig.SignerUserID;
import cn.tca.TopBasicCrypto.bcpg.sig.TrustSignature;
import cn.tca.TopBasicCrypto.openpgp.PGPSignature;
import cn.tca.TopBasicCrypto.openpgp.PGPSignatureSubpacketVector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class PGPSignatureSubpacketGenerator {
    List list = new ArrayList();

    public void setRevocable(boolean isCritical, boolean isRevocable) {
        this.list.add(new Revocable(isCritical, isRevocable));
    }

    public void setExportable(boolean isCritical, boolean isExportable) {
        this.list.add(new Exportable(isCritical, isExportable));
    }

    public void setTrust(boolean isCritical, int depth, int trustAmount) {
        this.list.add(new TrustSignature(isCritical, depth, trustAmount));
    }

    public void setKeyExpirationTime(boolean isCritical, long seconds) {
        this.list.add(new KeyExpirationTime(isCritical, seconds));
    }

    public void setSignatureExpirationTime(boolean isCritical, long seconds) {
        this.list.add(new SignatureExpirationTime(isCritical, seconds));
    }

    public void setSignatureCreationTime(boolean isCritical, Date date) {
        this.list.add(new SignatureCreationTime(isCritical, date));
    }

    public void setPreferredHashAlgorithms(boolean isCritical, int[] algorithms) {
        this.list.add(new PreferredAlgorithms(21, isCritical, algorithms));
    }

    public void setPreferredSymmetricAlgorithms(boolean isCritical, int[] algorithms) {
        this.list.add(new PreferredAlgorithms(11, isCritical, algorithms));
    }

    public void setPreferredCompressionAlgorithms(boolean isCritical, int[] algorithms) {
        this.list.add(new PreferredAlgorithms(22, isCritical, algorithms));
    }

    public void setKeyFlags(boolean isCritical, int flags) {
        this.list.add(new KeyFlags(isCritical, flags));
    }

    public void setSignerUserID(boolean isCritical, String userID) {
        if (userID == null) {
            throw new IllegalArgumentException("attempt to set null SignerUserID");
        }
        this.list.add(new SignerUserID(isCritical, userID));
    }

    public void setEmbeddedSignature(boolean isCritical, PGPSignature pgpSignature) throws IOException {
        byte[] sig = pgpSignature.getEncoded();
        byte[] data = sig.length - 1 > 256 ? new byte[sig.length - 3] : new byte[sig.length - 2];
        System.arraycopy(sig, sig.length - data.length, data, 0, data.length);
        this.list.add(new EmbeddedSignature(isCritical, data));
    }

    public void setPrimaryUserID(boolean isCritical, boolean isPrimaryUserID) {
        this.list.add(new PrimaryUserID(isCritical, isPrimaryUserID));
    }

    public void setNotationData(boolean isCritical, boolean isHumanReadable, String notationName, String notationValue) {
        this.list.add(new NotationData(isCritical, isHumanReadable, notationName, notationValue));
    }

    public PGPSignatureSubpacketVector generate() {
        return new PGPSignatureSubpacketVector(this.list.toArray(new SignatureSubpacket[this.list.size()]));
    }
}

