/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.openpgp;

import cn.tca.TopBasicCrypto.bcpg.MPInteger;
import cn.tca.TopBasicCrypto.bcpg.OnePassSignaturePacket;
import cn.tca.TopBasicCrypto.bcpg.SignaturePacket;
import cn.tca.TopBasicCrypto.openpgp.PGPException;
import cn.tca.TopBasicCrypto.openpgp.PGPOnePassSignature;
import cn.tca.TopBasicCrypto.openpgp.PGPPrivateKey;
import cn.tca.TopBasicCrypto.openpgp.PGPSignature;
import cn.tca.TopBasicCrypto.openpgp.PGPUtil;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Date;

public class PGPV3SignatureGenerator {
    private int keyAlgorithm;
    private int hashAlgorithm;
    private PGPPrivateKey privKey;
    private Signature sig;
    private MessageDigest dig;
    private int signatureType;
    private byte lastb;

    public PGPV3SignatureGenerator(int keyAlgorithm, int hashAlgorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, PGPException {
        this(keyAlgorithm, hashAlgorithm, PGPUtil.getProvider(provider));
    }

    public PGPV3SignatureGenerator(int keyAlgorithm, int hashAlgorithm, Provider provider) throws NoSuchAlgorithmException, PGPException {
        this.keyAlgorithm = keyAlgorithm;
        this.hashAlgorithm = hashAlgorithm;
        this.dig = PGPUtil.getDigestInstance(PGPUtil.getDigestName(hashAlgorithm), provider);
        this.sig = Signature.getInstance(PGPUtil.getSignatureName(keyAlgorithm, hashAlgorithm), provider);
    }

    public void initSign(int signatureType, PGPPrivateKey key) throws PGPException {
        this.initSign(signatureType, key, null);
    }

    public void initSign(int signatureType, PGPPrivateKey key, SecureRandom random) throws PGPException {
        this.privKey = key;
        this.signatureType = signatureType;
        try {
            if (random == null) {
                this.sig.initSign(key.getKey());
            } else {
                this.sig.initSign(key.getKey(), random);
            }
        }
        catch (InvalidKeyException e) {
            throw new PGPException("invalid key.", e);
        }
        this.dig.reset();
        this.lastb = 0;
    }

    public void update(byte b) throws SignatureException {
        if (this.signatureType == 1) {
            if (b == 13) {
                this.sig.update((byte)13);
                this.sig.update((byte)10);
                this.dig.update((byte)13);
                this.dig.update((byte)10);
            } else if (b == 10) {
                if (this.lastb != 13) {
                    this.sig.update((byte)13);
                    this.sig.update((byte)10);
                    this.dig.update((byte)13);
                    this.dig.update((byte)10);
                }
            } else {
                this.sig.update(b);
                this.dig.update(b);
            }
            this.lastb = b;
        } else {
            this.sig.update(b);
            this.dig.update(b);
        }
    }

    public void update(byte[] b) throws SignatureException {
        this.update(b, 0, b.length);
    }

    public void update(byte[] b, int off, int len) throws SignatureException {
        if (this.signatureType == 1) {
            int finish = off + len;
            for (int i = off; i != finish; ++i) {
                this.update(b[i]);
            }
        } else {
            this.sig.update(b, off, len);
            this.dig.update(b, off, len);
        }
    }

    public PGPOnePassSignature generateOnePassVersion(boolean isNested) throws PGPException {
        return new PGPOnePassSignature(new OnePassSignaturePacket(this.signatureType, this.hashAlgorithm, this.keyAlgorithm, this.privKey.getKeyID(), isNested));
    }

    public PGPSignature generate() throws PGPException, SignatureException {
        long creationTime = new Date().getTime() / 1000L;
        ByteArrayOutputStream sOut = new ByteArrayOutputStream();
        sOut.write(this.signatureType);
        sOut.write((byte)(creationTime >> 24));
        sOut.write((byte)(creationTime >> 16));
        sOut.write((byte)(creationTime >> 8));
        sOut.write((byte)creationTime);
        byte[] hData = sOut.toByteArray();
        this.sig.update(hData);
        this.dig.update(hData);
        MPInteger[] sigValues = this.keyAlgorithm == 3 || this.keyAlgorithm == 1 ? new MPInteger[]{new MPInteger(new BigInteger(1, this.sig.sign()))} : PGPUtil.dsaSigToMpi(this.sig.sign());
        byte[] digest = this.dig.digest();
        byte[] fingerPrint = new byte[]{digest[0], digest[1]};
        return new PGPSignature(new SignaturePacket(3, this.signatureType, this.privKey.getKeyID(), this.keyAlgorithm, this.hashAlgorithm, creationTime * 1000L, fingerPrint, sigValues));
    }
}

