/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.operator.bc;

import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.asn1.x509.SubjectPublicKeyInfo;
import cn.tca.TopBasicCrypto.cert.X509CertificateHolder;
import cn.tca.TopBasicCrypto.crypto.Signer;
import cn.tca.TopBasicCrypto.crypto.params.AsymmetricKeyParameter;
import cn.tca.TopBasicCrypto.operator.ContentVerifier;
import cn.tca.TopBasicCrypto.operator.ContentVerifierProvider;
import cn.tca.TopBasicCrypto.operator.OperatorCreationException;
import cn.tca.TopBasicCrypto.operator.bc.BcSignerOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class BcContentVerifierProviderBuilder {
    public ContentVerifierProvider build(final X509CertificateHolder certHolder) throws OperatorCreationException {
        return new ContentVerifierProvider(){

            public boolean hasAssociatedCertificate() {
                return true;
            }

            public X509CertificateHolder getAssociatedCertificate() {
                return certHolder;
            }

            public ContentVerifier get(AlgorithmIdentifier algorithm) throws OperatorCreationException {
                try {
                    AsymmetricKeyParameter publicKey = BcContentVerifierProviderBuilder.this.extractKeyParameters(certHolder.getSubjectPublicKeyInfo());
                    BcSignerOutputStream stream = BcContentVerifierProviderBuilder.this.createSignatureStream(algorithm, publicKey);
                    return new SigVerifier(algorithm, stream);
                }
                catch (IOException e) {
                    throw new OperatorCreationException("exception on setup: " + e, e);
                }
            }
        };
    }

    public ContentVerifierProvider build(final AsymmetricKeyParameter publicKey) throws OperatorCreationException {
        return new ContentVerifierProvider(){

            public boolean hasAssociatedCertificate() {
                return false;
            }

            public X509CertificateHolder getAssociatedCertificate() {
                return null;
            }

            public ContentVerifier get(AlgorithmIdentifier algorithm) throws OperatorCreationException {
                BcSignerOutputStream stream = BcContentVerifierProviderBuilder.this.createSignatureStream(algorithm, publicKey);
                return new SigVerifier(algorithm, stream);
            }
        };
    }

    private BcSignerOutputStream createSignatureStream(AlgorithmIdentifier algorithm, AsymmetricKeyParameter publicKey) throws OperatorCreationException {
        Signer sig = this.createSigner(algorithm);
        sig.init(false, publicKey);
        return new BcSignerOutputStream(sig);
    }

    protected abstract AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo var1) throws IOException;

    protected abstract Signer createSigner(AlgorithmIdentifier var1) throws OperatorCreationException;

    private class SigVerifier
    implements ContentVerifier {
        private BcSignerOutputStream stream;
        private AlgorithmIdentifier algorithm;

        SigVerifier(AlgorithmIdentifier algorithm, BcSignerOutputStream stream) {
            this.algorithm = algorithm;
            this.stream = stream;
        }

        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.algorithm;
        }

        public OutputStream getOutputStream() {
            if (this.stream == null) {
                throw new IllegalStateException("verifier not initialised");
            }
            return this.stream;
        }

        public boolean verify(byte[] expected) {
            return this.stream.verify(expected);
        }
    }
}

