/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.pkcs11;

import cn.topca.security.pkcs11.MemoryCache;
import cn.topca.security.pkcs11.NullCache;
import java.util.Arrays;
import java.util.Map;

public abstract class Cache {
    protected Cache() {
    }

    public abstract int size();

    public abstract void clear();

    public abstract void put(Object var1, Object var2);

    public abstract Object get(Object var1);

    public abstract void remove(Object var1);

    public abstract void setCapacity(int var1);

    public abstract void setTimeout(int var1);

    public abstract void accept(CacheVisitor var1);

    public static Cache newSoftMemoryCache(int size) {
        return new MemoryCache(true, size);
    }

    public static Cache newSoftMemoryCache(int size, int timeout) {
        return new MemoryCache(true, size, timeout);
    }

    public static Cache newHardMemoryCache(int size) {
        return new MemoryCache(false, size);
    }

    public static Cache newNullCache() {
        return NullCache.INSTANCE;
    }

    public static Cache newHardMemoryCache(int size, int timeout) {
        return new MemoryCache(false, size, timeout);
    }

    public static interface CacheVisitor {
        public void visit(Map<Object, Object> var1);
    }

    public static class EqualByteArray {
        private final byte[] b;
        private volatile int hash;

        public EqualByteArray(byte[] b) {
            this.b = b;
        }

        public int hashCode() {
            int h = this.hash;
            if (h == 0) {
                h = this.b.length + 1;
                for (int i = 0; i < this.b.length; ++i) {
                    h += (this.b[i] & 0xFF) * 37;
                }
                this.hash = h;
            }
            return h;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof EqualByteArray)) {
                return false;
            }
            EqualByteArray other = (EqualByteArray)obj;
            return Arrays.equals(this.b, other.b);
        }
    }
}

