/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.pkcs11;

import cn.topca.security.pkcs11.P11Key;
import cn.topca.security.pkcs11.P11RSACipher;
import cn.topca.security.pkcs11.P11SM2Cipher;
import cn.topca.security.pkcs11.P11SecretKeyFactory;
import cn.topca.security.pkcs11.P11Util;
import cn.topca.security.pkcs11.Session;
import cn.topca.security.pkcs11.Token;
import cn.topca.security.pkcs11.TopPKCS11Provider;
import cn.topca.security.pkcs11.jna.CK_MECHANISM;
import cn.topca.security.pkcs11.jna.PKCS11Exception;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

public final class P11Cipher
extends CipherSpi {
    private static final int MODE_ECB = 3;
    private static final int MODE_CBC = 4;
    private static final int MODE_CTR = 5;
    private static final int PAD_NONE = 5;
    private static final int PAD_PKCS5 = 6;
    private final Token token;
    private final String algorithm;
    private final String keyAlgorithm;
    private final long mechanism;
    private Session session;
    private P11Key p11Key;
    private boolean initialized;
    private boolean encrypt;
    private int blockMode;
    private final int blockSize;
    private int paddingType;
    private Padding paddingObj;
    private byte[] buffer;
    private int bufferLen;
    private byte[] iv;
    private int bytesBuffered;
    private static final Map<Provider, P11Cipher> INSTANCEs = new HashMap<Provider, P11Cipher>();
    private Provider provider;
    private CipherSpi spi;
    private static final String KEY_USAGE_EXTENSION_OID = "2.5.29.15";

    P11Cipher(Token token, String algorithm, long mechanism) throws PKCS11Exception, NoSuchAlgorithmException {
        String modeType;
        this.token = token;
        this.algorithm = algorithm;
        this.mechanism = mechanism;
        String[] algoParts = algorithm.split("/");
        this.keyAlgorithm = algoParts[0];
        this.blockSize = this.keyAlgorithm.equals("AES") ? 16 : (this.keyAlgorithm.equals("RC4") || this.keyAlgorithm.equals("ARCFOUR") ? 0 : (this.keyAlgorithm.equals("SM1") ? 16 : (this.keyAlgorithm.equals("SM4") || this.keyAlgorithm.equals("SMS4") ? 16 : 8)));
        String string = modeType = algoParts.length > 1 ? algoParts[1] : null;
        if (modeType == null || modeType.trim().length() == 0) {
            modeType = "CBC";
        }
        this.blockMode = this.parseMode(modeType);
        String defPadding = this.blockSize == 0 ? "NoPadding" : "PKCS5Padding";
        String paddingStr = algoParts.length > 2 ? algoParts[2] : defPadding;
        try {
            this.engineSetPadding(paddingStr);
        }
        catch (NoSuchPaddingException nspe) {
            throw new ProviderException(nspe);
        }
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("Unsupported mode " + mode);
    }

    private int parseMode(String mode) throws NoSuchAlgorithmException {
        int result;
        if ((mode = mode.toUpperCase(Locale.ENGLISH)).equals("ECB")) {
            result = 3;
        } else if (mode.equals("CBC")) {
            if (this.blockSize == 0) {
                throw new NoSuchAlgorithmException("CBC mode not supported with stream ciphers");
            }
            result = 4;
        } else if (mode.equals("CTR")) {
            result = 5;
        } else {
            throw new NoSuchAlgorithmException("Unsupported mode " + mode);
        }
        return result;
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        this.paddingObj = null;
        this.buffer = null;
        if ((padding = padding.toUpperCase(Locale.ENGLISH)).equals("NOPADDING")) {
            this.paddingType = 5;
        } else if (padding.equals("PKCS5PADDING")) {
            if (this.blockMode == 5) {
                throw new NoSuchPaddingException("PKCS#5 padding not supported with CTR mode");
            }
            this.paddingType = 6;
            this.paddingObj = new PKCS5Padding(this.blockSize);
            this.buffer = new byte[this.blockSize];
        } else {
            throw new NoSuchPaddingException("Unsupported padding " + padding);
        }
    }

    @Override
    protected int engineGetBlockSize() {
        return this.blockSize;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return this.doFinalLength(inputLen);
    }

    @Override
    protected byte[] engineGetIV() {
        return this.iv == null ? null : (byte[])this.iv.clone();
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.iv == null) {
            return null;
        }
        IvParameterSpec ivSpec = new IvParameterSpec(this.iv);
        try {
            AlgorithmParameters params = AlgorithmParameters.getInstance(this.keyAlgorithm);
            params.init(ivSpec);
            return params;
        }
        catch (GeneralSecurityException e) {
            throw new ProviderException("Could not encode parameters", e);
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.implInit(opmode, key, null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException("init() failed", e);
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] ivValue;
        if (params != null) {
            if (!(params instanceof IvParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Only IvParameterSpec supported");
            }
            IvParameterSpec ivSpec = (IvParameterSpec)params;
            ivValue = ivSpec.getIV();
        } else {
            ivValue = null;
        }
        this.implInit(opmode, key, ivValue, random);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] ivValue;
        if (params != null) {
            try {
                IvParameterSpec ivSpec = params.getParameterSpec(IvParameterSpec.class);
                ivValue = ivSpec.getIV();
            }
            catch (InvalidParameterSpecException e) {
                throw new InvalidAlgorithmParameterException("Could not decode IV", e);
            }
        } else {
            ivValue = null;
        }
        this.implInit(opmode, key, ivValue, random);
    }

    private void implInit(int opmode, Key key, byte[] iv, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cancelOperation();
        switch (opmode) {
            case 1: {
                this.encrypt = true;
                break;
            }
            case 2: {
                this.encrypt = false;
                break;
            }
            default: {
                throw new InvalidAlgorithmParameterException("Unsupported mode: " + opmode);
            }
        }
        if (this.blockMode == 3) {
            if (iv != null) {
                if (this.blockSize == 0) {
                    throw new InvalidAlgorithmParameterException("IV not used with stream ciphers");
                }
                throw new InvalidAlgorithmParameterException("IV not used in ECB mode");
            }
        } else if (iv == null) {
            if (!this.encrypt) {
                String exMsg = this.blockMode == 4 ? "IV must be specified for decryption in CBC mode" : "IV must be specified for decryption in CTR mode";
                throw new InvalidAlgorithmParameterException(exMsg);
            }
            if (random == null) {
                random = new SecureRandom();
            }
            iv = new byte[this.blockSize];
            random.nextBytes(iv);
        } else if (iv.length != this.blockSize) {
            throw new InvalidAlgorithmParameterException("IV length must match block size");
        }
        this.iv = iv;
        this.p11Key = P11SecretKeyFactory.convertKey(this.token, key, this.keyAlgorithm);
        try {
            this.initialize();
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeyException("Could not initialize cipher", e);
        }
    }

    private void cancelOperation() {
        if (!this.initialized) {
            return;
        }
        this.initialized = false;
        if (this.session == null || !this.token.explicitCancel) {
            return;
        }
        int bufLen = this.doFinalLength(0);
        byte[] buffer = new byte[bufLen];
        try {
            if (this.encrypt) {
                this.token.p11.C_EncryptFinal(this.session.id(), 0L, buffer, 0, bufLen);
            } else {
                this.token.p11.C_DecryptFinal(this.session.id(), 0L, buffer, 0, bufLen);
            }
        }
        catch (PKCS11Exception e) {
            throw new ProviderException("Cancel failed", e);
        }
        finally {
            this.reset();
        }
    }

    private void ensureInitialized() throws PKCS11Exception {
        if (!this.initialized) {
            this.initialize();
        }
    }

    private void initialize() throws PKCS11Exception {
        if (this.session == null) {
            this.session = this.token.getOpSession();
        }
        CK_MECHANISM mechParams = new CK_MECHANISM(this.mechanism, this.iv);
        try {
            if (this.encrypt) {
                this.token.p11.C_EncryptInit(this.session.id(), mechParams, this.p11Key.keyID);
            } else {
                this.token.p11.C_DecryptInit(this.session.id(), mechParams, this.p11Key.keyID);
            }
        }
        catch (PKCS11Exception ex) {
            this.session = this.token.releaseSession(this.session);
            throw ex;
        }
        this.bytesBuffered = 0;
        this.bufferLen = 0;
        this.initialized = true;
    }

    private int updateLength(int inLen) {
        if (inLen <= 0) {
            return 0;
        }
        int result = inLen + this.bytesBuffered;
        if (this.blockSize != 0) {
            result -= result & this.blockSize - 1;
        }
        return result;
    }

    private int doFinalLength(int inLen) {
        if (inLen < 0) {
            return 0;
        }
        int result = inLen + this.bytesBuffered;
        if (this.blockSize != 0 && this.encrypt && this.paddingType != 5) {
            result += this.blockSize - (result & this.blockSize - 1);
        }
        return result;
    }

    private void reset() {
        this.initialized = false;
        this.bytesBuffered = 0;
        this.bufferLen = 0;
        if (this.session != null) {
            this.session = this.token.releaseSession(this.session);
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] in, int inOfs, int inLen) {
        try {
            byte[] out = new byte[this.updateLength(inLen)];
            int n = this.engineUpdate(in, inOfs, inLen, out, 0);
            return P11Util.convert(out, 0, n);
        }
        catch (ShortBufferException e) {
            throw new ProviderException(e);
        }
    }

    @Override
    protected int engineUpdate(byte[] in, int inOfs, int inLen, byte[] out, int outOfs) throws ShortBufferException {
        int outLen = out.length - outOfs;
        return this.implUpdate(in, inOfs, inLen, out, outOfs, outLen);
    }

    @Override
    protected int engineUpdate(ByteBuffer inBuffer, ByteBuffer outBuffer) throws ShortBufferException {
        return this.implUpdate(inBuffer, outBuffer);
    }

    @Override
    protected byte[] engineDoFinal(byte[] in, int inOfs, int inLen) throws IllegalBlockSizeException, BadPaddingException {
        try {
            byte[] out = new byte[this.doFinalLength(inLen)];
            int n = this.engineDoFinal(in, inOfs, inLen, out, 0);
            return P11Util.convert(out, 0, n);
        }
        catch (ShortBufferException e) {
            throw new ProviderException(e);
        }
    }

    @Override
    protected int engineDoFinal(byte[] in, int inOfs, int inLen, byte[] out, int outOfs) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n = 0;
        if (inLen != 0 && in != null) {
            n = this.engineUpdate(in, inOfs, inLen, out, outOfs);
            outOfs += n;
        }
        return n += this.implDoFinal(out, outOfs, out.length - outOfs);
    }

    @Override
    protected int engineDoFinal(ByteBuffer inBuffer, ByteBuffer outBuffer) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n = this.engineUpdate(inBuffer, outBuffer);
        return n += this.implDoFinal(outBuffer);
    }

    private int implUpdate(byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws ShortBufferException {
        if (outLen < this.updateLength(inLen)) {
            throw new ShortBufferException();
        }
        try {
            this.ensureInitialized();
            int k = 0;
            if (this.encrypt) {
                if (this.paddingObj != null) {
                    while (inLen >= this.blockSize) {
                        this.bufferInputBytes(in, inOfs, this.blockSize);
                        k += this.token.p11.C_EncryptUpdate(this.session.id(), 0L, this.buffer, 0, this.blockSize, 0L, out, outOfs + k, outLen);
                        inOfs += this.blockSize;
                        inLen -= this.blockSize;
                        this.bufferLen = 0;
                    }
                    this.bufferInputBytes(in, inOfs, inLen);
                    return k;
                }
                k = this.token.p11.C_EncryptUpdate(this.session.id(), 0L, in, 0, inLen, 0L, out, outOfs, outLen);
            } else {
                if (this.paddingObj != null) {
                    while (inLen > this.blockSize) {
                        this.bufferInputBytes(in, inOfs, this.blockSize);
                        k += this.token.p11.C_DecryptUpdate(this.session.id(), 0L, this.buffer, 0, this.blockSize, 0L, out, outOfs + k, outLen);
                        inOfs += this.blockSize;
                        inLen -= this.blockSize;
                        this.bufferLen = 0;
                    }
                    if (inLen == 0) {
                        return k;
                    }
                    this.bufferInputBytes(in, inOfs, inLen);
                    return k;
                }
                k = this.token.p11.C_DecryptUpdate(this.session.id(), 0L, in, 0, inLen, 0L, out, outOfs, outLen);
            }
            this.bytesBuffered += inLen - k;
            return k;
        }
        catch (PKCS11Exception e) {
            if (e.getErrorCode() == 336L) {
                throw (ShortBufferException)new ShortBufferException().initCause(e);
            }
            this.reset();
            throw new ProviderException("update() failed", e);
        }
    }

    private int implUpdate(ByteBuffer inBuffer, ByteBuffer outBuffer) throws ShortBufferException {
        int inLen = inBuffer.remaining();
        if (inLen <= 0) {
            return 0;
        }
        int outLen = outBuffer.remaining();
        if (outLen < this.updateLength(inLen)) {
            throw new ShortBufferException();
        }
        int origPos = inBuffer.position();
        try {
            this.ensureInitialized();
            long inAddr = 0L;
            int inOfs = 0;
            byte[] inArray = null;
            inAddr = this.getDirectBufferAddress(inBuffer);
            if (inAddr > 0L) {
                inOfs = origPos;
            } else if (inBuffer.hasArray()) {
                inArray = inBuffer.array();
                inOfs = origPos + inBuffer.arrayOffset();
            }
            long outAddr = 0L;
            int outOfs = 0;
            byte[] outArray = null;
            outAddr = this.getDirectBufferAddress(outBuffer);
            if (outAddr > 0L) {
                outOfs = outBuffer.position();
            } else if (outBuffer.hasArray()) {
                outArray = outBuffer.array();
                outOfs = outBuffer.position() + outBuffer.arrayOffset();
            } else {
                outArray = new byte[outLen];
            }
            int k = 0;
            if (this.encrypt) {
                if (inAddr == 0L && inArray == null) {
                    inArray = new byte[inLen];
                    inBuffer.get(inArray);
                } else {
                    inBuffer.position(origPos + inLen);
                }
                k = this.token.p11.C_EncryptUpdate(this.session.id(), inAddr, inArray, inOfs, inLen, outAddr, outArray, outOfs, outLen);
            } else {
                int newPadBufferLen = 0;
                if (this.paddingObj != null) {
                    if (this.bufferLen != 0) {
                        if (this.bufferLen != this.buffer.length) {
                            int bufCapacity = this.buffer.length - this.bufferLen;
                            if (inLen > bufCapacity) {
                                this.bufferInputBytes(inBuffer, bufCapacity);
                                inOfs += bufCapacity;
                                inLen -= bufCapacity;
                            } else {
                                this.bufferInputBytes(inBuffer, inLen);
                                return 0;
                            }
                        }
                        k = this.token.p11.C_DecryptUpdate(this.session.id(), 0L, this.buffer, 0, this.bufferLen, outAddr, outArray, outOfs, outLen);
                        this.bufferLen = 0;
                    }
                    if ((newPadBufferLen = inLen & this.blockSize - 1) == 0) {
                        newPadBufferLen = this.buffer.length;
                    }
                    inLen -= newPadBufferLen;
                }
                if (inLen > 0) {
                    if (inAddr == 0L && inArray == null) {
                        inArray = new byte[inLen];
                        inBuffer.get(inArray);
                    } else {
                        inBuffer.position(inBuffer.position() + inLen);
                    }
                    k += this.token.p11.C_DecryptUpdate(this.session.id(), inAddr, inArray, inOfs, inLen, outAddr, outArray, outOfs + k, outLen - k);
                }
                if (this.paddingObj != null && newPadBufferLen != 0) {
                    this.bufferInputBytes(inBuffer, newPadBufferLen);
                }
            }
            this.bytesBuffered += inLen - k;
            if (this.getDirectBufferAddress(outBuffer) <= 0L && !outBuffer.hasArray()) {
                outBuffer.put(outArray, outOfs, k);
            } else {
                outBuffer.position(outBuffer.position() + k);
            }
            return k;
        }
        catch (PKCS11Exception e) {
            inBuffer.position(origPos);
            if (e.getErrorCode() == 336L) {
                throw (ShortBufferException)new ShortBufferException().initCause(e);
            }
            this.reset();
            throw new ProviderException("update() failed", e);
        }
    }

    private int implDoFinal(byte[] out, int outOfs, int outLen) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int requiredOutLen = this.doFinalLength(0);
        if (outLen != 0 && outLen < this.buffer.length) {
            throw new ShortBufferException();
        }
        try {
            int actualPadLen;
            this.ensureInitialized();
            int k = 0;
            if (this.encrypt) {
                if (this.paddingObj != null) {
                    actualPadLen = this.paddingObj.setPaddingBytes(this.buffer, this.bufferLen, requiredOutLen - this.bytesBuffered);
                    k = this.token.p11.C_EncryptUpdate(this.session.id(), 0L, this.buffer, 0, actualPadLen + this.bufferLen, 0L, out, outOfs, outLen);
                }
                k += this.token.p11.C_EncryptFinal(this.session.id(), 0L, out, outOfs + k, outLen - k);
            } else if (this.paddingObj != null) {
                if (this.bufferLen != 0) {
                    k = this.token.p11.C_DecryptUpdate(this.session.id(), 0L, this.buffer, 0, this.bufferLen, 0L, this.buffer, 0, this.buffer.length);
                }
                k += this.token.p11.C_DecryptFinal(this.session.id(), 0L, this.buffer, k, this.buffer.length - k);
                actualPadLen = this.paddingObj.unpad(this.buffer, k);
                System.arraycopy(this.buffer, 0, out, outOfs, k -= actualPadLen);
            } else {
                k = this.token.p11.C_DecryptFinal(this.session.id(), 0L, out, outOfs, outLen);
            }
            int n = k;
            return n;
        }
        catch (PKCS11Exception e) {
            this.handleException(e);
            throw new ProviderException("doFinal() failed", e);
        }
        finally {
            this.reset();
        }
    }

    private int implDoFinal(ByteBuffer outBuffer) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int requiredOutLen;
        int outLen = outBuffer.remaining();
        if (outLen < (requiredOutLen = this.doFinalLength(0))) {
            throw new ShortBufferException();
        }
        try {
            int actualPadLen;
            this.ensureInitialized();
            long outAddr = 0L;
            byte[] outArray = null;
            int outOfs = 0;
            outAddr = this.getDirectBufferAddress(outBuffer);
            if (outAddr > 0L) {
                outOfs = outBuffer.position();
            } else if (outBuffer.hasArray()) {
                outArray = outBuffer.array();
                outOfs = outBuffer.position() + outBuffer.arrayOffset();
            } else {
                outArray = new byte[outLen];
            }
            int k = 0;
            if (this.encrypt) {
                if (this.paddingObj != null) {
                    actualPadLen = this.paddingObj.setPaddingBytes(this.buffer, requiredOutLen - this.bytesBuffered);
                    k = this.token.p11.C_EncryptUpdate(this.session.id(), 0L, this.buffer, 0, actualPadLen, outAddr, outArray, outOfs, outLen);
                }
                k += this.token.p11.C_EncryptFinal(this.session.id(), outAddr, outArray, outOfs + k, outLen - k);
            } else if (this.paddingObj != null) {
                if (this.bufferLen != 0) {
                    k = this.token.p11.C_DecryptUpdate(this.session.id(), 0L, this.buffer, 0, this.bufferLen, 0L, this.buffer, 0, this.buffer.length);
                    this.bufferLen = 0;
                }
                k += this.token.p11.C_DecryptFinal(this.session.id(), 0L, this.buffer, k, this.buffer.length - k);
                actualPadLen = this.paddingObj.unpad(this.buffer, k);
                k -= actualPadLen;
                outArray = this.buffer;
                outOfs = 0;
            } else {
                k = this.token.p11.C_DecryptFinal(this.session.id(), outAddr, outArray, outOfs, outLen);
            }
            if (!this.encrypt && this.paddingObj != null || this.getDirectBufferAddress(outBuffer) <= 0L && !outBuffer.hasArray()) {
                outBuffer.put(outArray, outOfs, k);
            } else {
                outBuffer.position(outBuffer.position() + k);
            }
            int n = k;
            return n;
        }
        catch (PKCS11Exception e) {
            this.handleException(e);
            throw new ProviderException("doFinal() failed", e);
        }
        finally {
            this.reset();
        }
    }

    private void handleException(PKCS11Exception e) throws ShortBufferException, IllegalBlockSizeException {
        long errorCode = e.getErrorCode();
        if (errorCode == 336L) {
            throw (ShortBufferException)new ShortBufferException().initCause(e);
        }
        if (errorCode == 33L || errorCode == 65L) {
            throw (IllegalBlockSizeException)new IllegalBlockSizeException(e.toString()).initCause(e);
        }
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        throw new UnsupportedOperationException("engineWrap()");
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        throw new UnsupportedOperationException("engineUnwrap()");
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        int n = P11SecretKeyFactory.convertKey(this.token, key, this.keyAlgorithm).keyLength();
        return n;
    }

    private final void bufferInputBytes(byte[] in, int inOfs, int len) {
        System.arraycopy(in, inOfs, this.buffer, this.bufferLen, len);
        this.bufferLen += len;
        this.bytesBuffered += len;
    }

    private final void bufferInputBytes(ByteBuffer inBuffer, int len) {
        inBuffer.get(this.buffer, this.bufferLen, len);
        this.bufferLen += len;
        this.bytesBuffered += len;
    }

    private long getDirectBufferAddress(ByteBuffer buffer) {
        try {
            Field addressField = buffer.getClass().getField("address");
            long address = addressField.getLong(buffer);
            if (address > 0L) {
                return address;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    private P11Cipher(Token token, String algorithm, long mechanism, Provider provider) throws PKCS11Exception, NoSuchAlgorithmException {
        this.provider = provider;
        this.token = token;
        this.algorithm = algorithm;
        this.mechanism = mechanism;
        String[] algoParts = algorithm.split("/");
        this.keyAlgorithm = algoParts[0];
        this.spi = algorithm.equals("SM2") ? new P11SM2Cipher(token, algorithm, mechanism) : (algorithm.equals("RSA") ? new P11RSACipher(token, algorithm, mechanism) : new P11Cipher(token, algorithm, mechanism));
        this.blockMode = 0;
        this.blockSize = 0;
    }

    public static P11Cipher getInstance(String transformation, Provider provider) throws NoSuchAlgorithmException {
        P11Cipher cipher;
        block11: {
            if (INSTANCEs.containsKey(provider)) {
                return INSTANCEs.get(provider);
            }
            if (!(provider instanceof TopPKCS11Provider)) {
                throw new RuntimeException("Provider must be TopPKCS11Provider");
            }
            TopPKCS11Provider _p = (TopPKCS11Provider)provider;
            Token token = _p.getToken();
            try {
                String[] tr = transformation.split("/");
                if (transformation.startsWith("SM2")) {
                    long mechanism = _p.config.getSMConstants().CKM_SM2;
                    cipher = new P11Cipher(token, "SM2", mechanism, _p);
                    break block11;
                }
                if (transformation.startsWith("RSA")) {
                    long mechanism = 1L;
                    cipher = new P11Cipher(token, "RSA", mechanism, _p);
                    break block11;
                }
                if (transformation.startsWith("SM1")) {
                    long mechanism = tr.length > 1 && "ECB".equalsIgnoreCase(tr[1]) ? _p.config.getSMConstants().CKM_SM1_ECB : _p.config.getSMConstants().CKM_SM1_CBC;
                    cipher = new P11Cipher(token, transformation, mechanism, _p);
                    break block11;
                }
                if (transformation.startsWith("SM4")) {
                    long mechanism = tr.length > 1 && "ECB".equalsIgnoreCase(tr[1]) ? _p.config.getSMConstants().CKM_SM4_ECB : _p.config.getSMConstants().CKM_SM4_CBC;
                    cipher = new P11Cipher(token, transformation, mechanism, _p);
                    break block11;
                }
                if (transformation.startsWith("AES")) {
                    long mechanism = 4226L;
                    cipher = new P11Cipher(token, transformation, mechanism, _p);
                    break block11;
                }
                if (transformation.startsWith("DESede")) {
                    long mechanism = 307L;
                    cipher = new P11Cipher(token, transformation, mechanism, _p);
                    break block11;
                }
                if (transformation.startsWith("DES")) {
                    long mechanism = 290L;
                    cipher = new P11Cipher(token, transformation, mechanism, _p);
                    break block11;
                }
                throw new UnsupportedOperationException(transformation);
            }
            catch (PKCS11Exception e) {
                throw new NoSuchAlgorithmException(e);
            }
        }
        return cipher;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final int getBlockSize() {
        try {
            return (Integer)this.spi.getClass().getDeclaredMethod("engineGetBlockSize", new Class[0]).invoke((Object)this.spi, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final int getOutputSize(int inputLen) {
        try {
            return (Integer)this.spi.getClass().getDeclaredMethod("engineGetOutputSize", Integer.TYPE).invoke((Object)this.spi, inputLen);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final byte[] getIV() {
        try {
            return (byte[])this.spi.getClass().getDeclaredMethod("engineGetIV", new Class[0]).invoke((Object)this.spi, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final AlgorithmParameters getParameters() {
        try {
            return (AlgorithmParameters)this.spi.getClass().getDeclaredMethod("engineGetParameters", new Class[0]).invoke((Object)this.spi, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final void init(int opmode, Key key) throws InvalidKeyException {
        block5: {
            try {
                if (key.getAlgorithm().equals("SM2")) {
                    P11SM2Cipher cipher = (P11SM2Cipher)this.spi;
                    cipher.engineInit(opmode, key, null);
                    break block5;
                }
                if (key.getAlgorithm().equals("RSA")) {
                    P11RSACipher cipher = (P11RSACipher)this.spi;
                    cipher.engineInit(opmode, key, null);
                    break block5;
                }
                if (key.getAlgorithm().equals("SM1") || key.getAlgorithm().equals("SM4") || key.getAlgorithm().equals("RC2") || key.getAlgorithm().equals("DES-EDE") || key.getAlgorithm().equals("DES3") || key.getAlgorithm().equalsIgnoreCase("DESEDE") || key.getAlgorithm().equals("DES") || key.getAlgorithm().equals("AES")) {
                    P11Cipher cipher = (P11Cipher)this.spi;
                    cipher.engineInit(opmode, key, null);
                    break block5;
                }
                throw new InvalidKeyException("only support SM2 RSA algorithm!");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public final void init(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.spi.getClass().getDeclaredMethod("engineInit", Integer.TYPE, Key.class, SecureRandom.class).invoke((Object)this.spi, opmode, key, random);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final void init(int opmode, Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        try {
            this.spi.getClass().getDeclaredMethod("engineInit", Integer.TYPE, Key.class, AlgorithmParameterSpec.class, SecureRandom.class).invoke((Object)this.spi, opmode, key, params, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final void init(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        try {
            this.spi.getClass().getDeclaredMethod("engineInit", Integer.TYPE, Key.class, AlgorithmParameterSpec.class, SecureRandom.class).invoke((Object)this.spi, opmode, key, params, random);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final void init(int opmode, Key key, AlgorithmParameters params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(opmode, key, params, null);
    }

    public final void init(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        try {
            this.spi.getClass().getDeclaredMethod("engineInit", Integer.TYPE, Key.class, AlgorithmParameterSpec.class, SecureRandom.class).invoke((Object)this.spi, opmode, key, params, random);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final void init(int opmode, Certificate certificate) throws InvalidKeyException {
        this.init(opmode, certificate, null);
    }

    public final void init(int opmode, Certificate certificate, SecureRandom random) throws InvalidKeyException {
        boolean[] keyUsageInfo;
        X509Certificate cert;
        Set<String> critSet;
        if (certificate instanceof X509Certificate && (critSet = (cert = (X509Certificate)certificate).getCriticalExtensionOIDs()) != null && !critSet.isEmpty() && critSet.contains(KEY_USAGE_EXTENSION_OID) && (keyUsageInfo = cert.getKeyUsage()) != null && (opmode == 1 && keyUsageInfo.length > 3 && !keyUsageInfo[3] || opmode == 3 && keyUsageInfo.length > 2 && !keyUsageInfo[2])) {
            throw new InvalidKeyException("Wrong key usage");
        }
        PublicKey publicKey = certificate == null ? null : certificate.getPublicKey();
        try {
            this.spi.getClass().getDeclaredMethod("engineInit", Integer.TYPE, Key.class, SecureRandom.class).invoke((Object)this.spi, opmode, publicKey, random);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final byte[] update(byte[] input) {
        if (input == null) {
            throw new IllegalArgumentException("Null input buffer");
        }
        if (input.length == 0) {
            return null;
        }
        try {
            return (byte[])this.spi.getClass().getDeclaredMethod("engineUpdate", byte[].class, Integer.TYPE, Integer.TYPE).invoke((Object)this.spi, input, 0, input.length);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final byte[] update(byte[] input, int inputOffset, int inputLen) {
        if (input == null || inputOffset < 0 || inputLen > input.length - inputOffset || inputLen < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        if (inputLen == 0) {
            return null;
        }
        try {
            return (byte[])this.spi.getClass().getDeclaredMethod("engineUpdate", byte[].class, Integer.TYPE, Integer.TYPE).invoke((Object)this.spi, input, inputOffset, inputLen);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final int update(byte[] input, int inputOffset, int inputLen, byte[] output) throws ShortBufferException {
        if (input == null || inputOffset < 0 || inputLen > input.length - inputOffset || inputLen < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        if (inputLen == 0) {
            return 0;
        }
        try {
            return (Integer)this.spi.getClass().getDeclaredMethod("engineUpdate", byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE).invoke((Object)this.spi, input, inputOffset, inputLen, output, 0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final int update(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        if (input == null || inputOffset < 0 || inputLen > input.length - inputOffset || inputLen < 0 || outputOffset < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        if (inputLen == 0) {
            return 0;
        }
        try {
            return (Integer)this.spi.getClass().getDeclaredMethod("engineUpdate", byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE).invoke((Object)this.spi, input, inputOffset, inputLen, output, outputOffset);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final byte[] doFinal() throws IllegalBlockSizeException, BadPaddingException {
        try {
            return (byte[])this.spi.getClass().getDeclaredMethod("engineDoFinal", byte[].class, Integer.TYPE, Integer.TYPE).invoke((Object)this.spi, new byte[0], 0, 0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final int doFinal(byte[] output, int outputOffset) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        if (output == null || outputOffset < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        try {
            return (Integer)this.spi.getClass().getDeclaredMethod("engineDoFinal", byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE).invoke((Object)this.spi, new byte[0], 0, 0, output, outputOffset);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final byte[] doFinal(byte[] input) throws IllegalBlockSizeException, BadPaddingException {
        if (input == null) {
            throw new IllegalArgumentException("Null input buffer");
        }
        try {
            return (byte[])this.spi.getClass().getDeclaredMethod("engineDoFinal", byte[].class, Integer.TYPE, Integer.TYPE).invoke((Object)this.spi, input, 0, input.length);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final byte[] doFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        if (input == null || inputOffset < 0 || inputLen > input.length - inputOffset || inputLen < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        try {
            return (byte[])this.spi.getClass().getDeclaredMethod("engineDoFinal", byte[].class, Integer.TYPE, Integer.TYPE).invoke((Object)this.spi, input, inputOffset, inputLen);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final int doFinal(byte[] input, int inputOffset, int inputLen, byte[] output) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (input == null || inputOffset < 0 || inputLen > input.length - inputOffset || inputLen < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        try {
            return (Integer)this.spi.getClass().getDeclaredMethod("engineDoFinal", byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE).invoke((Object)this.spi, input, inputOffset, inputLen, output, 0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final int doFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (input == null || inputOffset < 0 || inputLen > input.length - inputOffset || inputLen < 0 || outputOffset < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        try {
            return (Integer)this.spi.getClass().getDeclaredMethod("engineDoFinal", byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE).invoke((Object)this.spi, input, inputOffset, inputLen, output, outputOffset);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class PKCS5Padding
    implements Padding {
        private final int blockSize;

        PKCS5Padding(int blockSize) throws NoSuchPaddingException {
            if (blockSize == 0) {
                throw new NoSuchPaddingException("PKCS#5 padding not supported with stream ciphers");
            }
            this.blockSize = blockSize;
        }

        @Override
        public int setPaddingBytes(byte[] paddingBuffer, int padLen) {
            Arrays.fill(paddingBuffer, 0, padLen, (byte)(padLen & 0x7F));
            return padLen;
        }

        @Override
        public int setPaddingBytes(byte[] paddingBuffer, int padBufferLen, int padLen) {
            Arrays.fill(paddingBuffer, padBufferLen, padLen + padBufferLen, (byte)(padLen & 0x7F));
            return padLen;
        }

        @Override
        public int unpad(byte[] paddedData, int len) throws BadPaddingException, IllegalBlockSizeException {
            int padStartIndex;
            if (len < 1 || len % this.blockSize != 0) {
                throw new IllegalBlockSizeException("Input length must be multiples of " + this.blockSize);
            }
            byte padValue = paddedData[len - 1];
            if (padValue < 1 || padValue > this.blockSize) {
                throw new BadPaddingException("Invalid pad value!");
            }
            for (int i = padStartIndex = len - padValue; i < len; ++i) {
                if (paddedData[i] == padValue) continue;
                throw new BadPaddingException("Invalid pad bytes!");
            }
            return padValue;
        }
    }

    private static interface Padding {
        public int setPaddingBytes(byte[] var1, int var2);

        public int setPaddingBytes(byte[] var1, int var2, int var3);

        public int unpad(byte[] var1, int var2) throws BadPaddingException, IllegalBlockSizeException;
    }
}

