/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.pkcs11;

import cn.topca.security.ec.ECParameters;
import cn.topca.security.ec.NamedCurve;
import cn.topca.security.pkcs11.P11Key;
import cn.topca.security.pkcs11.P11KeyFactory;
import cn.topca.security.pkcs11.Session;
import cn.topca.security.pkcs11.Token;
import cn.topca.security.pkcs11.jna.CK_ATTRIBUTE;
import cn.topca.security.pkcs11.jna.PKCS11Exception;
import cn.topca.security.sm.SM2KeyFactory;
import cn.topca.security.sm.SM2PrivateKey;
import cn.topca.security.sm.SM2PublicKey;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Hex;

public final class P11SM2KeyFactory
extends P11KeyFactory {
    static final ECParameterSpec sm2Curve = NamedCurve.getECParameterSpec("SM2");
    private KeyFactory keyFactory;

    P11SM2KeyFactory(Token token, String algorithm) {
        super(token, algorithm);
    }

    @Override
    PublicKey implTranslatePublicKey(PublicKey key) throws InvalidKeyException {
        try {
            if (key instanceof ECPublicKey) {
                ECPublicKey sm2Key = (ECPublicKey)key;
                return this.generatePublic(sm2Key.getW(), sm2Key.getParams());
            }
            if ("X.509".equals(key.getFormat())) {
                byte[] encoded = key.getEncoded();
                key = new SM2PublicKey(encoded);
                return this.implTranslatePublicKey(key);
            }
            throw new InvalidKeyException("PublicKey must be instance of ECPublicKey or have X.509 encoding");
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeyException("Could not create EC public key", e);
        }
    }

    @Override
    PrivateKey implTranslatePrivateKey(PrivateKey key) throws InvalidKeyException {
        try {
            if (key instanceof ECPrivateKey) {
                ECPrivateKey ecKey = (ECPrivateKey)key;
                return this.generatePrivate(ecKey.getS(), ecKey.getParams());
            }
            if ("PKCS#8".equals(key.getFormat())) {
                byte[] encoded = key.getEncoded();
                key = new SM2PrivateKey(encoded);
                return this.implTranslatePrivateKey(key);
            }
            throw new InvalidKeyException("PrivateKey must be instance of ECPrivateKey or have PKCS#8 encoding");
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeyException("Could not create EC private key", e);
        }
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        this.token.ensureValid();
        if (keySpec instanceof X509EncodedKeySpec) {
            try {
                byte[] encoded = ((X509EncodedKeySpec)keySpec).getEncoded();
                SM2PublicKey key = new SM2PublicKey(encoded);
                return this.implTranslatePublicKey(key);
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeySpecException("Could not create EC public key", e);
            }
        }
        if (!(keySpec instanceof ECPublicKeySpec)) {
            throw new InvalidKeySpecException("Only ECPublicKeySpec and X509EncodedKeySpec supported for EC public keys");
        }
        try {
            ECPublicKeySpec ec = (ECPublicKeySpec)keySpec;
            return this.generatePublic(ec.getW(), ec.getParams());
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeySpecException("Could not create EC public key", e);
        }
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        this.token.ensureValid();
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                byte[] encoded = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
                SM2PrivateKey key = new SM2PrivateKey(encoded);
                return this.implTranslatePrivateKey(key);
            }
            catch (GeneralSecurityException e) {
                throw new InvalidKeySpecException("Could not create EC private key", e);
            }
        }
        if (!(keySpec instanceof ECPrivateKeySpec)) {
            throw new InvalidKeySpecException("Only ECPrivateKeySpec and PKCS8EncodedKeySpec supported for EC private keys");
        }
        try {
            ECPrivateKeySpec ec = (ECPrivateKeySpec)keySpec;
            return this.generatePrivate(ec.getS(), ec.getParams());
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeySpecException("Could not create EC private key", e);
        }
    }

    PublicKey generatePublic(ECPoint point, ECParameterSpec params) throws PKCS11Exception {
        if (params != null && !params.equals(sm2Curve)) {
            throw new IllegalArgumentException("need SM2 params, but " + Hex.encodeHexString(ECParameters.encodeParameters(params)));
        }
        byte[] encodedPoint = P11SM2KeyFactory.convertTo64BitPublicKeyPoint(point);
        long CKK_SM2 = this.token.config.getSMConstants().CKK_SM2;
        CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(256L, CKK_SM2), new CK_ATTRIBUTE(385L, encodedPoint), new CK_ATTRIBUTE(384L, P11SM2KeyFactory.encodeParameters())};
        attributes = this.token.getAttributes("import", 2L, CKK_SM2, attributes);
        Session session = null;
        try {
            session = this.token.getObjSession();
            long pkHandle = this.token.p11.C_CreateObject(session.id(), attributes);
            return P11Key.publicKey(session, pkHandle, "SM2", 256, attributes);
        }
        catch (Exception e) {
            if (e.getMessage().equals("CKR_FUNCTION_NOT_SUPPORTED")) {
                ECPublicKeySpec ecPrivateKeySpec = new ECPublicKeySpec(point, params);
                try {
                    if (this.keyFactory == null) {
                        this.keyFactory = KeyFactory.getInstance("SM2");
                    }
                    return this.keyFactory.generatePublic(ecPrivateKeySpec);
                }
                catch (InvalidKeySpecException e1) {
                    e1.printStackTrace();
                }
                catch (NoSuchAlgorithmException e1) {
                    e1.printStackTrace();
                }
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    PrivateKey generatePrivate(BigInteger s, ECParameterSpec params) throws PKCS11Exception {
        if (params != null && !params.equals(sm2Curve)) {
            throw new IllegalArgumentException("need SM2 params, but " + Hex.encodeHexString(ECParameters.encodeParameters(params)));
        }
        byte[] ckaValue = new byte[32];
        System.arraycopy(s.toByteArray(), s.toByteArray().length - 32, ckaValue, 0, 32);
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        digest.update(s.toByteArray());
        byte[] sHash = digest.digest();
        CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L, new BigInteger(1, sHash)), new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(256L, this.token.config.getSMConstants().CKK_SM2), new CK_ATTRIBUTE(3L, "userPrivateSM2"), new CK_ATTRIBUTE(1L, false), new CK_ATTRIBUTE(261L, true), new CK_ATTRIBUTE(264L, true), new CK_ATTRIBUTE(259L, false), new CK_ATTRIBUTE(17L, ckaValue), new CK_ATTRIBUTE(384L, P11SM2KeyFactory.encodeParameters())};
        attributes = this.token.getAttributes("import", 3L, this.token.config.getSMConstants().CKK_SM2, attributes);
        Session session = null;
        try {
            session = this.token.getOpSession();
            long keyID = this.token.p11.C_CreateObject(session.id(), attributes);
            PrivateKey privateKey = P11Key.privateKey(session, keyID, "SM2", 256, attributes);
            return privateKey;
        }
        catch (Exception e) {
            if (e.getMessage().equals("CKR_FUNCTION_NOT_SUPPORTED")) {
                ECPrivateKeySpec ecPrivateKeySpec = new ECPrivateKeySpec(s, params);
                try {
                    if (this.keyFactory == null) {
                        this.keyFactory = KeyFactory.getInstance("SM2");
                    }
                    PrivateKey privateKey = this.keyFactory.generatePrivate(ecPrivateKeySpec);
                    return privateKey;
                }
                catch (Exception e1) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            e.printStackTrace();
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            if (session != null) {
                this.token.releaseSession(session);
            }
        }
    }

    @Override
    KeySpec implGetPublicKeySpec(P11Key key, Class keySpec, Session[] session) throws PKCS11Exception, InvalidKeySpecException {
        if (ECPublicKeySpec.class.isAssignableFrom(keySpec)) {
            session[0] = this.token.getObjSession();
            CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(385L)};
            this.token.p11.C_GetAttributeValue(session[0].id(), key.keyID, attributes);
            try {
                ECPoint point = ECParameters.decodePoint(attributes[0].getByteArray(), sm2Curve.getCurve());
                return new ECPublicKeySpec(point, sm2Curve);
            }
            catch (IOException e) {
                throw new InvalidKeySpecException("Could not parse key", e);
            }
        }
        throw new InvalidKeySpecException("Only ECPublicKeySpec and X509EncodedKeySpec supported for EC public keys");
    }

    @Override
    KeySpec implGetPrivateKeySpec(P11Key key, Class keySpec, Session[] session) throws PKCS11Exception, InvalidKeySpecException {
        if (ECPrivateKeySpec.class.isAssignableFrom(keySpec)) {
            session[0] = this.token.getObjSession();
            CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
            this.token.p11.C_GetAttributeValue(session[0].id(), key.keyID, attributes);
            return new ECPrivateKeySpec(attributes[0].getBigInteger(), sm2Curve);
        }
        throw new InvalidKeySpecException("Only ECPrivateKeySpec and PKCS8EncodedKeySpec supported for EC private keys");
    }

    @Override
    KeyFactory implGetSoftwareFactory() throws GeneralSecurityException {
        return SM2KeyFactory.INSTANCE;
    }

    static byte[] encodeParameters() {
        return ECParameters.encodeParameters(sm2Curve);
    }

    private static byte[] convertTo64BitPublicKeyPoint(ECPoint publicKeyPoint) {
        byte[] point = new byte[64];
        byte[] _t = publicKeyPoint.getAffineX().toByteArray();
        _t = P11SM2KeyFactory.fillFull(_t, 32);
        System.arraycopy(_t, _t.length - 32, point, 0, 32);
        _t = publicKeyPoint.getAffineY().toByteArray();
        _t = P11SM2KeyFactory.fillFull(_t, 32);
        System.arraycopy(_t, _t.length - 32, point, 32, 32);
        return point;
    }

    private static byte[] fillFull(byte[] b, int len) {
        if (b.length < len) {
            int n = len - b.length;
            byte[] b2 = new byte[len];
            System.arraycopy(b, 0, b2, n, b.length);
            for (int i = 0; i < n; ++i) {
                b2[i] = 0;
            }
            return b2;
        }
        return b;
    }
}

