/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.pkcs11;

import cn.topca.security.pkcs11.P11Key;
import cn.topca.security.pkcs11.P11KeyFactory;
import cn.topca.security.pkcs11.P11Util;
import cn.topca.security.pkcs11.Session;
import cn.topca.security.pkcs11.Token;
import cn.topca.security.pkcs11.jna.CK_MECHANISM;
import cn.topca.security.pkcs11.jna.PKCS11Exception;
import cn.topca.security.rsa.RSAPadding;
import cn.topca.security.util.DerInputStream;
import cn.topca.security.util.DerOutputStream;
import cn.topca.security.util.DerValue;
import cn.topca.security.util.ObjectIdentifier;
import cn.topca.security.x509.AlgorithmId;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAKey;
import org.apache.commons.codec.binary.Hex;

final class P11Signature
extends SignatureSpi {
    private final Token token;
    private final String algorithm;
    private final String keyAlgorithm;
    private final long mechanism;
    private final ObjectIdentifier digestOID;
    private final int type;
    private P11Key p11Key;
    private final MessageDigest md;
    private Session session;
    private int mode;
    private boolean initialized;
    private final byte[] buffer;
    private int bytesProcessed;
    private static final int M_SIGN = 1;
    private static final int M_VERIFY = 2;
    private static final int T_DIGEST = 1;
    private static final int T_UPDATE = 2;
    private static final int T_RAW = 3;
    private static final int RAW_ECDSA_MAX = 128;
    private static final int RAW_SM2_MAX = 32;

    P11Signature(Token token, String algorithm, long mechanism) throws NoSuchAlgorithmException, PKCS11Exception {
        this.token = token;
        this.algorithm = algorithm;
        this.mechanism = mechanism;
        byte[] buffer = null;
        ObjectIdentifier digestOID = null;
        MessageDigest md = null;
        switch ((int)mechanism) {
            case 4: 
            case 5: 
            case 6: 
            case 64: 
            case 65: 
            case 66: {
                this.keyAlgorithm = "RSA";
                this.type = 2;
                buffer = new byte[1];
                break;
            }
            case 18: {
                this.keyAlgorithm = "DSA";
                this.type = 2;
                buffer = new byte[1];
                break;
            }
            case 4162: {
                this.keyAlgorithm = "EC";
                this.type = 2;
                buffer = new byte[1];
                break;
            }
            case 17: {
                this.keyAlgorithm = "DSA";
                if (algorithm.equals("DSA")) {
                    this.type = 1;
                    md = MessageDigest.getInstance("SHA-1");
                    break;
                }
                if (algorithm.equals("RawDSA")) {
                    this.type = 3;
                    buffer = new byte[20];
                    break;
                }
                throw new ProviderException(algorithm);
            }
            case 4161: {
                String digestAlg;
                this.keyAlgorithm = "EC";
                if (algorithm.equals("NONEwithECDSA")) {
                    this.type = 3;
                    buffer = new byte[128];
                    break;
                }
                if (algorithm.equals("SHA1withECDSA")) {
                    digestAlg = "SHA-1";
                } else if (algorithm.equals("SHA256withECDSA")) {
                    digestAlg = "SHA-256";
                } else if (algorithm.equals("SHA384withECDSA")) {
                    digestAlg = "SHA-384";
                } else if (algorithm.equals("SHA512withECDSA")) {
                    digestAlg = "SHA-512";
                } else {
                    throw new ProviderException(algorithm);
                }
                this.type = 1;
                md = MessageDigest.getInstance(digestAlg);
                break;
            }
            case 1: 
            case 3: {
                this.keyAlgorithm = "RSA";
                this.type = 1;
                if (algorithm.equals("MD5withRSA")) {
                    md = MessageDigest.getInstance("MD5");
                    digestOID = AlgorithmId.MD5_oid;
                    break;
                }
                if (algorithm.equals("SHA1withRSA")) {
                    md = MessageDigest.getInstance("SHA-1");
                    digestOID = AlgorithmId.SHA_oid;
                    break;
                }
                if (algorithm.equals("MD2withRSA")) {
                    md = MessageDigest.getInstance("MD2");
                    digestOID = AlgorithmId.MD2_oid;
                    break;
                }
                if (algorithm.equals("SHA256withRSA")) {
                    md = MessageDigest.getInstance("SHA-256");
                    digestOID = AlgorithmId.SHA256_oid;
                    break;
                }
                if (algorithm.equals("SHA384withRSA")) {
                    md = MessageDigest.getInstance("SHA-384");
                    digestOID = AlgorithmId.SHA384_oid;
                    break;
                }
                if (algorithm.equals("SHA512withRSA")) {
                    md = MessageDigest.getInstance("SHA-512");
                    digestOID = AlgorithmId.SHA512_oid;
                    break;
                }
                throw new ProviderException("Unknown signature: " + algorithm);
            }
            default: {
                if (mechanism == token.config.getSMConstants().CKM_SM3_SM2 && algorithm.equals("SM3withSM2")) {
                    this.keyAlgorithm = "SM2";
                    this.type = 2;
                    buffer = new byte[1];
                    break;
                }
                throw new ProviderException("Unknown mechanism: " + mechanism);
            }
        }
        this.buffer = buffer;
        this.digestOID = digestOID;
        this.md = md;
    }

    private void ensureInitialized() {
        this.token.ensureValid();
        if (!this.initialized) {
            this.initialize();
        }
    }

    private void cancelOperation() {
        this.token.ensureValid();
        if (!this.initialized) {
            return;
        }
        this.initialized = false;
        if (this.session == null || !this.token.explicitCancel) {
            return;
        }
        if (this.mode == 1) {
            try {
                if (this.type == 2) {
                    this.token.p11.C_SignFinal(this.session.id(), 0);
                }
                byte[] digest = this.type == 1 ? this.md.digest() : this.buffer;
                this.token.p11.C_Sign(this.session.id(), digest);
            }
            catch (PKCS11Exception e) {
                throw new ProviderException("cancel failed", e);
            }
        } else {
            try {
                byte[] signature = this.keyAlgorithm.equals("DSA") ? new byte[40] : new byte[this.p11Key.keyLength() + 7 >> 3];
                if (this.type == 2) {
                    this.token.p11.C_VerifyFinal(this.session.id(), signature);
                } else {
                    byte[] digest = this.type == 1 ? this.md.digest() : this.buffer;
                    this.token.p11.C_Verify(this.session.id(), digest, signature);
                }
            }
            catch (PKCS11Exception pKCS11Exception) {
                // empty catch block
            }
        }
        if (!this.session.hasObjects()) {
            this.session = this.token.killSession(this.session);
            return;
        }
    }

    private void initialize() {
        try {
            this.session = this.token.getOpSession();
            try {
                if (this.mode == 1) {
                    this.token.p11.C_SignInit(this.session.id(), new CK_MECHANISM(this.mechanism), this.p11Key.keyID);
                } else {
                    this.token.p11.C_VerifyInit(this.session.id(), new CK_MECHANISM(this.mechanism), this.p11Key.keyID);
                }
                this.initialized = true;
            }
            catch (Exception e) {
                this.initialized = false;
                throw new ProviderException("Signature initialized error.", e);
            }
        }
        catch (PKCS11Exception e) {
            throw new ProviderException("Initialization failed", e);
        }
        if (this.bytesProcessed != 0) {
            this.bytesProcessed = 0;
            if (this.md != null) {
                this.md.reset();
            }
        }
    }

    private void checkRSAKeyLength(int len) throws InvalidKeyException {
        int encodedLength;
        RSAPadding padding;
        try {
            padding = RSAPadding.getInstance(1, len + 7 >> 3);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new InvalidKeyException(iape.getMessage());
        }
        int maxDataSize = padding.getMaxDataSize();
        if (this.algorithm.equals("MD5withRSA") || this.algorithm.equals("MD2withRSA")) {
            encodedLength = 34;
        } else if (this.algorithm.equals("SHA1withRSA")) {
            encodedLength = 35;
        } else if (this.algorithm.equals("SHA256withRSA")) {
            encodedLength = 51;
        } else if (this.algorithm.equals("SHA384withRSA")) {
            encodedLength = 67;
        } else if (this.algorithm.equals("SHA512withRSA")) {
            encodedLength = 83;
        } else {
            throw new ProviderException("Unknown signature algo: " + this.algorithm);
        }
        if (encodedLength > maxDataSize) {
            throw new InvalidKeyException("Key is too short for this signature algorithm");
        }
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (publicKey == null) {
            throw new InvalidKeyException("Key must not be null");
        }
        if (this.keyAlgorithm.equals("RSA") && publicKey != this.p11Key) {
            int keyLen;
            if (publicKey instanceof P11Key) {
                keyLen = ((P11Key)((Object)publicKey)).keyLength();
            } else {
                RSAKey rsaKey = (RSAKey)((Object)publicKey);
                keyLen = rsaKey.getModulus().bitLength();
            }
            this.checkRSAKeyLength(keyLen);
        }
        this.cancelOperation();
        this.mode = 2;
        this.p11Key = P11KeyFactory.convertKey(this.token, publicKey, this.keyAlgorithm);
        this.initialize();
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey == null) {
            throw new InvalidKeyException("Key must not be null");
        }
        if (this.keyAlgorithm.equals("RSA") && privateKey != this.p11Key) {
            int keyLen = privateKey instanceof P11Key ? ((P11Key)((Object)privateKey)).keyLength : ((RSAKey)((Object)privateKey)).getModulus().bitLength();
            this.checkRSAKeyLength(keyLen);
        }
        this.cancelOperation();
        this.mode = 1;
        this.p11Key = P11KeyFactory.convertKey(this.token, privateKey, this.keyAlgorithm);
        this.initialize();
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.ensureInitialized();
        switch (this.type) {
            case 2: {
                this.buffer[0] = b;
                this.engineUpdate(this.buffer, 0, 1);
                break;
            }
            case 1: {
                this.md.update(b);
                ++this.bytesProcessed;
                break;
            }
            case 3: {
                if (this.bytesProcessed >= this.buffer.length) {
                    this.bytesProcessed = this.buffer.length + 1;
                    return;
                }
                this.buffer[this.bytesProcessed++] = b;
                break;
            }
            default: {
                throw new ProviderException("Internal error");
            }
        }
    }

    @Override
    protected void engineUpdate(byte[] b, int ofs, int len) throws SignatureException {
        this.ensureInitialized();
        if (len == 0) {
            return;
        }
        switch (this.type) {
            case 2: {
                try {
                    if (this.mode == 1) {
                        this.token.p11.C_SignUpdate(this.session.id(), 0L, b, ofs, len);
                    } else {
                        this.token.p11.C_VerifyUpdate(this.session.id(), 0L, b, ofs, len);
                    }
                    this.bytesProcessed += len;
                    break;
                }
                catch (PKCS11Exception e) {
                    throw new ProviderException(e);
                }
            }
            case 1: {
                this.md.update(b, ofs, len);
                this.bytesProcessed += len;
                break;
            }
            case 3: {
                if (this.bytesProcessed + len > this.buffer.length) {
                    this.bytesProcessed = this.buffer.length + 1;
                    return;
                }
                System.arraycopy(b, ofs, this.buffer, this.bytesProcessed, len);
                this.bytesProcessed += len;
                break;
            }
            default: {
                throw new ProviderException("Internal error");
            }
        }
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        this.ensureInitialized();
        int len = byteBuffer.remaining();
        if (len <= 0) {
            return;
        }
        switch (this.type) {
            case 2: {
                long addr;
                try {
                    Field addressField = byteBuffer.getClass().getField("address");
                    addr = addressField.getLong(byteBuffer);
                }
                catch (Exception e) {
                    super.engineUpdate(byteBuffer);
                    return;
                }
                int ofs = byteBuffer.position();
                try {
                    if (this.mode == 1) {
                        this.token.p11.C_SignUpdate(this.session.id(), addr + (long)ofs, null, 0, len);
                    } else {
                        this.token.p11.C_VerifyUpdate(this.session.id(), addr + (long)ofs, null, 0, len);
                    }
                    this.bytesProcessed += len;
                    byteBuffer.position(ofs + len);
                    break;
                }
                catch (PKCS11Exception e) {
                    throw new ProviderException("Update failed", e);
                }
            }
            case 1: {
                this.md.update(byteBuffer);
                this.bytesProcessed += len;
                break;
            }
            case 3: {
                if (this.bytesProcessed + len > this.buffer.length) {
                    this.bytesProcessed = this.buffer.length + 1;
                    return;
                }
                byteBuffer.get(this.buffer, this.bytesProcessed, len);
                this.bytesProcessed += len;
                break;
            }
            default: {
                throw new ProviderException("Internal error");
            }
        }
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        this.ensureInitialized();
        try {
            byte[] signature;
            if (this.type == 2) {
                int len = this.keyAlgorithm.equals("DSA") ? 40 : 0;
                signature = this.token.p11.C_SignFinal(this.session.id(), len);
            } else {
                byte[] digest;
                if (this.type == 1) {
                    digest = this.md.digest();
                } else if (this.mechanism == 17L) {
                    if (this.bytesProcessed != this.buffer.length) {
                        throw new SignatureException("Data for RawDSA must be exactly 20 bytes long");
                    }
                    digest = this.buffer;
                } else {
                    if (this.bytesProcessed > this.buffer.length) {
                        throw new SignatureException("Data for NONEwithECDSA must be at most 128 bytes long");
                    }
                    digest = new byte[this.bytesProcessed];
                    System.arraycopy(this.buffer, 0, digest, 0, this.bytesProcessed);
                }
                if (!this.keyAlgorithm.equals("RSA")) {
                    signature = this.token.p11.C_Sign(this.session.id(), digest);
                } else {
                    byte[] data = this.encodeSignature(digest);
                    if (this.mechanism == 3L) {
                        data = this.pkcs1Pad(data);
                    }
                    signature = this.token.p11.C_Sign(this.session.id(), data);
                }
            }
            if (!this.keyAlgorithm.equals("RSA")) {
                byte[] byArray = P11Signature.ecToASN1(signature);
                return byArray;
            }
            byte[] byArray = signature;
            return byArray;
        }
        catch (PKCS11Exception e) {
            throw new ProviderException(e);
        }
        catch (SignatureException e) {
            this.cancelOperation();
            throw e;
        }
        finally {
            this.initialized = false;
            this.session = this.token.releaseSession(this.session);
        }
    }

    @Override
    protected boolean engineVerify(byte[] signature) throws SignatureException {
        this.ensureInitialized();
        try {
            if (this.keyAlgorithm.equals("DSA")) {
                signature = P11Signature.asn1ToDSA(signature);
            } else if (this.keyAlgorithm.equals("EC") || this.keyAlgorithm.equals("SM2")) {
                signature = this.asn1ToEC(signature);
            }
            if (this.type == 2) {
                this.token.p11.C_VerifyFinal(this.session.id(), signature);
            } else {
                byte[] digest;
                if (this.type == 1) {
                    digest = this.md.digest();
                } else if (this.mechanism == 17L) {
                    if (this.bytesProcessed != this.buffer.length) {
                        throw new SignatureException("Data for RawDSA must be exactly 20 bytes long");
                    }
                    digest = this.buffer;
                } else if (this.mechanism == this.token.config.getSMConstants().CKM_SM3_SM2) {
                    if (this.bytesProcessed != this.buffer.length) {
                        throw new SignatureException("Data for NONEwithSM2 must be at most 32 bytes long");
                    }
                    digest = this.buffer;
                } else {
                    if (this.bytesProcessed > this.buffer.length) {
                        throw new SignatureException("Data for NONEwithECDSA must be at most 128 bytes long");
                    }
                    digest = new byte[this.bytesProcessed];
                    System.arraycopy(this.buffer, 0, digest, 0, this.bytesProcessed);
                }
                if (!this.keyAlgorithm.equals("RSA")) {
                    this.token.p11.C_Verify(this.session.id(), digest, signature);
                } else {
                    byte[] data = this.encodeSignature(digest);
                    if (this.mechanism == 3L) {
                        data = this.pkcs1Pad(data);
                    }
                    this.token.p11.C_Verify(this.session.id(), data, signature);
                }
            }
            boolean digest = true;
            return digest;
        }
        catch (SignatureException e) {
            this.cancelOperation();
            throw e;
        }
        catch (PKCS11Exception e) {
            long errorCode = e.getErrorCode();
            if (errorCode == 192L) {
                boolean bl = false;
                return bl;
            }
            if (errorCode == 193L) {
                boolean bl = false;
                return bl;
            }
            if (errorCode == 33L) {
                boolean bl = false;
                return bl;
            }
            throw new ProviderException(e);
        }
        finally {
            this.initialized = false;
            this.session = this.token.releaseSession(this.session);
        }
    }

    private byte[] pkcs1Pad(byte[] data) {
        try {
            int len = this.p11Key.keyLength() + 7 >> 3;
            RSAPadding padding = RSAPadding.getInstance(1, len);
            byte[] padded = padding.pad(data);
            return padded;
        }
        catch (GeneralSecurityException e) {
            throw new ProviderException(e);
        }
    }

    public static byte[] encodeSignature(ObjectIdentifier paramObjectIdentifier, byte[] paramArrayOfByte) throws IOException {
        DerOutputStream localDerOutputStream = new DerOutputStream();
        new AlgorithmId(paramObjectIdentifier).encode(localDerOutputStream);
        localDerOutputStream.putOctetString(paramArrayOfByte);
        DerValue localDerValue = new DerValue(48, localDerOutputStream.toByteArray());
        return localDerValue.toByteArray();
    }

    private byte[] encodeSignature(byte[] digest) throws SignatureException {
        try {
            return P11Signature.encodeSignature(this.digestOID, digest);
        }
        catch (IOException e) {
            throw new SignatureException("Invalid encoding", e);
        }
    }

    private static byte[] ecToASN1(byte[] signature) {
        int n = signature.length >> 1;
        BigInteger r = new BigInteger(1, P11Util.subarray(signature, 0, n));
        BigInteger s = new BigInteger(1, P11Util.subarray(signature, n, n));
        try {
            DerOutputStream outseq = new DerOutputStream();
            outseq.putInteger(r);
            outseq.putInteger(s);
            DerValue result = new DerValue(48, outseq.toByteArray());
            outseq.close();
            return result.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Internal error", e);
        }
    }

    private static byte[] asn1ToDSA(byte[] signature) throws SignatureException {
        try {
            DerInputStream in = new DerInputStream(signature);
            DerValue[] values = in.getSequence(2);
            BigInteger r = values[0].getPositiveBigInteger();
            BigInteger s = values[1].getPositiveBigInteger();
            byte[] br = P11Signature.toByteArray(r, 20);
            byte[] bs = P11Signature.toByteArray(s, 20);
            if (br == null || bs == null) {
                throw new SignatureException("Out of range value for R or S");
            }
            return P11Util.concat(br, bs);
        }
        catch (SignatureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SignatureException("invalid encoding for signature", e);
        }
    }

    private byte[] asn1ToEC(byte[] signature) throws SignatureException {
        try {
            BigInteger r = null;
            BigInteger s = null;
            try {
                DerInputStream dis = new DerInputStream(signature);
                try {
                    DerValue[] values = dis.getSequence(2);
                    r = values[0].getPositiveBigInteger();
                    s = values[1].getPositiveBigInteger();
                }
                catch (Exception e) {
                    dis.reset();
                    r = new BigInteger(1, dis.getBigInteger().toByteArray());
                    s = new BigInteger(1, dis.getBigInteger().toByteArray());
                }
            }
            catch (Exception e) {
                int n = signature.length >> 1;
                r = new BigInteger(1, P11Util.subarray(signature, 0, n));
                s = new BigInteger(1, P11Util.subarray(signature, n, n));
            }
            if (r == null || s == null) {
                throw new SignatureException("Parsing signature failed! " + Hex.encodeHexString(signature));
            }
            byte[] br = P11Util.trimZeroes(r.toByteArray());
            byte[] bs = P11Util.trimZeroes(s.toByteArray());
            int k = Math.max(br.length, bs.length);
            byte[] res = new byte[k << 1];
            System.arraycopy(br, 0, res, k - br.length, br.length);
            System.arraycopy(bs, 0, res, res.length - bs.length, bs.length);
            return res;
        }
        catch (Exception e) {
            throw new SignatureException("invalid encoding for signature", e);
        }
    }

    private static byte[] toByteArray(BigInteger bi, int len) {
        byte[] b = bi.toByteArray();
        int n = b.length;
        if (n == len) {
            return b;
        }
        if (n == len + 1 && b[0] == 0) {
            byte[] t = new byte[len];
            System.arraycopy(b, 1, t, 0, len);
            return t;
        }
        if (n > len) {
            return null;
        }
        byte[] t = new byte[len];
        System.arraycopy(b, 0, t, len - n, n);
        return t;
    }

    @Override
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
    }

    @Override
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        return null;
    }
}

