/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.pkcs11;

import cn.topca.security.pkcs11.P11Key;
import cn.topca.security.pkcs11.Session;
import cn.topca.security.pkcs11.jna.PKCS11Exception;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

final class SessionKeyRef
extends PhantomReference<P11Key>
implements Comparable<SessionKeyRef> {
    private static ReferenceQueue<P11Key> refQueue = new ReferenceQueue();
    private static Set<SessionKeyRef> refList = Collections.synchronizedSortedSet(new TreeSet());
    private long keyID;
    private Session session;

    static ReferenceQueue<P11Key> referenceQueue() {
        return refQueue;
    }

    private static void drainRefQueueBounded() {
        SessionKeyRef next;
        while ((next = (SessionKeyRef)refQueue.poll()) != null) {
            next.dispose();
        }
    }

    SessionKeyRef(P11Key key, long keyID, Session session) {
        super(key, refQueue);
        this.keyID = keyID;
        this.session = session;
        this.session.addObject();
        refList.add(this);
        SessionKeyRef.drainRefQueueBounded();
    }

    private void dispose() {
        refList.remove(this);
        if (this.session.token.isValid()) {
            Session newSession = null;
            try {
                newSession = this.session.token.getOpSession();
            }
            catch (PKCS11Exception pKCS11Exception) {
            }
            finally {
                this.clear();
                this.session.token.releaseSession(newSession);
                this.session.removeObject();
            }
        }
    }

    @Override
    public int compareTo(SessionKeyRef other) {
        if (this.keyID == other.keyID) {
            return 0;
        }
        return this.keyID < other.keyID ? -1 : 1;
    }
}

