/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.pkcs11;

import cn.topca.security.pkcs11.jna.CK_ATTRIBUTE;
import cn.topca.security.pkcs11.jna.Functions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class TemplateManager {
    private static final boolean DEBUG = false;
    static final String O_ANY = "*";
    static final String O_IMPORT = "import";
    static final String O_GENERATE = "generate";
    private final List<KeyAndTemplate> primitiveTemplates = new ArrayList<KeyAndTemplate>();
    private final Map<TemplateKey, Template> compositeTemplates = new ConcurrentHashMap<TemplateKey, Template>();

    TemplateManager() {
    }

    void addTemplate(String op, long objectClass, long keyAlgorithm, CK_ATTRIBUTE[] attrs) {
        TemplateKey key = new TemplateKey(op, objectClass, keyAlgorithm);
        Template template = new Template(attrs);
        this.primitiveTemplates.add(new KeyAndTemplate(key, template));
    }

    private Template getTemplate(TemplateKey key) {
        Template template = this.compositeTemplates.get(key);
        if (template == null) {
            template = this.buildCompositeTemplate(key);
            this.compositeTemplates.put(key, template);
        }
        return template;
    }

    CK_ATTRIBUTE[] getAttributes(String op, long type, long alg, CK_ATTRIBUTE[] attrs) {
        TemplateKey key = new TemplateKey(op, type, alg);
        Template template = this.getTemplate(key);
        CK_ATTRIBUTE[] newAttrs = template.getAttributes(attrs);
        return newAttrs;
    }

    private Template buildCompositeTemplate(TemplateKey key) {
        Template comp = new Template();
        for (KeyAndTemplate entry : this.primitiveTemplates) {
            if (!entry.key.appliesTo(key)) continue;
            comp.add(entry.template);
        }
        return comp;
    }

    private static final class Template {
        private static final CK_ATTRIBUTE[] A0 = new CK_ATTRIBUTE[0];
        private CK_ATTRIBUTE[] attributes;

        Template() {
            this.attributes = A0;
        }

        Template(CK_ATTRIBUTE[] attributes) {
            this.attributes = attributes;
        }

        void add(Template template) {
            this.attributes = this.getAttributes(template.attributes);
        }

        CK_ATTRIBUTE[] getAttributes(CK_ATTRIBUTE[] attrs) {
            return Template.combine(this.attributes, attrs);
        }

        private static CK_ATTRIBUTE[] combine(CK_ATTRIBUTE[] attrs1, CK_ATTRIBUTE[] attrs2) {
            ArrayList<CK_ATTRIBUTE> attrs = new ArrayList<CK_ATTRIBUTE>();
            for (CK_ATTRIBUTE attr : attrs1) {
                if (attr.pValue == null) continue;
                attrs.add(attr);
            }
            for (CK_ATTRIBUTE attr2 : attrs2) {
                long type = attr2.type.longValue();
                for (CK_ATTRIBUTE attr1 : attrs1) {
                    if (attr1.type.longValue() != type) continue;
                    attrs.remove((Object)attr1);
                }
                if (attr2.pValue == null) continue;
                attrs.add(attr2);
            }
            return attrs.toArray(A0);
        }

        public String toString() {
            return Arrays.asList(this.attributes).toString();
        }
    }

    private static final class TemplateKey {
        final String operation;
        final long keyType;
        final long keyAlgorithm;

        TemplateKey(String operation, long keyType, long keyAlgorithm) {
            this.operation = operation;
            this.keyType = keyType;
            this.keyAlgorithm = keyAlgorithm;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TemplateKey)) {
                return false;
            }
            TemplateKey other = (TemplateKey)obj;
            boolean match = this.operation.equals(other.operation) && this.keyType == other.keyType && this.keyAlgorithm == other.keyAlgorithm;
            return match;
        }

        public int hashCode() {
            return this.operation.hashCode() + (int)this.keyType + (int)this.keyAlgorithm;
        }

        boolean appliesTo(TemplateKey key) {
            return !(!this.operation.equals(TemplateManager.O_ANY) && !this.operation.equals(key.operation) || this.keyType != 2147483427L && this.keyType != key.keyType || this.keyAlgorithm != 0x7FFFFF22L && this.keyAlgorithm != key.keyAlgorithm);
        }

        public String toString() {
            return "(" + this.operation + "," + Functions.getObjectClassName(this.keyType) + "," + Functions.getKeyName(this.keyAlgorithm) + ")";
        }
    }

    private static class KeyAndTemplate {
        final TemplateKey key;
        final Template template;

        KeyAndTemplate(TemplateKey key, Template template) {
            this.key = key;
            this.template = template;
        }
    }
}

