/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.pkcs11;

import cn.topca.security.ec.ECParameters;
import cn.topca.security.pkcs11.Config;
import cn.topca.security.pkcs11.P11Cipher;
import cn.topca.security.pkcs11.P11Digest;
import cn.topca.security.pkcs11.P11Key;
import cn.topca.security.pkcs11.P11KeyGenerator;
import cn.topca.security.pkcs11.P11KeyPairGenerator;
import cn.topca.security.pkcs11.P11Mac;
import cn.topca.security.pkcs11.P11RSACipher;
import cn.topca.security.pkcs11.P11SM2Cipher;
import cn.topca.security.pkcs11.P11SecretKeyFactory;
import cn.topca.security.pkcs11.P11Signature;
import cn.topca.security.pkcs11.Secmod;
import cn.topca.security.pkcs11.Session;
import cn.topca.security.pkcs11.Token;
import cn.topca.security.pkcs11.jna.CK_C_INITIALIZE_ARGS;
import cn.topca.security.pkcs11.jna.CK_INFO;
import cn.topca.security.pkcs11.jna.CK_MECHANISM_INFO;
import cn.topca.security.pkcs11.jna.CK_SLOT_INFO;
import cn.topca.security.pkcs11.jna.Functions;
import cn.topca.security.pkcs11.jna.PKCS11;
import cn.topca.security.pkcs11.jna.PKCS11Exception;
import cn.topca.security.sm.TopSMProvider;
import cn.topca.security.x509.AlgorithmId;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.AuthProvider;
import java.security.CodeSource;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;
import java.security.SecurityPermission;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TopPKCS11Provider
extends AuthProvider {
    private static final long serialVersionUID = -1354835039035306505L;
    private static final Log log = LogFactory.getLog((String)"TopP11-TopPKCS11Provider");
    private static int dummyConfigId;
    private static Set<String> searchPath;
    protected final PKCS11 p11;
    private final String configName;
    final Config config;
    final long slotID;
    private CallbackHandler pHandler;
    private final Object LOCK_HANDLER = new Object();
    final boolean removable;
    private volatile Token token;
    private TokenPoller poller;
    public Secmod.Module nssModule;
    public boolean nssUseSecmodTrust;
    private static boolean verifiedSelfIntegrity;
    private static volatile boolean integrityVerified;
    private static final Map<Long, List<Descriptor>> descriptors;
    private static final String MD = "MessageDigest";
    private static final String SIG = "Signature";
    private static final String KPG = "KeyPairGenerator";
    private static final String KG = "KeyGenerator";
    private static final String AGP = "AlgorithmParameters";
    private static final String KF = "KeyFactory";
    private static final String SKF = "SecretKeyFactory";
    private static final String CIP = "Cipher";
    private static final String MAC = "Mac";
    private static final String KA = "KeyAgreement";
    private static final String KS = "KeyStore";
    private static final String SR = "SecureRandom";
    private static final String providerPackage = "cn.topca.security.pkcs11.";

    public static void addSearchPath(String libSearchPath) {
        if (searchPath == null) {
            searchPath = new HashSet<String>();
        }
        searchPath.add(libSearchPath);
    }

    Token getToken() {
        return this.token;
    }

    private TopPKCS11Provider() {
        super("TopPKCS11-Dummy", 1.6, "TopPKCS11-Dummy");
        throw new ProviderException("TopPKCS11 requires configuration file argument");
    }

    public TopPKCS11Provider(String configName) {
        this(TopPKCS11Provider.checkNull(configName), null);
    }

    public TopPKCS11Provider(InputStream configStream) {
        this(TopPKCS11Provider.getDummyConfigName(), TopPKCS11Provider.checkNull(configStream));
    }

    private static <T> T checkNull(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    private static synchronized String getDummyConfigName() {
        int id = ++dummyConfigId;
        return "---DummyConfig-" + id + "---";
    }

    private TopPKCS11Provider(String configName, InputStream configStream) {
        super("TopPKCS11-" + Config.getConfig(configName, configStream).getName(), 1.0, Config.getConfig(configName, configStream).getDescription());
        this.configName = configName;
        this.config = Config.removeConfig(configName);
        if (searchPath != null) {
            this.config.addSearchPath(searchPath);
        }
        log.debug((Object)("TopPKCS11 loading " + configName));
        String library = this.config.getLibrary();
        String functionList = this.config.getFunctionList();
        long slotID = this.config.getSlotID();
        int slotListIndex = this.config.getSlotListIndex();
        String P11Digest2 = "cn.topca.security.pkcs11.P11Digest";
        String P11KeyPairGenerator2 = "cn.topca.security.pkcs11.P11KeyPairGenerator";
        String P11SM2KeyFactory2 = "cn.topca.security.pkcs11.P11SM2KeyFactory";
        String P11SM2Cipher2 = "cn.topca.security.pkcs11.P11SM2Cipher";
        String P11Signature2 = "cn.topca.security.pkcs11.P11Signature";
        String P11KeyGenerator2 = "cn.topca.security.pkcs11.P11KeyGenerator";
        String P11Cipher2 = "cn.topca.security.pkcs11.P11Cipher";
        String P11SecretKeyFactory2 = "cn.topca.security.pkcs11.P11SecretKeyFactory";
        long CKM_SM3 = this.config.getSMConstants().CKM_SM3;
        long CKM_SM2_KEY_PAIR_GEN = this.config.getSMConstants().CKM_SM2_KEY_PAIR_GEN;
        long CKM_SM2 = this.config.getSMConstants().CKM_SM2;
        long CKM_SM3_SM2 = this.config.getSMConstants().CKM_SM3_SM2;
        long CKM_SM1_KEY_GEN = this.config.getSMConstants().CKM_SM1_KEY_GEN;
        long CKM_SM4_KEY_GEN = this.config.getSMConstants().CKM_SM4_KEY_GEN;
        long CKM_SM1_CBC = this.config.getSMConstants().CKM_SM1_CBC;
        long CKM_SM1_CBC_PAD = this.config.getSMConstants().CKM_SM1_CBC_PAD;
        long CKM_SM4_CBC = this.config.getSMConstants().CKM_SM4_CBC;
        long CKM_SM4_CBC_PAD = this.config.getSMConstants().CKM_SM4_CBC_PAD;
        long CKM_SM4_ECB = this.config.getSMConstants().CKM_SM4_ECB;
        long CKM_SM4_ECB_PAD = this.config.getSMConstants().CKM_SM4_ECB_PAD;
        long CKM_SM1_ECB = this.config.getSMConstants().CKM_SM1_ECB;
        long CKM_SM1_ECB_PAD = this.config.getSMConstants().CKM_SM1_ECB_PAD;
        TopPKCS11Provider.d(MD, "SM3", P11Digest2, TopPKCS11Provider.s(AlgorithmId.SM3_oid.toString()), TopPKCS11Provider.m(CKM_SM3));
        TopPKCS11Provider.d(KPG, "SM2", P11KeyPairGenerator2, TopPKCS11Provider.s(AlgorithmId.SM2_oid.toString()), TopPKCS11Provider.m(CKM_SM2_KEY_PAIR_GEN));
        TopPKCS11Provider.d(KF, "SM2", P11SM2KeyFactory2, TopPKCS11Provider.s(AlgorithmId.SM2_oid.toString()), TopPKCS11Provider.m(CKM_SM2_KEY_PAIR_GEN, CKM_SM2, CKM_SM3_SM2));
        TopPKCS11Provider.d(AGP, "SM2", "cn.topca.security.sm.SM2Parameters", TopPKCS11Provider.s(AlgorithmId.SM2_oid.toString()), TopPKCS11Provider.m(CKM_SM2_KEY_PAIR_GEN, CKM_SM2, CKM_SM3_SM2));
        TopPKCS11Provider.d(CIP, "SM2", P11SM2Cipher2, TopPKCS11Provider.s(AlgorithmId.SM2_oid.toString()), TopPKCS11Provider.m(CKM_SM2));
        TopPKCS11Provider.d(SIG, "SM3withSM2", P11Signature2, TopPKCS11Provider.s(AlgorithmId.SM3withSM2_oid.toString()), TopPKCS11Provider.m(CKM_SM3_SM2));
        TopPKCS11Provider.d(KG, "SM1", P11KeyGenerator2, TopPKCS11Provider.m(CKM_SM1_KEY_GEN));
        TopPKCS11Provider.d(KG, "SM4", P11KeyGenerator2, TopPKCS11Provider.s("SMS4"), TopPKCS11Provider.m(CKM_SM4_KEY_GEN));
        TopPKCS11Provider.d(KG, "SM4", P11KeyGenerator2, TopPKCS11Provider.s("SM4"), TopPKCS11Provider.m(CKM_SM4_KEY_GEN));
        TopPKCS11Provider.d(SKF, "SM1", P11SecretKeyFactory2, TopPKCS11Provider.m(CKM_SM1_CBC));
        TopPKCS11Provider.d(SKF, "SM4", P11SecretKeyFactory2, TopPKCS11Provider.s("SMS4"), TopPKCS11Provider.m(CKM_SM4_CBC));
        TopPKCS11Provider.d(SKF, "SM4", P11SecretKeyFactory2, TopPKCS11Provider.s("SM4"), TopPKCS11Provider.m(CKM_SM4_CBC));
        TopPKCS11Provider.d(CIP, "SM1", P11Cipher2, TopPKCS11Provider.m(CKM_SM1_CBC_PAD, CKM_SM1_CBC));
        TopPKCS11Provider.d(CIP, "SM4", P11Cipher2, TopPKCS11Provider.m(CKM_SM4_CBC));
        TopPKCS11Provider.d(CIP, "SM1/ECB/NoPadding", P11Cipher2, TopPKCS11Provider.m(CKM_SM1_ECB));
        TopPKCS11Provider.d(CIP, "SM1/CBC/NoPadding", P11Cipher2, TopPKCS11Provider.m(CKM_SM1_CBC));
        TopPKCS11Provider.d(CIP, "SM4/ECB/NoPadding", P11Cipher2, TopPKCS11Provider.m(CKM_SM4_ECB));
        TopPKCS11Provider.d(CIP, "SM4/CBC/NoPadding", P11Cipher2, TopPKCS11Provider.m(CKM_SM4_CBC));
        TopPKCS11Provider.d(CIP, "SM1/ECB/Pkcs5Padding", P11Cipher2, TopPKCS11Provider.m(CKM_SM1_ECB));
        TopPKCS11Provider.d(CIP, "SM1/CBC/Pkcs5Padding", P11Cipher2, TopPKCS11Provider.m(CKM_SM1_CBC));
        TopPKCS11Provider.d(CIP, "SM4/ECB/Pkcs5Padding", P11Cipher2, TopPKCS11Provider.m(CKM_SM4_ECB));
        TopPKCS11Provider.d(CIP, "SM4/CBC/Pkcs5Padding", P11Cipher2, TopPKCS11Provider.m(CKM_SM4_CBC));
        File libraryFile = new File(library);
        if (!libraryFile.getName().equals(library) && !new File(library).isFile()) {
            String msg = "Library " + library + " does not exist";
            if (this.config.getHandleStartupErrors() == 1) {
                throw new ProviderException(msg);
            }
            throw new UnsupportedOperationException(msg);
        }
        try {
            PKCS11 tmpPKCS11;
            log.debug((Object)("Initializing PKCS#11 library " + library));
            CK_C_INITIALIZE_ARGS initArgs = new CK_C_INITIALIZE_ARGS();
            initArgs.flags.setValue(2L);
            try {
                tmpPKCS11 = this.config.getSearchPaths() != null && this.config.getSearchPaths().length > 0 ? PKCS11.getInstance(library, this.config.getSearchPaths(), "C_GetFunctionList", null, false) : PKCS11.getInstance(library, "C_GetFunctionList", null, false);
            }
            catch (PKCS11Exception e) {
                log.debug((Object)("Multi-threaded initialization failed: " + e));
                if (!this.config.getAllowSingleThreadedModules()) {
                    throw e;
                }
                initArgs = null;
                tmpPKCS11 = PKCS11.getInstance(library, functionList, initArgs, this.config.getOmitInitialize());
            }
            this.p11 = tmpPKCS11;
            CK_INFO p11Info = this.p11.C_GetInfo();
            if (p11Info.cryptokiVersion.major < 2) {
                throw new ProviderException("Only PKCS#11 v2.0 and later supported, library version is v" + (Object)((Object)p11Info.cryptokiVersion));
            }
            boolean showInfo = this.config.getShowInfo();
            log.debug((Object)("Information for provider " + this.getName()));
            log.debug((Object)"Library info:");
            log.debug((Object)p11Info.toString());
            if (slotID < 0L || showInfo) {
                long[] slots = this.p11.C_GetSlotList(false);
                log.debug((Object)("All slots: " + TopPKCS11Provider.toString(slots)));
                slots = this.p11.C_GetSlotList(true);
                log.debug((Object)("Slots with tokens: " + TopPKCS11Provider.toString(slots)));
                if (slotID < 0L) {
                    if (slotListIndex < 0 || slotListIndex >= slots.length) {
                        throw new ProviderException("slotListIndex is " + slotListIndex + " but token only has " + slots.length + " slots");
                    }
                    slotID = slots[slotListIndex];
                }
            }
            this.slotID = slotID;
            CK_SLOT_INFO slotInfo = this.p11.C_GetSlotInfo(slotID);
            this.removable = (slotInfo.flags.longValue() & 2L) != 0L;
            this.initToken(slotInfo);
            if (this.nssModule != null) {
                this.nssModule.setProvider(this);
            }
        }
        catch (Exception e) {
            if (this.config.getHandleStartupErrors() == 2) {
                throw new UnsupportedOperationException("Initialization failed", e);
            }
            throw new ProviderException("Initialization failed", e);
        }
    }

    private static String toString(long[] longs) {
        if (longs.length == 0) {
            return "(none)";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(longs[0]);
        for (int i = 1; i < longs.length; ++i) {
            sb.append(", ");
            sb.append(longs[i]);
        }
        return sb.toString();
    }

    static void verifySelfIntegrity(Class c) {
        if (integrityVerified) {
            return;
        }
        TopPKCS11Provider.doVerifySelfIntegrity(c);
    }

    private static synchronized void doVerifySelfIntegrity(Class c) {
        integrityVerified = JarVerifier.verify(c);
        if (!integrityVerified) {
            throw new ProviderException("The TopPKCS11 provider may have been tampered with.");
        }
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    private static String[] s(String s1) {
        return new String[]{s1};
    }

    private static String[] s(String s1, String s2) {
        return new String[]{s1, s2};
    }

    private static long[] m(long m1) {
        return new long[]{m1};
    }

    private static long[] m(long m1, long m2) {
        return new long[]{m1, m2};
    }

    private static long[] m(long m1, long m2, long m3) {
        return new long[]{m1, m2, m3};
    }

    private static long[] m(long m1, long m2, long m3, long m4) {
        return new long[]{m1, m2, m3, m4};
    }

    private static void d(String type, String algorithm, String className, long[] m) {
        TopPKCS11Provider.register(new Descriptor(type, algorithm, className, null, m));
    }

    private static void d(String type, String algorithm, String className, String[] aliases, long[] m) {
        TopPKCS11Provider.register(new Descriptor(type, algorithm, className, aliases, m));
    }

    private static void register(Descriptor d) {
        for (int i = 0; i < d.mechanisms.length; ++i) {
            long m = d.mechanisms[i];
            Long key = m;
            List<Descriptor> list = descriptors.get(key);
            if (list == null || list.size() == 0) {
                list = new ArrayList<Descriptor>();
                descriptors.put(key, list);
            }
            list.add(d);
        }
    }

    private void createPoller() {
        if (this.poller != null) {
            return;
        }
        TokenPoller poller = new TokenPoller(this);
        Thread t = new Thread((Runnable)poller, "Poller " + this.getName());
        t.setDaemon(true);
        t.setPriority(1);
        t.start();
        this.poller = poller;
    }

    private void destroyPoller() {
        if (this.poller != null) {
            this.poller.disable();
            this.poller = null;
        }
    }

    private boolean hasValidToken() {
        Token token = this.token;
        return token != null && token.isValid();
    }

    synchronized void uninitToken(Token token) {
        if (this.token != token) {
            return;
        }
        this.destroyPoller();
        this.token = null;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                TopPKCS11Provider.this.clear();
                return null;
            }
        });
        this.createPoller();
    }

    private void initToken(CK_SLOT_INFO slotInfo) throws PKCS11Exception {
        if (slotInfo == null) {
            slotInfo = this.p11.C_GetSlotInfo(this.slotID);
        }
        if (this.removable && (slotInfo.flags.longValue() & 1L) == 0L) {
            this.createPoller();
            return;
        }
        this.destroyPoller();
        log.debug((Object)("Slot info for slot " + this.slotID + ":"));
        log.debug((Object)slotInfo.toString());
        final Token token = new Token(this);
        log.debug((Object)("Token info for token in slot " + this.slotID + ":"));
        log.debug((Object)token.tokenInfo.toString());
        long[] supportedMechanisms = this.p11.C_GetMechanismList(this.slotID);
        log.debug((Object)("supportedMechanisms" + Arrays.toString(supportedMechanisms)));
        HashMap<Descriptor, Long> supportedAlgs = new HashMap<Descriptor, Long>();
        for (int i = 0; i < supportedMechanisms.length; ++i) {
            long longMech = supportedMechanisms[i];
            boolean isEnabled = this.config.isEnabled(longMech);
            if (log.isDebugEnabled() && this.config.getShowInfo()) {
                CK_MECHANISM_INFO mechInfo = this.p11.C_GetMechanismInfo(this.slotID, longMech);
                log.debug((Object)("Mechanism " + Functions.getMechanismName(longMech) + ":"));
                if (!isEnabled) {
                    log.debug((Object)"DISABLED in configuration");
                }
                log.debug((Object)mechInfo.toString());
            }
            if (!isEnabled || longMech >>> 32 != 0L) continue;
            long mech = longMech;
            Long integerMech = mech;
            List<Descriptor> ds = descriptors.get(integerMech);
            if (ds == null) {
                for (Long key : descriptors.keySet()) {
                    ds = descriptors.get(key);
                    block2: for (Descriptor d : ds) {
                        Long oldMech = (Long)supportedAlgs.get(d);
                        if (oldMech == null) {
                            supportedAlgs.put(d, integerMech);
                            continue;
                        }
                        long intOldMech = oldMech;
                        for (int j = 0; j < d.mechanisms.length; ++j) {
                            long nextMech = d.mechanisms[j];
                            if (mech == nextMech) {
                                supportedAlgs.put(d, integerMech);
                                continue block2;
                            }
                            if (intOldMech == nextMech) continue block2;
                        }
                    }
                }
                continue;
            }
            block4: for (Descriptor d : ds) {
                Long oldMech = (Long)supportedAlgs.get(d);
                if (oldMech == null) {
                    supportedAlgs.put(d, integerMech);
                    continue;
                }
                long intOldMech = oldMech;
                for (int j = 0; j < d.mechanisms.length; ++j) {
                    long nextMech = d.mechanisms[j];
                    if (mech == nextMech) {
                        supportedAlgs.put(d, integerMech);
                        continue block4;
                    }
                    if (intOldMech == nextMech) continue block4;
                }
            }
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Set keySet = descriptors.keySet();
                for (Long _key : keySet) {
                    List _descriptors = (List)descriptors.get(_key);
                    for (Descriptor d : _descriptors) {
                        long mechanism = _key;
                        P11Service s = d.service(token, mechanism);
                        TopPKCS11Provider.this.putService(s);
                    }
                }
                if ((token.tokenInfo.flags.longValue() & 1L) != 0L && TopPKCS11Provider.this.config.isEnabled(2147483424L) && !token.sessionManager.lowMaxSessions()) {
                    TopPKCS11Provider.this.putService(new P11Service(token, TopPKCS11Provider.SR, "PKCS11", "cn.topca.security.pkcs11.P11SecureRandom", null, 2147483424L));
                }
                if (TopPKCS11Provider.this.config.isEnabled(2147483425L)) {
                    TopPKCS11Provider.this.putService(new P11Service(token, TopPKCS11Provider.KS, "TopPKCS11", "cn.topca.security.pkcs11.P11KeyStore", TopPKCS11Provider.s("PKCS11-" + TopPKCS11Provider.this.config.getName()), 2147483425L));
                }
                return null;
            }
        });
        this.token = token;
    }

    @Override
    public void login(Subject subject, CallbackHandler handler) throws LoginException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            log.debug((Object)"checking login permission");
            sm.checkPermission(new SecurityPermission("authProvider." + this.getName()));
        }
        if (!this.hasValidToken()) {
            throw new LoginException("No token present");
        }
        if ((this.token.tokenInfo.flags.longValue() & 4L) == 0L) {
            log.debug((Object)"login operation not required for token - ignoring login request");
            return;
        }
        try {
            if (this.token.isLoggedInNow(null)) {
                log.debug((Object)"user already logged in");
                return;
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            // empty catch block
        }
        char[] pin = null;
        if ((this.token.tokenInfo.flags.longValue() & 0x100L) == 0L) {
            CallbackHandler myHandler = this.getCallbackHandler(handler);
            if (myHandler == null) {
                throw new LoginException("no password provided, and no callback handler available for retrieving password");
            }
            MessageFormat form = new MessageFormat("PKCS11 Token [providerName] Password: ".replace("providerName", "{0}"));
            Object[] source = new Object[]{this.getName()};
            PasswordCallback pcall = new PasswordCallback(form.format(source), false);
            Callback[] callbacks = new Callback[]{pcall};
            try {
                myHandler.handle(callbacks);
            }
            catch (Exception e) {
                LoginException le = new LoginException("Unable to perform password callback");
                le.initCause(e);
                throw le;
            }
            pin = pcall.getPassword();
            pcall.clearPassword();
            if (pin == null) {
                log.debug((Object)"caller passed NULL pin");
            }
        }
        Session session = null;
        try {
            session = this.token.getOpSession();
            this.p11.C_Login(session.id(), 1L, pin);
            log.debug((Object)"login succeeded");
        }
        catch (PKCS11Exception pe) {
            if (pe.getErrorCode() == 256L) {
                log.debug((Object)"user already logged in");
                return;
            }
            if (pe.getErrorCode() == 160L) {
                FailedLoginException fle = new FailedLoginException();
                fle.initCause(pe);
                throw fle;
            }
            LoginException le = new LoginException();
            le.initCause(pe);
            throw le;
        }
        finally {
            this.token.releaseSession(session);
            if (pin != null) {
                Arrays.fill(pin, ' ');
            }
        }
    }

    @Override
    public void logout() throws LoginException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SecurityPermission("authProvider." + this.getName()));
        }
        if (!this.hasValidToken()) {
            return;
        }
        if ((this.token.tokenInfo.flags.longValue() & 4L) == 0L) {
            log.debug((Object)"logout operation not required for token - ignoring logout request");
            return;
        }
        try {
            if (!this.token.isLoggedInNow(null)) {
                log.debug((Object)"user not logged in");
                return;
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            // empty catch block
        }
        Session session = null;
        try {
            session = this.token.getOpSession();
            this.p11.C_Logout(session.id());
            log.debug((Object)"logout succeeded");
        }
        catch (PKCS11Exception pe) {
            if (pe.getErrorCode() == 257L) {
                log.debug((Object)"user not logged in");
                return;
            }
            LoginException le = new LoginException();
            le.initCause(pe);
            throw le;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    public void disconnect() throws Throwable {
        this.token.p11.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCallbackHandler(CallbackHandler handler) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SecurityPermission("authProvider." + this.getName()));
        }
        Object object = this.LOCK_HANDLER;
        synchronized (object) {
            this.pHandler = handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallbackHandler getCallbackHandler(CallbackHandler handler) {
        if (handler != null) {
            return handler;
        }
        log.debug((Object)"getting provider callback handler");
        Object object = this.LOCK_HANDLER;
        synchronized (object) {
            if (this.pHandler != null) {
                return this.pHandler;
            }
            try {
                CallbackHandler myHandler;
                log.debug((Object)"getting default callback handler");
                this.pHandler = myHandler = AccessController.doPrivileged(new PrivilegedExceptionAction<CallbackHandler>(){

                    @Override
                    public CallbackHandler run() throws Exception {
                        String defaultHandler = Security.getProperty("auth.login.defaultCallbackHandler");
                        if (defaultHandler == null || defaultHandler.length() == 0) {
                            log.debug((Object)"no default handler set");
                            return null;
                        }
                        Class<?> c = Class.forName(defaultHandler, true, Thread.currentThread().getContextClassLoader());
                        return (CallbackHandler)c.newInstance();
                    }
                });
                return myHandler;
            }
            catch (PrivilegedActionException pae) {
                log.debug((Object)"Unable to load default callback handler", (Throwable)pae);
            }
        }
        return null;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new TopPKCS11Rep(this);
    }

    static {
        verifiedSelfIntegrity = false;
        Security.addProvider(new TopSMProvider());
        descriptors = new HashMap<Long, List<Descriptor>>();
        String P11Digest2 = "cn.topca.security.pkcs11.P11Digest";
        String P11MAC = "cn.topca.security.pkcs11.P11MAC";
        String P11KeyPairGenerator2 = "cn.topca.security.pkcs11.P11KeyPairGenerator";
        String P11KeyGenerator2 = "cn.topca.security.pkcs11.P11KeyGenerator";
        String P11RSAKeyFactory2 = "cn.topca.security.pkcs11.P11RSAKeyFactory";
        String P11DSAKeyFactory = "cn.topca.security.pkcs11.P11DSAKeyFactory";
        String P11DHKeyFactory = "cn.topca.security.pkcs11.P11DHKeyFactory";
        String P11ECKeyFactory2 = "cn.topca.security.pkcs11.P11ECKeyFactory";
        String P11KeyAgreement = "cn.topca.security.pkcs11.P11KeyAgreement";
        String P11SecretKeyFactory2 = "cn.topca.security.pkcs11.P11SecretKeyFactory";
        String P11Cipher2 = "cn.topca.security.pkcs11.P11Cipher";
        String P11RSACipher2 = "cn.topca.security.pkcs11.P11RSACipher";
        String P11Signature2 = "cn.topca.security.pkcs11.P11Signature";
        TopPKCS11Provider.d(MD, "MD2", P11Digest2, TopPKCS11Provider.m(512L));
        TopPKCS11Provider.d(MD, "MD5", P11Digest2, TopPKCS11Provider.m(528L));
        TopPKCS11Provider.d(MD, "SHA1", P11Digest2, TopPKCS11Provider.s("SHA", "SHA-1"), TopPKCS11Provider.m(544L));
        TopPKCS11Provider.d(MD, "SHA-256", P11Digest2, TopPKCS11Provider.m(592L));
        TopPKCS11Provider.d(MD, "SHA-384", P11Digest2, TopPKCS11Provider.m(608L));
        TopPKCS11Provider.d(MD, "SHA-512", P11Digest2, TopPKCS11Provider.m(624L));
        TopPKCS11Provider.d(MAC, "HmacMD5", P11MAC, TopPKCS11Provider.m(529L));
        TopPKCS11Provider.d(MAC, "HmacSHA1", P11MAC, TopPKCS11Provider.m(545L));
        TopPKCS11Provider.d(MAC, "HmacSHA256", P11MAC, TopPKCS11Provider.m(593L));
        TopPKCS11Provider.d(MAC, "HmacSHA384", P11MAC, TopPKCS11Provider.m(609L));
        TopPKCS11Provider.d(MAC, "HmacSHA512", P11MAC, TopPKCS11Provider.m(625L));
        TopPKCS11Provider.d(MAC, "SslMacMD5", P11MAC, TopPKCS11Provider.m(896L));
        TopPKCS11Provider.d(MAC, "SslMacSHA1", P11MAC, TopPKCS11Provider.m(897L));
        TopPKCS11Provider.d(KPG, "RSA", P11KeyPairGenerator2, TopPKCS11Provider.m(0L));
        TopPKCS11Provider.d(KPG, "DSA", P11KeyPairGenerator2, TopPKCS11Provider.m(16L));
        TopPKCS11Provider.d(KPG, "DH", P11KeyPairGenerator2, TopPKCS11Provider.s("DiffieHellman"), TopPKCS11Provider.m(32L));
        TopPKCS11Provider.d(KPG, "EC", P11KeyPairGenerator2, TopPKCS11Provider.m(4160L));
        TopPKCS11Provider.d(KG, "ARCFOUR", P11KeyGenerator2, TopPKCS11Provider.s("RC4"), TopPKCS11Provider.m(272L));
        TopPKCS11Provider.d(KG, "DES", P11KeyGenerator2, TopPKCS11Provider.m(288L));
        TopPKCS11Provider.d(KG, "DESede", P11KeyGenerator2, TopPKCS11Provider.m(305L));
        TopPKCS11Provider.d(KG, "AES", P11KeyGenerator2, TopPKCS11Provider.m(4224L));
        TopPKCS11Provider.d(KG, "Blowfish", P11KeyGenerator2, TopPKCS11Provider.m(4240L));
        TopPKCS11Provider.d(KF, "RSA", P11RSAKeyFactory2, TopPKCS11Provider.m(0L, 1L, 3L));
        TopPKCS11Provider.d(KF, "DSA", P11DSAKeyFactory, TopPKCS11Provider.m(16L, 17L, 18L));
        TopPKCS11Provider.d(KF, "DH", P11DHKeyFactory, TopPKCS11Provider.s("DiffieHellman"), TopPKCS11Provider.m(32L, 33L));
        TopPKCS11Provider.d(KF, "EC", P11ECKeyFactory2, TopPKCS11Provider.m(4160L, 4176L, 4161L, 4162L));
        TopPKCS11Provider.d(AGP, "EC", "cn.topca.security.ec.ECParameters", TopPKCS11Provider.s("1.2.840.10045.2.1"), TopPKCS11Provider.m(4160L, 4176L, 4161L, 4162L));
        TopPKCS11Provider.d(KA, "DH", P11KeyAgreement, TopPKCS11Provider.s("DiffieHellman"), TopPKCS11Provider.m(33L));
        TopPKCS11Provider.d(KA, "ECDH", "cn.topca.security.pkcs11.P11ECDHKeyAgreement", TopPKCS11Provider.m(4176L));
        TopPKCS11Provider.d(SKF, "ARCFOUR", P11SecretKeyFactory2, TopPKCS11Provider.s("RC4"), TopPKCS11Provider.m(273L));
        TopPKCS11Provider.d(SKF, "DES", P11SecretKeyFactory2, TopPKCS11Provider.m(290L));
        TopPKCS11Provider.d(SKF, "DESede", P11SecretKeyFactory2, TopPKCS11Provider.m(307L));
        TopPKCS11Provider.d(SKF, "AES", P11SecretKeyFactory2, TopPKCS11Provider.m(4226L));
        TopPKCS11Provider.d(SKF, "Blowfish", P11SecretKeyFactory2, TopPKCS11Provider.m(4241L));
        TopPKCS11Provider.d(CIP, "ARCFOUR", P11Cipher2, TopPKCS11Provider.s("RC4"), TopPKCS11Provider.m(273L));
        TopPKCS11Provider.d(CIP, "DES/CBC/NoPadding", P11Cipher2, TopPKCS11Provider.m(290L));
        TopPKCS11Provider.d(CIP, "DES/CBC/PKCS5Padding", P11Cipher2, TopPKCS11Provider.m(293L, 290L));
        TopPKCS11Provider.d(CIP, "DES/ECB", P11Cipher2, TopPKCS11Provider.s("DES"), TopPKCS11Provider.m(289L));
        TopPKCS11Provider.d(CIP, "DESede/CBC/NoPadding", P11Cipher2, TopPKCS11Provider.m(307L));
        TopPKCS11Provider.d(CIP, "DESede/CBC/PKCS5Padding", P11Cipher2, TopPKCS11Provider.m(310L, 307L));
        TopPKCS11Provider.d(CIP, "DESede/ECB", P11Cipher2, TopPKCS11Provider.s("DESede"), TopPKCS11Provider.m(306L));
        TopPKCS11Provider.d(CIP, "AES/CBC/NoPadding", P11Cipher2, TopPKCS11Provider.m(4226L));
        TopPKCS11Provider.d(CIP, "AES/CBC/PKCS5Padding", P11Cipher2, TopPKCS11Provider.m(4229L, 4226L));
        TopPKCS11Provider.d(CIP, "AES/ECB", P11Cipher2, TopPKCS11Provider.s("AES"), TopPKCS11Provider.m(4225L));
        TopPKCS11Provider.d(CIP, "Blowfish/CBC", P11Cipher2, TopPKCS11Provider.m(4241L));
        TopPKCS11Provider.d(CIP, "RSA/ECB/PKCS1Padding", P11RSACipher2, TopPKCS11Provider.s("RSA"), TopPKCS11Provider.m(1L));
        TopPKCS11Provider.d(CIP, "RSA/ECB/NoPadding", P11RSACipher2, TopPKCS11Provider.m(3L));
        TopPKCS11Provider.d(SIG, "RawDSA", P11Signature2, TopPKCS11Provider.s("NONEwithDSA"), TopPKCS11Provider.m(17L));
        TopPKCS11Provider.d(SIG, "DSA", P11Signature2, TopPKCS11Provider.s("SHA1withDSA"), TopPKCS11Provider.m(18L, 17L));
        TopPKCS11Provider.d(SIG, "NONEwithECDSA", P11Signature2, TopPKCS11Provider.m(4161L));
        TopPKCS11Provider.d(SIG, "SHA1withECDSA", P11Signature2, TopPKCS11Provider.s("ECDSA"), TopPKCS11Provider.m(4162L, 4161L));
        TopPKCS11Provider.d(SIG, "SHA256withECDSA", P11Signature2, TopPKCS11Provider.m(4161L));
        TopPKCS11Provider.d(SIG, "SHA384withECDSA", P11Signature2, TopPKCS11Provider.m(4161L));
        TopPKCS11Provider.d(SIG, "SHA512withECDSA", P11Signature2, TopPKCS11Provider.m(4161L));
        TopPKCS11Provider.d(SIG, "MD2withRSA", P11Signature2, TopPKCS11Provider.m(4L, 1L, 3L));
        TopPKCS11Provider.d(SIG, "MD5withRSA", P11Signature2, TopPKCS11Provider.m(5L, 1L, 3L));
        TopPKCS11Provider.d(SIG, "SHA1withRSA", P11Signature2, TopPKCS11Provider.m(6L, 1L, 3L));
        TopPKCS11Provider.d(SIG, "SHA256withRSA", P11Signature2, TopPKCS11Provider.m(64L, 1L, 3L));
        TopPKCS11Provider.d(SIG, "SHA384withRSA", P11Signature2, TopPKCS11Provider.m(65L, 1L, 3L));
        TopPKCS11Provider.d(SIG, "SHA512withRSA", P11Signature2, TopPKCS11Provider.m(66L, 1L, 3L));
        TopPKCS11Provider.d(KG, "TopTlsRsaPremasterSecret", "cn.topca.security.pkcs11.P11TlsRsaPremasterSecretGenerator", TopPKCS11Provider.m(880L, 884L));
        TopPKCS11Provider.d(KG, "TopTlsMasterSecret", "cn.topca.security.pkcs11.P11TlsMasterSecretGenerator", TopPKCS11Provider.m(881L, 885L, 883L, 887L));
        TopPKCS11Provider.d(KG, "TopTlsKeyMaterial", "cn.topca.security.pkcs11.P11TlsKeyMaterialGenerator", TopPKCS11Provider.m(882L, 886L));
        TopPKCS11Provider.d(KG, "TopTlsPrf", "cn.topca.security.pkcs11.P11TlsPrfGenerator", TopPKCS11Provider.m(888L, 2147484531L));
    }

    static class JarVerifier {
        private static X509Certificate providerCert = null;
        private static final byte[] bytesOfProviderCert = new byte[]{48, -126, 3, -76, 48, -126, 3, 114, -96, 3, 2, 1, 2, 2, 2, 1, 4, 48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0, 48, -127, -112, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 11, 48, 9, 6, 3, 85, 4, 8, 19, 2, 67, 65, 49, 18, 48, 16, 6, 3, 85, 4, 7, 19, 9, 80, 97, 108, 111, 32, 65, 108, 116, 111, 49, 29, 48, 27, 6, 3, 85, 4, 10, 19, 20, 83, 117, 110, 32, 77, 105, 99, 114, 111, 115, 121, 115, 116, 101, 109, 115, 32, 73, 110, 99, 49, 35, 48, 33, 6, 3, 85, 4, 11, 19, 26, 74, 97, 118, 97, 32, 83, 111, 102, 116, 119, 97, 114, 101, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 49, 28, 48, 26, 6, 3, 85, 4, 3, 19, 19, 74, 67, 69, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 32, 67, 65, 48, 30, 23, 13, 48, 49, 49, 48, 49, 57, 50, 51, 48, 52, 51, 49, 90, 23, 13, 48, 54, 49, 48, 50, 51, 50, 51, 48, 52, 51, 49, 90, 48, 99, 49, 29, 48, 27, 6, 3, 85, 4, 10, 12, 20, 83, 117, 110, 32, 77, 105, 99, 114, 111, 115, 121, 115, 116, 101, 109, 115, 32, 73, 110, 99, 49, 35, 48, 33, 6, 3, 85, 4, 11, 12, 26, 74, 97, 118, 97, 32, 83, 111, 102, 116, 119, 97, 114, 101, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 49, 29, 48, 27, 6, 3, 85, 4, 3, 12, 20, 83, 117, 110, 32, 77, 105, 99, 114, 111, 115, 121, 115, 116, 101, 109, 115, 32, 73, 110, 99, 48, -126, 1, -75, 48, -126, 1, 42, 6, 5, 43, 14, 3, 2, 12, 48, -126, 1, 31, 2, -127, -127, 0, -3, 127, 83, -127, 29, 117, 18, 41, 82, -33, 74, -100, 46, -20, -28, -25, -10, 17, -73, 82, 60, -17, 68, 0, -61, 30, 63, -128, -74, 81, 38, 105, 69, 93, 64, 34, 81, -5, 89, 61, -115, 88, -6, -65, -59, -11, -70, 48, -10, -53, -101, 85, 108, -41, -127, 59, -128, 29, 52, 111, -14, 102, 96, -73, 107, -103, 80, -91, -92, -97, -97, -24, 4, 123, 16, 34, -62, 79, -69, -87, -41, -2, -73, -58, 27, -8, 59, 87, -25, -58, -88, -90, 21, 15, 4, -5, -125, -10, -45, -59, 30, -61, 2, 53, 84, 19, 90, 22, -111, 50, -10, 117, -13, -82, 43, 97, -41, 42, -17, -14, 34, 3, 25, -99, -47, 72, 1, -57, 2, 21, 0, -105, 96, 80, -113, 21, 35, 11, -52, -78, -110, -71, -126, -94, -21, -124, 11, -16, 88, 28, -11, 2, -127, -127, 0, -9, -31, -96, -123, -42, -101, 61, -34, -53, -68, -85, 92, 54, -72, 87, -71, 121, -108, -81, -69, -6, 58, -22, -126, -7, 87, 76, 11, 61, 7, -126, 103, 81, 89, 87, -114, -70, -44, 89, 79, -26, 113, 7, 16, -127, -128, -76, 73, 22, 113, 35, -24, 76, 40, 22, 19, -73, -49, 9, 50, -116, -56, -90, -31, 60, 22, 122, -117, 84, 124, -115, 40, -32, -93, -82, 30, 43, -77, -90, 117, -111, 110, -93, 127, 11, -6, 33, 53, 98, -15, -5, 98, 122, 1, 36, 59, -52, -92, -15, -66, -88, 81, -112, -119, -88, -125, -33, -31, 90, -27, -97, 6, -110, -117, 102, 94, -128, 123, 85, 37, 100, 1, 76, 59, -2, -49, 73, 42, 3, -127, -124, 0, 2, -127, -128, 7, -52, -10, 56, 58, -51, -45, 88, -103, -112, 15, 113, -81, -86, -48, 3, 39, 59, 116, -31, 100, 56, 17, -65, -6, -73, -65, 44, -25, -69, -89, -110, 47, 8, -50, 39, -8, -76, -3, -40, 20, 29, -93, -107, -69, 3, 22, -90, -70, -68, 53, -64, -51, -7, -11, 108, -89, -108, 91, 35, 1, -7, -82, -11, -55, -32, -127, 122, -24, -28, 105, -21, -8, -11, -128, 37, 4, 44, -111, 115, -106, 89, -76, 6, -125, 23, -78, 80, -84, 79, -21, -99, 81, 37, 61, -9, -18, -80, 36, 37, 14, -2, -76, 50, -95, -60, 14, -77, 102, 65, -32, 87, -50, -99, -66, 51, 46, -109, -102, -55, 122, 87, -36, -51, -120, 96, -89, -50, -93, -127, -120, 48, -127, -123, 48, 17, 6, 9, 96, -122, 72, 1, -122, -8, 66, 1, 1, 4, 4, 3, 2, 4, 16, 48, 14, 6, 3, 85, 29, 15, 1, 1, -1, 4, 4, 3, 2, 5, -32, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, 85, -115, 31, 42, 5, -85, -101, -50, -122, 16, -82, 59, 93, -10, -70, 63, 34, -59, 106, -54, 48, 31, 6, 3, 85, 29, 35, 4, 24, 48, 22, -128, 20, 101, -30, -12, -122, -55, -45, 78, -16, -111, 78, 88, -94, 106, -11, -40, 120, 90, -102, -63, -90, 48, 32, 6, 3, 85, 29, 17, 4, 25, 48, 23, -127, 21, 121, 117, 45, 99, 104, 105, 110, 103, 46, 112, 101, 110, 103, 64, 115, 117, 110, 46, 99, 111, 109, 48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0, 3, 47, 0, 48, 44, 2, 20, 117, 75, -24, 33, 55, 120, 121, 10, -48, -75, -36, 126, 54, 117, -71, -28, 20, -75, -48, 70, 2, 20, 106, 81, -36, -70, 109, 26, 107, 92, 24, 35, 106, -15, -54, 33, -118, 119, -62, 5, 22, 66};

        JarVerifier() {
        }

        private static JarFile retrieveJarFileFromURL(URL url) throws PrivilegedActionException, MalformedURLException {
            JarFile jf = null;
            final URL jarURL = url.getProtocol().equalsIgnoreCase("jar") ? url : new URL("jar:" + url.toString() + "!/");
            jf = AccessController.doPrivileged(new PrivilegedExceptionAction<JarFile>(){

                @Override
                public JarFile run() throws Exception {
                    JarURLConnection conn = (JarURLConnection)jarURL.openConnection();
                    conn.setUseCaches(false);
                    return conn.getJarFile();
                }
            });
            return jf;
        }

        private static URL getClassURL(final Class<?> clazz) {
            return AccessController.doPrivileged(new PrivilegedAction<URL>(){

                @Override
                public URL run() {
                    CodeSource cs = clazz.getProtectionDomain().getCodeSource();
                    return cs.getLocation();
                }
            });
        }

        private static X509Certificate setupProviderCert() throws IOException, CertificateException {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream inStream = new ByteArrayInputStream(bytesOfProviderCert);
            X509Certificate cert = (X509Certificate)cf.generateCertificate(inStream);
            inStream.close();
            return cert;
        }

        public static final synchronized boolean integrityChecking(Class<?> clazz) {
            try {
                if (providerCert == null) {
                    providerCert = JarVerifier.setupProviderCert();
                }
                return verifiedSelfIntegrity && JarVerifier.verify(clazz);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static boolean verify(Class<?> clazz) {
            URL classURL = JarVerifier.getClassURL(clazz);
            if (classURL == null) {
                return false;
            }
            if (providerCert == null) {
                JarVerifier.integrityChecking(TopPKCS11Provider.class);
                throw new SecurityException("Provider certificate is invalid");
            }
            JarFile jarFile = null;
            try {
                jarFile = JarVerifier.retrieveJarFileFromURL(classURL);
                Vector<JarEntry> entriesVec = new Vector<JarEntry>();
                Manifest man = jarFile.getManifest();
                if (man == null) {
                    throw new SecurityException("The provider is not signed");
                }
                byte[] buffer = new byte[8192];
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    int n;
                    JarEntry je = entries.nextElement();
                    if (je.isDirectory()) continue;
                    entriesVec.addElement(je);
                    InputStream is = jarFile.getInputStream(je);
                    while ((n = is.read(buffer, 0, buffer.length)) != -1) {
                    }
                    is.close();
                }
                Enumeration e = entriesVec.elements();
                while (e.hasMoreElements()) {
                    X509Certificate[] certChain;
                    JarEntry je = (JarEntry)e.nextElement();
                    Certificate[] certs = je.getCertificates();
                    if (certs == null || certs.length == 0) {
                        if (je.getName().startsWith("META-INF")) continue;
                        throw new SecurityException("The provider has unsigned class files.");
                    }
                    int startIndex = 0;
                    boolean signedAsExpected = false;
                    while ((certChain = JarVerifier.getAChain(certs, startIndex)) != null) {
                        if (certChain[0].equals(providerCert)) {
                            signedAsExpected = true;
                            break;
                        }
                        startIndex += certChain.length;
                    }
                    if (signedAsExpected) continue;
                    throw new SecurityException("The provider is not signed by a trusted signer");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return true;
        }

        private static X509Certificate[] getAChain(Certificate[] certs, int startIndex) {
            int i;
            if (startIndex > certs.length - 1) {
                return null;
            }
            for (i = startIndex; i < certs.length - 1 && ((X509Certificate)certs[i + 1]).getSubjectDN().equals(((X509Certificate)certs[i]).getIssuerDN()); ++i) {
            }
            int certChainSize = i - startIndex + 1;
            X509Certificate[] ret = new X509Certificate[certChainSize];
            for (int j = 0; j < certChainSize; ++j) {
                ret[j] = (X509Certificate)certs[startIndex + j];
            }
            return ret;
        }
    }

    private static class TopPKCS11Rep
    implements Serializable {
        static final long serialVersionUID = -2896606995897745419L;
        private final String providerName;
        private final String configName;

        TopPKCS11Rep(TopPKCS11Provider provider) throws NotSerializableException {
            this.providerName = provider.getName();
            this.configName = provider.configName;
            if (Security.getProvider(this.providerName) != provider) {
                throw new NotSerializableException("Only TopPKCS11 providers installed in java.security.Security can be serialized");
            }
        }

        private Object readResolve() throws ObjectStreamException {
            TopPKCS11Provider p = (TopPKCS11Provider)Security.getProvider(this.providerName);
            if (p == null || !p.configName.equals(this.configName)) {
                throw new NotSerializableException("Could not find " + this.providerName + " in installed providers");
            }
            return p;
        }
    }

    private static final class P11Service
    extends Provider.Service {
        private final Token token;
        private final long mechanism;

        P11Service(Token token, String type, String algorithm, String className, String[] al, long mechanism) {
            super(token.provider, type, algorithm, className, P11Service.toList(al), null);
            this.token = token;
            this.mechanism = mechanism & 0xFFFFFFFFL;
        }

        private static List<String> toList(String[] aliases) {
            return aliases == null ? null : Arrays.asList(aliases);
        }

        @Override
        public Object newInstance(Object param) throws NoSuchAlgorithmException {
            if (!this.token.isValid()) {
                throw new NoSuchAlgorithmException("Token has been removed");
            }
            try {
                return this.newInstance0(param);
            }
            catch (PKCS11Exception e) {
                throw new NoSuchAlgorithmException(e);
            }
        }

        public Object newInstance0(Object param) throws PKCS11Exception, NoSuchAlgorithmException {
            String algorithm = this.getAlgorithm();
            String type = this.getType();
            if (type == TopPKCS11Provider.MD) {
                return new P11Digest(this.token, algorithm, this.mechanism);
            }
            if (type.equals(TopPKCS11Provider.KF)) {
                return this.token.getKeyFactory(algorithm);
            }
            if (type.equals(TopPKCS11Provider.KPG)) {
                if (algorithm == "RSA") {
                    return new P11KeyPairGenerator(this.token, algorithm, 0L);
                }
                if (algorithm == "SM2") {
                    return new P11KeyPairGenerator(this.token, algorithm, this.mechanism);
                }
                return new P11KeyPairGenerator(this.token, algorithm, this.mechanism);
            }
            if (type.equals(TopPKCS11Provider.CIP)) {
                if (algorithm.startsWith("SM2")) {
                    return new P11SM2Cipher(this.token, "SM2", this.mechanism);
                }
                if (algorithm.startsWith("RSA")) {
                    return new P11RSACipher(this.token, "RSA", this.mechanism);
                }
                return new P11Cipher(this.token, algorithm, this.mechanism);
            }
            if (type.equals(TopPKCS11Provider.SIG)) {
                return new P11Signature(this.token, algorithm, this.mechanism);
            }
            if (type == TopPKCS11Provider.MAC) {
                return new P11Mac(this.token, algorithm, this.mechanism);
            }
            if (type == TopPKCS11Provider.SKF) {
                return new P11SecretKeyFactory(this.token, algorithm);
            }
            if (type == TopPKCS11Provider.KG) {
                if (algorithm == "TopTlsRsaPremasterSecret") {
                    throw new UnsupportedOperationException("unsupported algorithm " + algorithm);
                }
                if (algorithm == "TopTlsMasterSecret") {
                    throw new UnsupportedOperationException("unsupported algorithm " + algorithm);
                }
                if (algorithm == "TopTlsKeyMaterial") {
                    throw new UnsupportedOperationException("unsupported algorithm " + algorithm);
                }
                if (algorithm == "TopTlsPrf") {
                    throw new UnsupportedOperationException("unsupported algorithm " + algorithm);
                }
                return new P11KeyGenerator(this.token, algorithm, this.mechanism);
            }
            if (type == TopPKCS11Provider.SR) {
                return this.token.getRandom();
            }
            if (type == TopPKCS11Provider.KS) {
                return this.token.getKeyStore();
            }
            if (type == TopPKCS11Provider.AGP) {
                return new ECParameters();
            }
            throw new NoSuchAlgorithmException("Unknown type: " + type);
        }

        @Override
        public boolean supportsParameter(Object param) {
            if (param == null || !this.token.isValid()) {
                return false;
            }
            if (!(param instanceof Key)) {
                throw new InvalidParameterException("Parameter must be a Key");
            }
            String algorithm = this.getAlgorithm();
            String type = this.getType();
            Key key = (Key)param;
            String keyAlgorithm = key.getAlgorithm();
            if (type == TopPKCS11Provider.CIP && algorithm.startsWith("RSA") || type == TopPKCS11Provider.SIG && algorithm.endsWith("RSA")) {
                if (!keyAlgorithm.equals("RSA")) {
                    return false;
                }
                return this.isLocalKey(key) || key instanceof RSAPrivateKey || key instanceof RSAPublicKey;
            }
            if (type == TopPKCS11Provider.KA && algorithm.equals("ECDH") || type == TopPKCS11Provider.SIG && algorithm.endsWith("ECDSA")) {
                if (!keyAlgorithm.equals("EC")) {
                    return false;
                }
                return this.isLocalKey(key) || key instanceof ECPrivateKey || key instanceof ECPublicKey;
            }
            if (type == TopPKCS11Provider.SIG && algorithm.endsWith("DSA")) {
                if (!keyAlgorithm.equals("DSA")) {
                    return false;
                }
                return this.isLocalKey(key) || key instanceof DSAPrivateKey || key instanceof DSAPublicKey;
            }
            if (type == TopPKCS11Provider.CIP || type == TopPKCS11Provider.MAC) {
                return this.isLocalKey(key) || "RAW".equals(key.getFormat());
            }
            if (type == TopPKCS11Provider.KA) {
                if (!keyAlgorithm.equals("DH")) {
                    return false;
                }
                return this.isLocalKey(key) || key instanceof DHPrivateKey || key instanceof DHPublicKey;
            }
            if (type == TopPKCS11Provider.CIP && algorithm.startsWith("SM2") || type == TopPKCS11Provider.SIG && algorithm.endsWith("SM2")) {
                if (!keyAlgorithm.equals("SM2")) {
                    return false;
                }
                return this.isLocalKey(key) || key instanceof ECPrivateKey || key instanceof ECPublicKey;
            }
            if (type == TopPKCS11Provider.CIP && algorithm.startsWith("SM1") || type == TopPKCS11Provider.SIG && algorithm.endsWith("SM1")) {
                if (!keyAlgorithm.equals("SM1")) {
                    return false;
                }
                return this.isLocalKey(key) || key instanceof ECPrivateKey || key instanceof ECPublicKey;
            }
            if (type == TopPKCS11Provider.CIP && algorithm.startsWith("SM4") || type == TopPKCS11Provider.SIG && algorithm.endsWith("SM4")) {
                if (!keyAlgorithm.equals("SM4")) {
                    return false;
                }
                return this.isLocalKey(key) || key instanceof ECPrivateKey || key instanceof ECPublicKey;
            }
            throw new AssertionError((Object)("TopPKCS11 error: " + type + ", " + algorithm));
        }

        private boolean isLocalKey(Key key) {
            return key instanceof P11Key && ((P11Key)key).token == this.token;
        }

        @Override
        public String toString() {
            return super.toString() + " (" + Functions.getMechanismName(this.mechanism) + ")";
        }
    }

    private static class TokenPoller
    implements Runnable {
        private final TopPKCS11Provider provider;
        private volatile boolean enabled;

        private TokenPoller(TopPKCS11Provider provider) {
            this.provider = provider;
            this.enabled = true;
        }

        @Override
        public void run() {
            int interval = this.provider.config.getInsertionCheckInterval();
            while (this.enabled) {
                try {
                    Thread.sleep(interval);
                }
                catch (InterruptedException e) {
                    break;
                }
                if (!this.enabled) break;
                try {
                    this.provider.initToken(null);
                }
                catch (PKCS11Exception pKCS11Exception) {}
            }
        }

        void disable() {
            this.enabled = false;
        }
    }

    private static final class Descriptor {
        final String type;
        final String algorithm;
        final String className;
        final String[] aliases;
        final long[] mechanisms;

        private Descriptor(String type, String algorithm, String className, String[] aliases, long[] mechanisms) {
            this.type = type;
            this.algorithm = algorithm;
            this.className = className;
            this.aliases = aliases;
            this.mechanisms = mechanisms;
            log.debug((Object)("\u6dfb\u52a0\u7b97\u6cd5\uff1a" + algorithm + "     ;aliases:" + aliases + "   ;\u52a0\u5bc6\u673a\u5236:" + Arrays.toString(mechanisms) + ";  \u7c7b\u540d:" + className));
        }

        private P11Service service(Token token, long mechanism) {
            return new P11Service(token, this.type, this.algorithm, this.className, this.aliases, mechanism);
        }

        public String toString() {
            return this.type + "." + this.algorithm;
        }
    }
}

