/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.pkcs11.jna;

import cn.topca.security.pkcs11.jna.CK_ATTRIBUTE;
import cn.topca.security.pkcs11.jna.CK_C_INITIALIZE_ARGS;
import cn.topca.security.pkcs11.jna.CK_INFO;
import cn.topca.security.pkcs11.jna.CK_MECHANISM;
import cn.topca.security.pkcs11.jna.CK_MECHANISM_INFO;
import cn.topca.security.pkcs11.jna.CK_NOTIFY;
import cn.topca.security.pkcs11.jna.CK_SESSION_INFO;
import cn.topca.security.pkcs11.jna.CK_SLOT_INFO;
import cn.topca.security.pkcs11.jna.CK_TOKEN_INFO;
import cn.topca.security.pkcs11.jna.CK_VERSION;
import cn.topca.security.pkcs11.jna.Functions;
import com.sun.jna.AltCallingConvention;
import com.sun.jna.Callback;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.NativeLongByReference;
import com.sun.jna.ptr.PointerByReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CK_FUNCTION_LIST
extends Structure {
    private static final Log log = LogFactory.getLog((String)"TopP11-CK_FUNCTION_LIST");
    public CK_VERSION version;
    public CK_C_Initialize C_Initialize;
    public CK_C_Finalize C_Finalize;
    public CK_C_GetInfo C_GetInfo;
    public CK_C_GetFunctionList C_GetFunctionList;
    public CK_C_GetSlotList C_GetSlotList;
    public CK_C_GetSlotInfo C_GetSlotInfo;
    public CK_C_GetTokenInfo C_GetTokenInfo;
    public CK_C_GetMechanismList C_GetMechanismList;
    public CK_C_GetMechanismInfo C_GetMechanismInfo;
    public CK_C_InitToken C_InitToken;
    public CK_C_InitPIN C_InitPIN;
    public CK_C_SetPIN C_SetPIN;
    public CK_C_OpenSession C_OpenSession;
    public CK_C_CloseSession C_CloseSession;
    public CK_C_CloseAllSessions C_CloseAllSessions;
    public CK_C_GetSessionInfo C_GetSessionInfo;
    public Pointer C_GetOperationState;
    public Pointer C_SetOperationState;
    public CK_C_Login C_Login;
    public CK_C_Logout C_Logout;
    public CK_C_CreateObject C_CreateObject;
    public CK_C_CopyObject C_CopyObject;
    public CK_C_DestroyObject C_DestroyObject;
    public CK_C_GetObjectSize C_GetObjectSize;
    public CK_C_GetAttributeValue C_GetAttributeValue;
    public CK_C_SetAttributeValue C_SetAttributeValue;
    public CK_C_FindObjectsInit C_FindObjectsInit;
    public CK_C_FindObjects C_FindObjects;
    public CK_C_FindObjectsFinal C_FindObjectsFinal;
    public CK_C_EncryptInit C_EncryptInit;
    public CK_C_Encrypt C_Encrypt;
    public CK_C_EncryptUpdate C_EncryptUpdate;
    public CK_C_EncryptFinal C_EncryptFinal;
    public CK_C_DecryptInit C_DecryptInit;
    public CK_C_Decrypt C_Decrypt;
    public CK_C_DecryptUpdate C_DecryptUpdate;
    public CK_C_DecryptFinal C_DecryptFinal;
    public CK_C_DigestInit C_DigestInit;
    public CK_C_Digest C_Digest;
    public CK_C_DigestUpdate C_DigestUpdate;
    public Pointer C_DigestKey;
    public CK_C_DigestFinal C_DigestFinal;
    public CK_C_SignInit C_SignInit;
    public CK_C_Sign C_Sign;
    public CK_C_SignUpdate C_SignUpdate;
    public CK_C_SignFinal C_SignFinal;
    public Pointer C_SignRecoverInit;
    public CK_C_SignRecover C_SignRecover;
    public CK_C_VerifyInit C_VerifyInit;
    public CK_C_Verify C_Verify;
    public CK_C_VerifyUpdate C_VerifyUpdate;
    public CK_C_VerifyFinal C_VerifyFinal;
    public Pointer C_VerifyRecoverInit;
    public Pointer C_VerifyRecover;
    public Pointer C_DigestEncryptUpdate;
    public Pointer C_DecryptDigestUpdate;
    public Pointer C_SignEncryptUpdate;
    public CK_C_DecryptVerifyUpdate C_DecryptVerifyUpdate;
    public CK_C_GenerateKey C_GenerateKey;
    public CK_C_GenerateKeyPair C_GenerateKeyPair;
    public CK_C_WrapKey C_WrapKey;
    public CK_C_UnwrapKey C_UnwrapKey;
    public CK_C_DeriveKey C_DeriveKey;
    public CK_C_SeedRandom C_SeedRandom;
    public CK_C_GenerateRandom C_GenerateRandom;
    public Pointer C_GetFunctionStatus;
    public Pointer C_CancelFunction;
    public CK_C_WaitForSlotEvent C_WaitForSlotEvent;
    private static ByteBuffer buffer = ByteBuffer.allocate(8);

    public CK_VERSION getVersion() {
        return this.version;
    }

    public NativeLong C_Initialize(CK_C_INITIALIZE_ARGS pInitArgs) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_Initialize");
        log.debug((Object)("CK_C_INITIALIZE_ARGS: " + (Object)((Object)pInitArgs)));
        NativeLong rv = this.C_Initialize.invoke(pInitArgs);
        log.debug((Object)("CK_RV: 0x" + Functions.toFullHexString(rv.intValue())));
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_Finalize(Pointer pReserved) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_Finalize");
        log.debug((Object)("pReserved: " + pReserved));
        NativeLong rv = this.C_Finalize.invoke(pReserved);
        log.debug((Object)("CK_RV: 0x" + Functions.toFullHexString(rv.intValue())));
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_GetInfo(CK_INFO pInfo) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_GetInfo");
        log.debug((Object)("CK_INFO: " + (pInfo != null ? pInfo.getPointer() : null)));
        NativeLong rv = this.C_GetInfo.invoke(pInfo);
        log.debug((Object)("CK_RV: 0x" + Functions.toFullHexString(rv.intValue())));
        log.debug((Object)("CK_INFO: " + (Object)((Object)pInfo)));
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_GetFunctionList(PointerByReference ppFunctionList) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_GetFunctionList");
        NativeLong rv = this.C_GetFunctionList.invoke(ppFunctionList);
        log.debug((Object)("CK_RV: 0x" + Functions.toFullHexString(rv.intValue())));
        log.debug((Object)("ppFunctionList: " + ppFunctionList));
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_GetSlotList(byte tokenPresent, NativeLong[] pSlotList, NativeLongByReference pulCount) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_GetSlotList");
        log.debug((Object)("tokenPresent: " + tokenPresent));
        log.debug((Object)("pSlotList: " + (pSlotList != null ? "(" + pSlotList.length * NativeLong.SIZE + " bytes, size " + pSlotList.length + ")" : null)));
        log.debug((Object)("pulCount: " + pulCount));
        NativeLong rv = this.C_GetSlotList.invoke(tokenPresent, pSlotList, pulCount);
        log.debug((Object)("CK_RV: 0x" + Functions.toFullHexString(rv.intValue())));
        log.debug((Object)("pSlotList: " + CK_FUNCTION_LIST.show(pSlotList)));
        log.debug((Object)("pulCount: " + CK_FUNCTION_LIST.show(pulCount)));
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_GetSlotInfo(NativeLong slotID, CK_SLOT_INFO pInfo) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_GetSlotInfo");
        log.debug((Object)("slotID: " + slotID));
        log.debug((Object)("CK_SLOT_INFO: " + CK_FUNCTION_LIST.showPointer((Object)pInfo)));
        NativeLong rv = this.C_GetSlotInfo.invoke(slotID, pInfo);
        log.debug((Object)("CK_RV: 0x" + Functions.toFullHexString(rv.intValue())));
        log.debug((Object)("CK_SLOT_INFO: " + (Object)((Object)pInfo)));
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_GetTokenInfo(NativeLong slotID, CK_TOKEN_INFO pInfo) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_GetTokenInfo");
        log.debug((Object)("slotID: " + slotID));
        log.debug((Object)("CK_TOKEN_INFO: " + CK_FUNCTION_LIST.showPointer((Object)pInfo)));
        NativeLong rv = this.C_GetTokenInfo.invoke(slotID, pInfo);
        log.debug((Object)("CK_RV: 0x" + Functions.toFullHexString(rv.intValue())));
        log.debug((Object)("CK_TOKEN_INFO: " + (Object)((Object)pInfo)));
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_GetMechanismList(NativeLong slotID, NativeLong[] pMechanismList, NativeLongByReference pulCount) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_GetMechanismList");
        log.debug((Object)("slotID: " + slotID));
        log.debug((Object)("pMechanismList: " + pMechanismList));
        log.debug((Object)("pulCount: " + pulCount));
        NativeLong rv = this.C_GetMechanismList.invoke(slotID, pMechanismList, pulCount);
        log.debug((Object)("CK_RV: 0x" + Functions.toFullHexString(rv.intValue())));
        for (int i = 0; pMechanismList != null && i < pMechanismList.length; ++i) {
            log.debug((Object)("pMechanismList[" + i + "]: " + pMechanismList[i]));
        }
        log.debug((Object)("pulCount: " + CK_FUNCTION_LIST.show(pulCount)));
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_GetMechanismInfo(NativeLong slotID, NativeLong type, CK_MECHANISM_INFO pInfo) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_GetMechanismInfo");
        log.debug((Object)("slotID: " + slotID));
        log.debug((Object)("type: 0x" + Functions.toFullHexString(type.intValue())));
        log.debug((Object)("CK_MECHANISM_INFO: " + (Object)((Object)pInfo)));
        NativeLong rv = this.C_GetMechanismInfo.invoke(slotID, type, pInfo);
        log.debug((Object)("CK_RV: 0x" + Functions.toFullHexString(rv.intValue())));
        log.debug((Object)("CK_MECHANISM_INFO: " + (Object)((Object)pInfo)));
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_InitToken(NativeLong slotID, Pointer pPin, NativeLong ulPinLen, Pointer pLabel) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_InitToken");
        NativeLong rv = this.C_InitToken.invoke(slotID, pPin, ulPinLen, pLabel);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_InitPIN(NativeLong hSession, Pointer pPin, NativeLong ulPinLen) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_InitPIN");
        NativeLong rv = this.C_InitPIN.invoke(hSession, pPin, ulPinLen);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_SetPIN(NativeLong hSession, Pointer pOldPin, NativeLong ulOldPinLen, Pointer pNewPin, NativeLong ulNewPinLen) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_SetPIN");
        NativeLong rv = this.C_SetPIN.invoke(hSession, pOldPin, ulOldPinLen, pNewPin, ulNewPinLen);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_OpenSession(NativeLong slotID, NativeLong flags, Pointer pApplication, CK_NOTIFY Notify, NativeLongByReference phSession) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_GetMechanismInfo");
        log.debug((Object)("slotID: " + slotID));
        log.debug((Object)("flags: " + Functions.sessionInfoFlagsToString(flags.longValue())));
        log.debug((Object)("pApplication: " + pApplication));
        log.debug((Object)("Notify: " + Notify));
        log.debug((Object)("phSession: " + phSession));
        NativeLong rv = this.C_OpenSession.invoke(slotID, flags, pApplication, Notify, phSession);
        log.debug((Object)("CK_RV: 0x" + Functions.toFullHexString(rv.intValue())));
        log.debug((Object)("phSession: " + phSession));
        log.debug((Object)("hSession: " + phSession.getValue()));
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_CloseSession(NativeLong hSession) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_CloseSession");
        log.debug((Object)("hSession: " + hSession));
        NativeLong rv = this.C_CloseSession.invoke(hSession);
        log.debug((Object)("CK_RV: 0x" + Functions.toFullHexString(rv.intValue())));
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_CloseAllSessions(NativeLong slotID) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_CloseAllSessions");
        NativeLong rv = this.C_CloseAllSessions.invoke(slotID);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_GetSessionInfo(NativeLong hSession, CK_SESSION_INFO pInfo) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_GetSessionInfo");
        NativeLong rv = this.C_GetSessionInfo.invoke(hSession, pInfo);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_GetOperationState(NativeLong hSession, Pointer pOperationState, NativeLongByReference pulOperationStateLen) {
        NativeLong rv = null;
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_GetOperationState");
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_SetOperationState(NativeLong hSession, Pointer pOperationState, NativeLong pulOperationStateLen, NativeLong hEncryptionKey, NativeLong hAuthenticationKey) {
        NativeLong rv = null;
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_SetOperationState");
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_Login(NativeLong hSession, NativeLong userType, Pointer pPin, NativeLong ulPinLen) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_Login");
        log.debug((Object)("hSession: " + hSession));
        log.debug((Object)("userType: 0x" + Functions.toFullHexString(userType.intValue())));
        log.debug((Object)("pPin: " + pPin));
        log.debug((Object)("pin: " + pPin.getString(0L)));
        log.debug((Object)("ulPinLen: " + ulPinLen));
        NativeLong rv = this.C_Login.invoke(hSession, userType, pPin, ulPinLen);
        log.debug((Object)("CK_RV: 0x" + Functions.toFullHexString(rv.intValue())));
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_Logout(NativeLong hSession) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_Logout");
        log.debug((Object)("hSession: " + hSession));
        NativeLong rv = this.C_Logout.invoke(hSession);
        log.debug((Object)("CK_RV: 0x" + Functions.toFullHexString(rv.intValue())));
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_CreateObject(NativeLong hSession, CK_ATTRIBUTE[] pTemplate, NativeLong ulCount, NativeLongByReference phObject) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_CreateObject");
        NativeLong rv = this.C_CreateObject.invoke(hSession, pTemplate, ulCount, phObject);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_CopyObject(NativeLong hSession, NativeLong hObject, CK_ATTRIBUTE[] pTemplate, NativeLong ulCount, NativeLongByReference phNewObject) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_CopyObject");
        NativeLong rv = this.C_CopyObject.invoke(hSession, hObject, pTemplate, ulCount, phNewObject);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_DestroyObject(NativeLong hSession, NativeLong hObject) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_DestroyObject");
        NativeLong rv = this.C_DestroyObject.invoke(hSession, hObject);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_GetObjectSize(NativeLong hSession, NativeLong hObject, NativeLongByReference pulSize) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_GetObjectSize");
        NativeLong rv = this.C_GetObjectSize.invoke(hSession, hObject, pulSize);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_GetAttributeValue(NativeLong hSession, NativeLong hObject, CK_ATTRIBUTE[] pTemplate, NativeLong ulCount) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_GetAttributeValue");
        log.debug((Object)("hSession: " + hSession));
        log.debug((Object)("hObject: 0x" + Functions.toFullHexString(hObject.intValue())));
        log.debug((Object)("pTemplate: " + pTemplate));
        log.debug((Object)("ulCount: " + ulCount));
        NativeLong rv = this.C_GetAttributeValue.invoke(hSession, hObject, pTemplate, ulCount);
        for (int i = 0; pTemplate != null && i < pTemplate.length; ++i) {
            log.debug((Object)("pTemplate[" + i + "]: " + (pTemplate[i].pValue != null ? pTemplate[i] : null)));
        }
        log.debug((Object)("CK_RV: 0x" + Functions.toFullHexString(rv.intValue())));
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_SetAttributeValue(NativeLong hSession, NativeLong hObject, CK_ATTRIBUTE[] pTemplate, NativeLong ulCount) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_SetAttributeValue");
        NativeLong rv = this.C_SetAttributeValue.invoke(hSession, hObject, pTemplate, ulCount);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_FindObjectsInit(NativeLong hSession, CK_ATTRIBUTE[] pTemplate, NativeLong ulCount) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_FindObjectsInit");
        log.debug((Object)("hSession: " + hSession));
        log.debug((Object)("pTemplate: " + pTemplate));
        for (int i = 0; pTemplate != null && i < pTemplate.length; ++i) {
            log.debug((Object)("pTemplate[" + i + "]: " + (Object)((Object)pTemplate[i])));
        }
        log.debug((Object)("ulCount: " + ulCount));
        NativeLong rv = this.C_FindObjectsInit.invoke(hSession, pTemplate, ulCount);
        log.debug((Object)("CK_RV: 0x" + Functions.toFullHexString(rv.intValue())));
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_FindObjects(NativeLong hSession, NativeLong[] phObject, NativeLong ulMaxObjectCount, NativeLongByReference pulObjectCount) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_FindObjects");
        log.debug((Object)("hSession: " + hSession));
        log.debug((Object)("phObject: " + phObject));
        log.debug((Object)("ulMaxObjectCount: " + ulMaxObjectCount));
        log.debug((Object)("pulObjectCount: " + pulObjectCount));
        NativeLong rv = this.C_FindObjects.invoke(hSession, phObject, ulMaxObjectCount, pulObjectCount);
        log.debug((Object)("CK_RV: 0x" + Functions.toFullHexString(rv.intValue())));
        for (int i = 0; phObject != null && i < phObject.length; ++i) {
            log.debug((Object)("pTemplate[" + i + "]: 0x" + Functions.toFullHexString(phObject[i].intValue())));
        }
        log.debug((Object)("ulObjectCount: " + (pulObjectCount != null ? pulObjectCount.getValue() : null)));
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_FindObjectsFinal(NativeLong hSession) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_FindObjectsFinal");
        log.debug((Object)("hSession: " + hSession));
        NativeLong rv = this.C_FindObjectsFinal.invoke(hSession);
        log.debug((Object)("CK_RV: 0x" + Functions.toFullHexString(rv.intValue())));
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_EncryptInit(NativeLong hSession, CK_MECHANISM pMechanism, NativeLong hKey) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_EncryptInit");
        NativeLong rv = this.C_EncryptInit.invoke(hSession, pMechanism, hKey);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_Encrypt(NativeLong hSession, Pointer pData, NativeLong ulDataLen, Pointer pEncryptedData, NativeLongByReference pulEncryptedDataLen) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_Encrypt");
        NativeLong rv = this.C_Encrypt.invoke(hSession, pData, ulDataLen, pEncryptedData, pulEncryptedDataLen);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_EncryptUpdate(NativeLong hSession, Pointer pPart, NativeLong ulPartLen, Pointer pEncryptedPart, NativeLongByReference pulEncryptedPartLen) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_EncryptUpdate");
        NativeLong rv = this.C_EncryptUpdate.invoke(hSession, pPart, ulPartLen, pEncryptedPart, pulEncryptedPartLen);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_EncryptFinal(NativeLong hSession, Pointer pLastEncryptedPart, NativeLongByReference pulLastEncryptedPartLen) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_EncryptFinal");
        NativeLong rv = this.C_EncryptFinal.invoke(hSession, pLastEncryptedPart, pulLastEncryptedPartLen);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_DecryptInit(NativeLong hSession, CK_MECHANISM pMechanism, NativeLong hKey) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_DecryptInit");
        NativeLong rv = this.C_DecryptInit.invoke(hSession, pMechanism, hKey);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_Decrypt(NativeLong hSession, Pointer pEncryptedData, NativeLong ulEncryptedDataLen, Pointer pData, NativeLongByReference pulDataLen) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_Decrypt");
        NativeLong rv = this.C_Decrypt.invoke(hSession, pEncryptedData, ulEncryptedDataLen, pData, pulDataLen);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_DecryptUpdate(NativeLong hSession, Pointer pEncryptedPart, NativeLong ulEncryptedPartLen, Pointer pPart, NativeLongByReference pulPartLen) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_DecryptUpdate");
        NativeLong rv = this.C_DecryptUpdate.invoke(hSession, pEncryptedPart, ulEncryptedPartLen, pPart, pulPartLen);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_DecryptFinal(NativeLong hSession, Pointer pLastPart, NativeLongByReference pulLastPartLen) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_DecryptFinal");
        NativeLong rv = this.C_DecryptFinal.invoke(hSession, pLastPart, pulLastPartLen);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_DigestInit(NativeLong hSession, CK_MECHANISM pMechanism) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_DigestInit");
        NativeLong rv = this.C_DigestInit.invoke(hSession, pMechanism);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_Digest(NativeLong hSession, Pointer pData, NativeLong ulDataLen, Pointer pDigest, NativeLongByReference pulDigestLen) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_Digest");
        NativeLong rv = this.C_Digest.invoke(hSession, pData, ulDataLen, pDigest, pulDigestLen);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_DigestUpdate(NativeLong hSession, Pointer pPart, NativeLong ulPartLen) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_DigestUpdate");
        NativeLong rv = this.C_DigestUpdate.invoke(hSession, pPart, ulPartLen);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_DigestKey(NativeLong hSession, NativeLong hKey) {
        NativeLong rv = null;
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_DigestKey");
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_DigestFinal(NativeLong hSession, Pointer pDigest, NativeLongByReference pulDigestLen) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_DigestFinal");
        NativeLong rv = this.C_DigestFinal.invoke(hSession, pDigest, pulDigestLen);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_SignInit(NativeLong hSession, CK_MECHANISM pMechanism, NativeLong hKey) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_SignInit");
        log.debug((Object)("hSession: " + hSession));
        log.debug((Object)("pMechanism: " + (Object)((Object)pMechanism)));
        log.debug((Object)("hKey: 0x" + Functions.toFullHexString(hKey.intValue())));
        NativeLong rv = this.C_SignInit.invoke(hSession, pMechanism, hKey);
        log.debug((Object)("CK_RV: 0x" + Functions.toFullHexString(rv.intValue())));
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_Sign(NativeLong hSession, Pointer pData, NativeLong ulDataLen, Pointer pSignature, NativeLongByReference pulSignatureLen) {
        String _msg = null;
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_Sign");
        log.debug((Object)("hSession: " + hSession));
        log.debug((Object)("pData: " + pData));
        if (pData != null) {
            _msg = "0h" + Functions.toHexString(pData.getByteArray(0L, ulDataLen.intValue()));
        }
        log.debug((Object)("data: " + _msg));
        log.debug((Object)("pSignature: " + pSignature));
        log.debug((Object)("pulSignatureLen: " + pulSignatureLen));
        NativeLong rv = this.C_Sign.invoke(hSession, pData, ulDataLen, pSignature, pulSignatureLen);
        if (pSignature != null) {
            _msg = "0h" + Functions.toHexString(pSignature.getByteArray(0L, pulSignatureLen.getValue().intValue()));
        }
        log.debug((Object)("signature: " + _msg));
        log.debug((Object)("ulSignatureLen: " + pulSignatureLen.getValue()));
        log.debug((Object)("CK_RV: 0x" + Functions.toFullHexString(rv.intValue())));
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_SignUpdate(NativeLong hSession, Pointer pPart, NativeLong ulPartLen) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_SignUpdate");
        NativeLong rv = this.C_SignUpdate.invoke(hSession, pPart, ulPartLen);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_SignFinal(NativeLong hSession, Pointer pSignature, NativeLongByReference pulSignatureLen) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_SignFinal");
        NativeLong rv = this.C_SignFinal.invoke(hSession, pSignature, pulSignatureLen);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_SignRecoverInit(NativeLong hSession, CK_MECHANISM pMechanism, NativeLong hKey) {
        NativeLong rv = null;
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_SignRecoverInit");
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_SignRecover(NativeLong hSession, Pointer pData, NativeLong ulDataLen, Pointer pSignature, NativeLongByReference pulSignatureLen) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_SignRecover");
        NativeLong rv = this.C_SignRecover.invoke(hSession, pData, ulDataLen, pSignature, pulSignatureLen);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_VerifyInit(NativeLong hSession, CK_MECHANISM pMechanism, NativeLong hKey) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_VerifyInit");
        NativeLong rv = this.C_VerifyInit.invoke(hSession, pMechanism, hKey);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_Verify(NativeLong hSession, Pointer pData, NativeLong ulDataLen, Pointer pSignature, NativeLong ulSignatureLen) {
        String _msg = null;
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_Verify");
        log.debug((Object)("hSession: " + hSession));
        log.debug((Object)("pData: " + pData));
        log.debug((Object)("ulDataLen: " + ulDataLen));
        if (pData != null) {
            _msg = "0h" + Functions.toHexString(pData.getByteArray(0L, ulDataLen.intValue()));
        }
        log.debug((Object)("data: " + _msg));
        log.debug((Object)("pSignature: " + pSignature));
        log.debug((Object)("ulSignatureLen: " + ulSignatureLen));
        if (pSignature != null) {
            _msg = "0h" + Functions.toHexString(pSignature.getByteArray(0L, ulSignatureLen.intValue()));
        }
        log.debug((Object)("signature: " + _msg));
        NativeLong rv = this.C_Verify.invoke(hSession, pData, ulDataLen, pSignature, ulSignatureLen);
        log.debug((Object)("CK_RV: 0x" + Functions.toFullHexString(rv.intValue())));
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_VerifyUpdate(NativeLong hSession, Pointer pPart, NativeLong ulPartLen) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_VerifyUpdate");
        NativeLong rv = this.C_VerifyUpdate.invoke(hSession, pPart, ulPartLen);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_VerifyFinal(NativeLong hSession, Pointer pSignature, NativeLong ulSignatureLen) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_VerifyFinal");
        NativeLong rv = this.C_VerifyFinal.invoke(hSession, pSignature, ulSignatureLen);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_VerifyRecoverInit(NativeLong hSession, CK_MECHANISM pMechanism, NativeLong hKey) {
        NativeLong rv = null;
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_VerifyRecoverInit");
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_VerifyRecover(NativeLong hSession, Pointer pSignature, NativeLong ulSignatureLen, Pointer pData, NativeLongByReference pulDataLen) {
        NativeLong rv = null;
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_VerifyRecover");
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_DigestEncryptUpdate(NativeLong hSession, Pointer pPart, NativeLong ulPartLen, Pointer pEncryptedPart, NativeLongByReference pulEncryptedPartLen) {
        NativeLong rv = null;
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_DigestEncryptUpdate");
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_DecryptDigestUpdate(NativeLong hSession, Pointer pEncryptedPart, NativeLong ulEncryptedPartLen, Pointer pPart, NativeLongByReference pulPartLen) {
        NativeLong rv = null;
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_DecryptDigestUpdate");
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_SignEncryptUpdate(NativeLong hSession, Pointer pPart, NativeLong ulPartLen, Pointer pEncryptedPart, NativeLongByReference pulEncryptedPartLen) {
        NativeLong rv = null;
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_SignEncryptUpdate");
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_DecryptVerifyUpdate(NativeLong hSession, Pointer pEncryptedPart, NativeLong ulEncryptedPartLen, Pointer pPart, NativeLongByReference pulPartLen) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_DecryptVerifyUpdate");
        NativeLong rv = this.C_DecryptVerifyUpdate.invoke(hSession, pEncryptedPart, ulEncryptedPartLen, pPart, pulPartLen);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_GenerateKey(NativeLong hSession, CK_MECHANISM pMechanism, CK_ATTRIBUTE[] pTemplate, NativeLong ulCount, NativeLongByReference phKey) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_GenerateKey");
        NativeLong rv = this.C_GenerateKey.invoke(hSession, pMechanism, pTemplate, ulCount, phKey);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_GenerateKeyPair(NativeLong hSession, CK_MECHANISM pMechanism, CK_ATTRIBUTE[] pPublicKeyTemplate, NativeLong ulPublicKeyAttributeCount, CK_ATTRIBUTE[] pPrivateKeyTemplate, NativeLong ulPrivateKeyAttributeCount, NativeLongByReference phPublicKey, NativeLongByReference phPrivateKey) {
        log.debug((Object)"============CK_FUNCTION start==============");
        return this.C_GenerateKeyPair.invoke(hSession, pMechanism, pPublicKeyTemplate, ulPublicKeyAttributeCount, pPrivateKeyTemplate, ulPrivateKeyAttributeCount, phPublicKey, phPrivateKey);
    }

    public NativeLong C_WrapKey(NativeLong hSession, CK_MECHANISM pMechanism, NativeLong hWrappingKey, NativeLong hKey, Pointer pWrappedKey, NativeLongByReference pulWrappedKeyLen) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_WrapKey");
        NativeLong rv = this.C_WrapKey.invoke(hSession, pMechanism, hWrappingKey, hKey, pWrappedKey, pulWrappedKeyLen);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_UnwrapKey(NativeLong hSession, CK_MECHANISM pMechanism, NativeLong hUnwrappingKey, Pointer pWrappedKey, NativeLong ulWrappedKeyLen, CK_ATTRIBUTE pTemplate, NativeLong ulAttributeCount, NativeLongByReference phKey) {
        log.debug((Object)"============CK_FUNCTION start==============");
        return this.C_UnwrapKey.invoke(hSession, pMechanism, hUnwrappingKey, pWrappedKey, ulWrappedKeyLen, pTemplate, ulAttributeCount, phKey);
    }

    public NativeLong C_DeriveKey(NativeLong hSession, CK_MECHANISM pMechanism, NativeLong hBaseKey, CK_ATTRIBUTE pTemplate, NativeLong ulAttributeCount, NativeLongByReference phKey) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_DeriveKey");
        NativeLong rv = this.C_DeriveKey.invoke(hSession, pMechanism, hBaseKey, pTemplate, ulAttributeCount, phKey);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_SeedRandom(NativeLong hSession, Pointer pSeed, NativeLong ulSeedLen) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_SeedRandom");
        NativeLong rv = this.C_SeedRandom.invoke(hSession, pSeed, ulSeedLen);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_GenerateRandom(NativeLong hSession, Pointer RandomData, NativeLong ulRandomLen) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_GenerateRandom");
        NativeLong rv = this.C_GenerateRandom.invoke(hSession, RandomData, ulRandomLen);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_GetFunctionStatus(NativeLong hSession) {
        NativeLong rv = null;
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_GetFunctionStatus");
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_CancelFunction(NativeLong hSession) {
        NativeLong rv = null;
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_CancelFunction");
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public NativeLong C_WaitForSlotEvent(NativeLong flags, NativeLongByReference pSlot, Pointer pRserved) {
        log.debug((Object)"============CK_FUNCTION start==============");
        log.debug((Object)"CK_FUNCTION->C_WaitForSlotEvent");
        NativeLong rv = this.C_WaitForSlotEvent.invoke(flags, pSlot, pRserved);
        log.debug((Object)"============CK_FUNCTION finish==============");
        return rv;
    }

    public CK_FUNCTION_LIST(Pointer p) {
        super(p, 1);
        System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>" + p.getLong(0L));
        super.read();
    }

    public static long bytesToLong(byte[] bytes) {
        buffer.put(bytes, 0, bytes.length);
        buffer.flip();
        return buffer.getLong();
    }

    public void read(Pointer p) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        byte[] byteArray = p.getByteArray(0L, 2);
        Pointer versionPointer = new Pointer(CK_FUNCTION_LIST.bytesToLong(byteArray));
        Callback callback = this.p2C(versionPointer);
    }

    public Callback p2C(Pointer p) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        if (p == null) {
            return null;
        }
        Class type = null;
        Callback cb = null;
        int ctype = AltCallingConvention.class.isAssignableFrom(type) ? 1 : 0;
        HashMap<String, Method> foptions = new HashMap<String, Method>(Native.getLibraryOptions(type));
        foptions.put("invoking-method", CK_FUNCTION_LIST.getCallbackMethod(type));
        Class<?> aClass = Class.forName("com.sun.jna.CallbackReference$NativeFunctionHandler");
        Constructor<?> declaredConstructor1 = aClass.getDeclaredConstructor(Pointer.class, Integer.class, Map.class);
        Object o = declaredConstructor1.newInstance(p, ctype, foptions);
        cb = (Callback)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)o);
        return cb;
    }

    private static Method getCallbackMethod(Class cls) {
        Method[] pubMethods = cls.getDeclaredMethods();
        Method[] classMethods = cls.getMethods();
        HashSet<Method> pmethods = new HashSet<Method>(Arrays.asList(pubMethods));
        pmethods.retainAll(Arrays.asList(classMethods));
        Iterator i = pmethods.iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            if (!Callback.FORBIDDEN_NAMES.contains(m.getName())) continue;
            i.remove();
        }
        Method[] methods = pmethods.toArray(new Method[pmethods.size()]);
        if (methods.length == 1) {
            return CK_FUNCTION_LIST.checkMethod(methods[0]);
        }
        for (int i2 = 0; i2 < methods.length; ++i2) {
            Method m = methods[i2];
            if (!"callback".equals(m.getName())) continue;
            return CK_FUNCTION_LIST.checkMethod(m);
        }
        String msg = "Callback must implement a single public method, or one public method named 'callback'";
        throw new IllegalArgumentException(msg);
    }

    private static Method checkMethod(Method m) {
        if (m.getParameterTypes().length > 256) {
            String msg = "Method signature exceeds the maximum parameter count: " + m;
            throw new UnsupportedOperationException(msg);
        }
        return m;
    }

    public CK_FUNCTION_LIST(Pointer p, int alignment) {
        super(p, alignment);
        super.read();
    }

    protected List getFieldOrder() {
        return Arrays.asList("version", "C_Initialize", "C_Finalize", "C_GetInfo", "C_GetFunctionList", "C_GetSlotList", "C_GetSlotInfo", "C_GetTokenInfo", "C_GetMechanismList", "C_GetMechanismInfo", "C_InitToken", "C_InitPIN", "C_SetPIN", "C_OpenSession", "C_CloseSession", "C_CloseAllSessions", "C_GetSessionInfo", "C_GetOperationState", "C_SetOperationState", "C_Login", "C_Logout", "C_CreateObject", "C_CopyObject", "C_DestroyObject", "C_GetObjectSize", "C_GetAttributeValue", "C_SetAttributeValue", "C_FindObjectsInit", "C_FindObjects", "C_FindObjectsFinal", "C_EncryptInit", "C_Encrypt", "C_EncryptUpdate", "C_EncryptFinal", "C_DecryptInit", "C_Decrypt", "C_DecryptUpdate", "C_DecryptFinal", "C_DigestInit", "C_Digest", "C_DigestUpdate", "C_DigestKey", "C_DigestFinal", "C_SignInit", "C_Sign", "C_SignUpdate", "C_SignFinal", "C_SignRecoverInit", "C_SignRecover", "C_VerifyInit", "C_Verify", "C_VerifyUpdate", "C_VerifyFinal", "C_VerifyRecoverInit", "C_VerifyRecover", "C_DigestEncryptUpdate", "C_DecryptDigestUpdate", "C_SignEncryptUpdate", "C_DecryptVerifyUpdate", "C_GenerateKey", "C_GenerateKeyPair", "C_WrapKey", "C_UnwrapKey", "C_DeriveKey", "C_SeedRandom", "C_GenerateRandom", "C_GetFunctionStatus", "C_CancelFunction", "C_WaitForSlotEvent");
    }

    private static String showStructurePointer(Structure structure) {
        if (structure == null) {
            return "null";
        }
        return structure.getPointer().toString();
    }

    private static String showNativeLongByReference(NativeLongByReference nativeLongByReference) {
        if (nativeLongByReference == null) {
            return "null";
        }
        return nativeLongByReference.getValue().toString();
    }

    private static String showNativeLongArray(NativeLong[] nativeLongArray) {
        if (nativeLongArray == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        boolean first = true;
        for (NativeLong nativeLong : nativeLongArray) {
            if (!first) {
                builder.append(", ");
            } else {
                first = false;
            }
            builder.append(nativeLong);
        }
        builder.append("]");
        return builder.toString();
    }

    private static String show(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof NativeLong[]) {
            return CK_FUNCTION_LIST.showNativeLongArray((NativeLong[])obj);
        }
        if (obj instanceof NativeLongByReference) {
            return CK_FUNCTION_LIST.showNativeLongByReference((NativeLongByReference)obj);
        }
        return obj.toString();
    }

    private static String showPointer(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof Structure) {
            return CK_FUNCTION_LIST.showStructurePointer((Structure)obj);
        }
        return obj.toString();
    }

    public static interface CK_C_WaitForSlotEvent
    extends Callback {
        public NativeLong invoke(NativeLong var1, NativeLongByReference var2, Pointer var3);
    }

    public static interface CK_C_CancelFunction
    extends Callback {
        public NativeLong invoke(NativeLong var1);
    }

    public static interface CK_C_GetFunctionStatus
    extends Callback {
        public NativeLong invoke(NativeLong var1);
    }

    public static interface CK_C_GenerateRandom
    extends Callback {
        public NativeLong invoke(NativeLong var1, Pointer var2, NativeLong var3);
    }

    public static interface CK_C_SeedRandom
    extends Callback {
        public NativeLong invoke(NativeLong var1, Pointer var2, NativeLong var3);
    }

    public static interface CK_C_DeriveKey
    extends Callback {
        public NativeLong invoke(NativeLong var1, CK_MECHANISM var2, NativeLong var3, CK_ATTRIBUTE var4, NativeLong var5, NativeLongByReference var6);
    }

    public static interface CK_C_UnwrapKey
    extends Callback {
        public NativeLong invoke(NativeLong var1, CK_MECHANISM var2, NativeLong var3, Pointer var4, NativeLong var5, CK_ATTRIBUTE var6, NativeLong var7, NativeLongByReference var8);
    }

    public static interface CK_C_WrapKey
    extends Callback {
        public NativeLong invoke(NativeLong var1, CK_MECHANISM var2, NativeLong var3, NativeLong var4, Pointer var5, NativeLongByReference var6);
    }

    public static interface CK_C_GenerateKeyPair
    extends Callback {
        public NativeLong invoke(NativeLong var1, CK_MECHANISM var2, CK_ATTRIBUTE[] var3, NativeLong var4, CK_ATTRIBUTE[] var5, NativeLong var6, NativeLongByReference var7, NativeLongByReference var8);
    }

    public static interface CK_C_GenerateKey
    extends Callback {
        public NativeLong invoke(NativeLong var1, CK_MECHANISM var2, CK_ATTRIBUTE[] var3, NativeLong var4, NativeLongByReference var5);
    }

    public static interface CK_C_DecryptVerifyUpdate
    extends Callback {
        public NativeLong invoke(NativeLong var1, Pointer var2, NativeLong var3, Pointer var4, NativeLongByReference var5);
    }

    public static interface CK_C_SignEncryptUpdate
    extends Callback {
        public NativeLong invoke(NativeLong var1, Pointer var2, NativeLong var3, Pointer var4, NativeLongByReference var5);
    }

    public static interface CK_C_DecryptDigestUpdate
    extends Callback {
        public NativeLong invoke(NativeLong var1, Pointer var2, NativeLong var3, Pointer var4, NativeLongByReference var5);
    }

    public static interface CK_C_DigestEncryptUpdate
    extends Callback {
        public NativeLong invoke(NativeLong var1, Pointer var2, NativeLong var3, Pointer var4, NativeLongByReference var5);
    }

    public static interface CK_C_VerifyRecover
    extends Callback {
        public NativeLong invoke(NativeLong var1, Pointer var2, NativeLong var3, Pointer var4, NativeLongByReference var5);
    }

    public static interface CK_C_VerifyRecoverInit
    extends Callback {
        public NativeLong invoke(NativeLong var1, CK_MECHANISM var2, NativeLong var3);
    }

    public static interface CK_C_VerifyFinal
    extends Callback {
        public NativeLong invoke(NativeLong var1, Pointer var2, NativeLong var3);
    }

    public static interface CK_C_VerifyUpdate
    extends Callback {
        public NativeLong invoke(NativeLong var1, Pointer var2, NativeLong var3);
    }

    public static interface CK_C_Verify
    extends Callback {
        public NativeLong invoke(NativeLong var1, Pointer var2, NativeLong var3, Pointer var4, NativeLong var5);
    }

    public static interface CK_C_VerifyInit
    extends Callback {
        public NativeLong invoke(NativeLong var1, CK_MECHANISM var2, NativeLong var3);
    }

    public static interface CK_C_SignRecover
    extends Callback {
        public NativeLong invoke(NativeLong var1, Pointer var2, NativeLong var3, Pointer var4, NativeLongByReference var5);
    }

    public static interface CK_C_SignRecoverInit
    extends Callback {
        public NativeLong invoke(NativeLong var1, CK_MECHANISM var2, NativeLong var3);
    }

    public static interface CK_C_SignFinal
    extends Callback {
        public NativeLong invoke(NativeLong var1, Pointer var2, NativeLongByReference var3);
    }

    public static interface CK_C_SignUpdate
    extends Callback {
        public NativeLong invoke(NativeLong var1, Pointer var2, NativeLong var3);
    }

    public static interface CK_C_Sign
    extends Callback {
        public NativeLong invoke(NativeLong var1, Pointer var2, NativeLong var3, Pointer var4, NativeLongByReference var5);
    }

    public static interface CK_C_SignInit
    extends Callback {
        public NativeLong invoke(NativeLong var1, CK_MECHANISM var2, NativeLong var3);
    }

    public static interface CK_C_DigestFinal
    extends Callback {
        public NativeLong invoke(NativeLong var1, Pointer var2, NativeLongByReference var3);
    }

    public static interface CK_C_DigestKey
    extends Callback {
        public NativeLong invoke(NativeLong var1, NativeLong var2);
    }

    public static interface CK_C_DigestUpdate
    extends Callback {
        public NativeLong invoke(NativeLong var1, Pointer var2, NativeLong var3);
    }

    public static interface CK_C_Digest
    extends Callback {
        public NativeLong invoke(NativeLong var1, Pointer var2, NativeLong var3, Pointer var4, NativeLongByReference var5);
    }

    public static interface CK_C_DigestInit
    extends Callback {
        public NativeLong invoke(NativeLong var1, CK_MECHANISM var2);
    }

    public static interface CK_C_DecryptFinal
    extends Callback {
        public NativeLong invoke(NativeLong var1, Pointer var2, NativeLongByReference var3);
    }

    public static interface CK_C_DecryptUpdate
    extends Callback {
        public NativeLong invoke(NativeLong var1, Pointer var2, NativeLong var3, Pointer var4, NativeLongByReference var5);
    }

    public static interface CK_C_Decrypt
    extends Callback {
        public NativeLong invoke(NativeLong var1, Pointer var2, NativeLong var3, Pointer var4, NativeLongByReference var5);
    }

    public static interface CK_C_DecryptInit
    extends Callback {
        public NativeLong invoke(NativeLong var1, CK_MECHANISM var2, NativeLong var3);
    }

    public static interface CK_C_EncryptFinal
    extends Callback {
        public NativeLong invoke(NativeLong var1, Pointer var2, NativeLongByReference var3);
    }

    public static interface CK_C_EncryptUpdate
    extends Callback {
        public NativeLong invoke(NativeLong var1, Pointer var2, NativeLong var3, Pointer var4, NativeLongByReference var5);
    }

    public static interface CK_C_Encrypt
    extends Callback {
        public NativeLong invoke(NativeLong var1, Pointer var2, NativeLong var3, Pointer var4, NativeLongByReference var5);
    }

    public static interface CK_C_EncryptInit
    extends Callback {
        public NativeLong invoke(NativeLong var1, CK_MECHANISM var2, NativeLong var3);
    }

    public static interface CK_C_FindObjectsFinal
    extends Callback {
        public NativeLong invoke(NativeLong var1);
    }

    public static interface CK_C_FindObjects
    extends Callback {
        public NativeLong invoke(NativeLong var1, NativeLong[] var2, NativeLong var3, NativeLongByReference var4);
    }

    public static interface CK_C_FindObjectsInit
    extends Callback {
        public NativeLong invoke(NativeLong var1, CK_ATTRIBUTE[] var2, NativeLong var3);
    }

    public static interface CK_C_SetAttributeValue
    extends Callback {
        public NativeLong invoke(NativeLong var1, NativeLong var2, CK_ATTRIBUTE[] var3, NativeLong var4);
    }

    public static interface CK_C_GetAttributeValue
    extends Callback {
        public NativeLong invoke(NativeLong var1, NativeLong var2, CK_ATTRIBUTE[] var3, NativeLong var4);
    }

    public static interface CK_C_GetObjectSize
    extends Callback {
        public NativeLong invoke(NativeLong var1, NativeLong var2, NativeLongByReference var3);
    }

    public static interface CK_C_DestroyObject
    extends Callback {
        public NativeLong invoke(NativeLong var1, NativeLong var2);
    }

    public static interface CK_C_CopyObject
    extends Callback {
        public NativeLong invoke(NativeLong var1, NativeLong var2, CK_ATTRIBUTE[] var3, NativeLong var4, NativeLongByReference var5);
    }

    public static interface CK_C_CreateObject
    extends Callback {
        public NativeLong invoke(NativeLong var1, CK_ATTRIBUTE[] var2, NativeLong var3, NativeLongByReference var4);
    }

    public static interface CK_C_Logout
    extends Callback {
        public NativeLong invoke(NativeLong var1);
    }

    public static interface CK_C_Login
    extends Callback {
        public NativeLong invoke(NativeLong var1, NativeLong var2, Pointer var3, NativeLong var4);
    }

    public static interface CK_C_SetOperationState
    extends Callback {
        public NativeLong invoke(NativeLong var1, Pointer var2, NativeLong var3, NativeLong var4, NativeLong var5);
    }

    public static interface CK_C_GetOperationState
    extends Callback {
        public NativeLong invoke(NativeLong var1, Pointer var2, NativeLongByReference var3);
    }

    public static interface CK_C_GetSessionInfo
    extends Callback {
        public NativeLong invoke(NativeLong var1, CK_SESSION_INFO var2);
    }

    public static interface CK_C_CloseAllSessions
    extends Callback {
        public NativeLong invoke(NativeLong var1);
    }

    public static interface CK_C_CloseSession
    extends Callback {
        public NativeLong invoke(NativeLong var1);
    }

    public static interface CK_C_OpenSession
    extends Callback {
        public NativeLong invoke(NativeLong var1, NativeLong var2, Pointer var3, CK_NOTIFY var4, NativeLongByReference var5);
    }

    public static interface CK_C_SetPIN
    extends Callback {
        public NativeLong invoke(NativeLong var1, Pointer var2, NativeLong var3, Pointer var4, NativeLong var5);
    }

    public static interface CK_C_InitPIN
    extends Callback {
        public NativeLong invoke(NativeLong var1, Pointer var2, NativeLong var3);
    }

    public static interface CK_C_InitToken
    extends Callback {
        public NativeLong invoke(NativeLong var1, Pointer var2, NativeLong var3, Pointer var4);
    }

    public static interface CK_C_GetMechanismInfo
    extends Callback {
        public NativeLong invoke(NativeLong var1, NativeLong var2, CK_MECHANISM_INFO var3);
    }

    public static interface CK_C_GetMechanismList
    extends Callback {
        public NativeLong invoke(NativeLong var1, NativeLong[] var2, NativeLongByReference var3);
    }

    public static interface CK_C_GetTokenInfo
    extends Callback {
        public NativeLong invoke(NativeLong var1, CK_TOKEN_INFO var2);
    }

    public static interface CK_C_GetSlotInfo
    extends Callback {
        public NativeLong invoke(NativeLong var1, CK_SLOT_INFO var2);
    }

    public static interface CK_C_GetSlotList
    extends Callback {
        public NativeLong invoke(byte var1, NativeLong[] var2, NativeLongByReference var3);
    }

    public static interface CK_C_GetFunctionList
    extends Callback {
        public NativeLong invoke(PointerByReference var1);
    }

    public static interface CK_C_GetInfo
    extends Callback {
        public NativeLong invoke(CK_INFO var1);
    }

    public static interface CK_C_Finalize
    extends Callback {
        public NativeLong invoke(Pointer var1);
    }

    public static interface CK_C_Initialize
    extends Callback {
        public NativeLong invoke(CK_C_INITIALIZE_ARGS var1);
    }
}

