/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.pkcs11.jna;

import cn.topca.security.pkcs11.P11Util;
import cn.topca.security.pkcs11.jna.CK_AES_CTR_PARAMS;
import cn.topca.security.pkcs11.jna.CK_ECDH1_DERIVE_PARAMS;
import cn.topca.security.pkcs11.jna.CK_SSL3_KEY_MAT_PARAMS;
import cn.topca.security.pkcs11.jna.CK_SSL3_MASTER_KEY_DERIVE_PARAMS;
import cn.topca.security.pkcs11.jna.CK_TLS_PRF_PARAMS;
import cn.topca.security.pkcs11.jna.CK_VERSION;
import cn.topca.security.pkcs11.jna.Constants;
import cn.topca.security.pkcs11.jna.Functions;
import cn.topca.security.pkcs11.jna.ItrusStructure;
import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.NativeLongByReference;
import java.math.BigInteger;

public class CK_MECHANISM
extends ItrusStructure {
    public NativeLong mechanism;
    public Pointer pParameter;
    public NativeLong ulParameterLen;

    public CK_MECHANISM() {
    }

    public CK_MECHANISM(long mechanism) {
        this.mechanism = Functions.jLongToCKULong(mechanism);
    }

    public CK_MECHANISM(long mechanism, byte[] pParameter) {
        this.mechanism = new NativeLong(mechanism);
        if (pParameter != null) {
            this.pParameter = new Memory((long)pParameter.length);
            this.pParameter.write(0L, pParameter, 0, pParameter.length);
            this.ulParameterLen = new NativeLong((long)pParameter.length);
        } else {
            this.pParameter = null;
            this.ulParameterLen = new NativeLong(0L);
        }
    }

    public CK_MECHANISM(long mechanism, BigInteger b) {
        this(mechanism, P11Util.getMagnitude(b));
    }

    public CK_MECHANISM(long mechanism, CK_VERSION version) {
        this.mechanism = new NativeLong(mechanism);
        this.pParameter = version.getPointer();
        this.ulParameterLen = new NativeLong((long)version.size());
    }

    public CK_MECHANISM(long mechanism, CK_SSL3_MASTER_KEY_DERIVE_PARAMS params) {
        this.mechanism = new NativeLong(mechanism);
        this.pParameter = params.getPointer();
        this.ulParameterLen = new NativeLong((long)params.size());
    }

    public CK_MECHANISM(long mechanism, CK_SSL3_KEY_MAT_PARAMS params) {
        this.mechanism = new NativeLong(mechanism);
        this.pParameter = params.getPointer();
        this.ulParameterLen = new NativeLong((long)params.size());
    }

    public CK_MECHANISM(long mechanism, CK_TLS_PRF_PARAMS params) {
        this.mechanism = new NativeLong(mechanism);
        this.pParameter = params.getPointer();
        this.ulParameterLen = new NativeLong((long)params.size());
    }

    public CK_MECHANISM(long mechanism, CK_ECDH1_DERIVE_PARAMS params) {
        this.mechanism = new NativeLong(mechanism);
        this.pParameter = params.getPointer();
        this.ulParameterLen = new NativeLong((long)params.size());
    }

    public CK_MECHANISM(long mechanism, CK_AES_CTR_PARAMS params) {
        this.mechanism = new NativeLong(mechanism);
        this.pParameter = params.getPointer();
        this.ulParameterLen = new NativeLong((long)params.size());
    }

    public CK_MECHANISM(long mechanism, Long params) {
        this.mechanism = new NativeLong(mechanism);
        this.pParameter = new NativeLongByReference(new NativeLong(params.longValue())).getPointer();
        this.ulParameterLen = new NativeLong((long)NativeLong.SIZE);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("  ");
        buffer.append("mechanism: ");
        buffer.append(this.mechanism);
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("pParameter: ");
        buffer.append(this.pParameter);
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("ulParameterLen: ");
        buffer.append(this.ulParameterLen);
        return buffer.toString();
    }

    public long getMechanism() {
        return Functions.ckUlongTojLong(this.mechanism);
    }
}

