/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.sm;

import cn.topca.security.jca.JCAJCEUtil;
import cn.topca.security.sm.SM4KeyGenerator;
import cn.topca.security.sm.TopSMProvider;
import cn.topca.security.x509.AlgorithmId;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGenerator;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KeyGeneratorAgent {
    private final KeyGeneratorSpi spi;
    private final KeyGenerator gen;
    private final String algroithm;
    private final Provider provider;

    public KeyGeneratorAgent(KeyGenerator keyGenerator) {
        this.spi = null;
        this.gen = keyGenerator;
        this.algroithm = keyGenerator.getAlgorithm();
        this.provider = keyGenerator.getProvider();
    }

    private KeyGeneratorAgent(KeyGeneratorSpi spi, String algroithm, Provider provider) {
        this.gen = null;
        this.spi = spi;
        this.algroithm = algroithm;
        this.provider = provider;
    }

    public static KeyGeneratorAgent getInstance(String algorithm) throws NoSuchAlgorithmException {
        String algName;
        try {
            algName = AlgorithmId.get(algorithm).getName();
        }
        catch (NoSuchAlgorithmException e) {
            algName = algorithm;
        }
        if (algName.startsWith("SM4")) {
            return new KeyGeneratorAgent(new SM4KeyGenerator(), algName, TopSMProvider.INSTANCE);
        }
        return new KeyGeneratorAgent(KeyGenerator.getInstance(algorithm));
    }

    public static KeyGeneratorAgent getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        try {
            KeyGenerator cipher = KeyGenerator.getInstance(algorithm, provider);
            return new KeyGeneratorAgent(cipher);
        }
        catch (Exception e) {
            KeyGeneratorSpi spi = null;
            Provider.Service service = provider.getService("KeyGenerator", algorithm);
            spi = (KeyGeneratorSpi)service.newInstance(null);
            if (spi == null) {
                throw new NoSuchAlgorithmException(algorithm);
            }
            return new KeyGeneratorAgent(spi, algorithm, provider);
        }
    }

    public static KeyGeneratorAgent getInstance(String algorighm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return KeyGeneratorAgent.getInstance(algorighm, p);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getAlgorithm() {
        return this.algroithm;
    }

    public final void init(SecureRandom random) {
        if (this.gen != null) {
            this.gen.init(random);
            return;
        }
        this.invokeSpi("engineInit", new Class[]{SecureRandom.class}, random);
    }

    public final void init(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        this.init(params, JCAJCEUtil.getSecureRandom());
    }

    public final void init(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (this.gen != null) {
            this.gen.init(params, random);
            return;
        }
        this.invokeSpi("engineInit", new Class[]{AlgorithmParameterSpec.class, SecureRandom.class}, params, random);
    }

    public final void init(int keysize) {
        this.init(keysize, JCAJCEUtil.getSecureRandom());
    }

    public final void init(int keysize, SecureRandom random) {
        if (this.gen != null) {
            this.gen.init(keysize, random);
            return;
        }
        this.invokeSpi("engineInit", new Class[]{Integer.TYPE, SecureRandom.class}, keysize, random);
    }

    public final SecretKey generateKey() {
        if (this.gen != null) {
            return this.gen.generateKey();
        }
        return (SecretKey)this.invokeSpi("engineGenerateKey", null, new Object[0]);
    }

    private Object invokeSpi(String methodName, Class<?>[] parameterTypes, Object ... args) {
        try {
            Method method;
            try {
                method = this.spi.getClass().getDeclaredMethod(methodName, parameterTypes);
                method.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                method = this.spi.getClass().getMethod(methodName, parameterTypes);
            }
            return method.invoke((Object)this.spi, args);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }
}

